/*
 * Decompiled with CFR 0.152.
 */
package prefuse.action.assignment;

import java.awt.BasicStroke;
import java.awt.Stroke;
import java.util.logging.Logger;
import prefuse.action.EncoderAction;
import prefuse.data.expression.Predicate;
import prefuse.data.expression.parser.ExpressionParser;
import prefuse.util.StrokeLib;
import prefuse.visual.VisualItem;

public class StrokeAction
extends EncoderAction {
    protected BasicStroke defaultStroke = StrokeLib.getStroke(1.0f);

    public StrokeAction() {
    }

    public StrokeAction(String group) {
        super(group);
    }

    public StrokeAction(String group, BasicStroke defaultStroke) {
        super(group);
        this.defaultStroke = defaultStroke;
    }

    public void setDefaultStroke(BasicStroke f) {
        this.defaultStroke = f;
    }

    public BasicStroke getDefaultStroke() {
        return this.defaultStroke;
    }

    public void add(Predicate p, BasicStroke stroke) {
        super.add(p, stroke);
    }

    public void add(String expr, BasicStroke stroke) {
        Predicate p = (Predicate)ExpressionParser.parse(expr);
        this.add(p, stroke);
    }

    public void add(Predicate p, StrokeAction f) {
        super.add(p, f);
    }

    public void add(String expr, StrokeAction f) {
        Predicate p = (Predicate)ExpressionParser.parse(expr);
        super.add(p, f);
    }

    public void process(VisualItem item, double frac) {
        item.setStroke(this.getStroke(item));
    }

    public BasicStroke getStroke(VisualItem item) {
        Object o = this.lookup(item);
        if (o != null) {
            if (o instanceof StrokeAction) {
                return ((StrokeAction)o).getStroke(item);
            }
            if (o instanceof Stroke) {
                return (BasicStroke)o;
            }
            Logger.getLogger(this.getClass().getName()).warning("Unrecognized Object from predicate chain.");
        }
        return this.defaultStroke;
    }
}

