/*
 * Decompiled with CFR 0.152.
 */
package prefuse.render;

import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import prefuse.render.AbstractShapeRenderer;
import prefuse.visual.VisualItem;

public class ShapeRenderer
extends AbstractShapeRenderer {
    private int m_baseSize = 10;
    private Ellipse2D m_ellipse = new Ellipse2D.Double();
    private Rectangle2D m_rect = new Rectangle2D.Double();
    private GeneralPath m_path = new GeneralPath();

    public ShapeRenderer() {
    }

    public ShapeRenderer(int size) {
        this.setBaseSize(size);
    }

    public void setBaseSize(int size) {
        this.m_baseSize = size;
    }

    public int getBaseSize() {
        return this.m_baseSize;
    }

    protected Shape getRawShape(VisualItem item) {
        double width;
        double y;
        int stype = item.getShape();
        double x = item.getX();
        if (Double.isNaN(x) || Double.isInfinite(x)) {
            x = 0.0;
        }
        if (Double.isNaN(y = item.getY()) || Double.isInfinite(y)) {
            y = 0.0;
        }
        if ((width = (double)this.m_baseSize * item.getSize()) > 1.0) {
            x -= width / 2.0;
            y -= width / 2.0;
        }
        switch (stype) {
            case -1: {
                return null;
            }
            case 0: {
                return this.rectangle(x, y, width, width);
            }
            case 1: {
                return this.ellipse(x, y, width, width);
            }
            case 5: {
                return this.triangle_up((float)x, (float)y, (float)width);
            }
            case 6: {
                return this.triangle_down((float)x, (float)y, (float)width);
            }
            case 7: {
                return this.triangle_left((float)x, (float)y, (float)width);
            }
            case 8: {
                return this.triangle_right((float)x, (float)y, (float)width);
            }
            case 3: {
                return this.cross((float)x, (float)y, (float)width);
            }
            case 4: {
                return this.star((float)x, (float)y, (float)width);
            }
            case 9: {
                return this.hexagon((float)x, (float)y, (float)width);
            }
            case 2: {
                return this.diamond((float)x, (float)y, (float)width);
            }
        }
        throw new IllegalStateException("Unknown shape type: " + stype);
    }

    public Shape rectangle(double x, double y, double width, double height) {
        this.m_rect.setFrame(x, y, width, height);
        return this.m_rect;
    }

    public Shape ellipse(double x, double y, double width, double height) {
        this.m_ellipse.setFrame(x, y, width, height);
        return this.m_ellipse;
    }

    public Shape triangle_up(float x, float y, float height) {
        this.m_path.reset();
        this.m_path.moveTo(x, y + height);
        this.m_path.lineTo(x + height / 2.0f, y);
        this.m_path.lineTo(x + height, y + height);
        this.m_path.closePath();
        return this.m_path;
    }

    public Shape triangle_down(float x, float y, float height) {
        this.m_path.reset();
        this.m_path.moveTo(x, y);
        this.m_path.lineTo(x + height, y);
        this.m_path.lineTo(x + height / 2.0f, y + height);
        this.m_path.closePath();
        return this.m_path;
    }

    public Shape triangle_left(float x, float y, float height) {
        this.m_path.reset();
        this.m_path.moveTo(x + height, y);
        this.m_path.lineTo(x + height, y + height);
        this.m_path.lineTo(x, y + height / 2.0f);
        this.m_path.closePath();
        return this.m_path;
    }

    public Shape triangle_right(float x, float y, float height) {
        this.m_path.reset();
        this.m_path.moveTo(x, y + height);
        this.m_path.lineTo(x + height, y + height / 2.0f);
        this.m_path.lineTo(x, y);
        this.m_path.closePath();
        return this.m_path;
    }

    public Shape cross(float x, float y, float height) {
        float h14 = 3.0f * height / 8.0f;
        float h34 = 5.0f * height / 8.0f;
        this.m_path.reset();
        this.m_path.moveTo(x + h14, y);
        this.m_path.lineTo(x + h34, y);
        this.m_path.lineTo(x + h34, y + h14);
        this.m_path.lineTo(x + height, y + h14);
        this.m_path.lineTo(x + height, y + h34);
        this.m_path.lineTo(x + h34, y + h34);
        this.m_path.lineTo(x + h34, y + height);
        this.m_path.lineTo(x + h14, y + height);
        this.m_path.lineTo(x + h14, y + h34);
        this.m_path.lineTo(x, y + h34);
        this.m_path.lineTo(x, y + h14);
        this.m_path.lineTo(x + h14, y + h14);
        this.m_path.closePath();
        return this.m_path;
    }

    public Shape star(float x, float y, float height) {
        float s = (float)((double)height / (2.0 * Math.sin(Math.toRadians(54.0))));
        float shortSide = (float)((double)height / (2.0 * Math.tan(Math.toRadians(54.0))));
        float mediumSide = (float)((double)s * Math.sin(Math.toRadians(18.0)));
        float longSide = (float)((double)s * Math.cos(Math.toRadians(18.0)));
        float innerLongSide = (float)((double)s / (2.0 * Math.cos(Math.toRadians(36.0))));
        float innerShortSide = innerLongSide * (float)Math.sin(Math.toRadians(36.0));
        float innerMediumSide = innerLongSide * (float)Math.cos(Math.toRadians(36.0));
        this.m_path.reset();
        this.m_path.moveTo(x, y + shortSide);
        this.m_path.lineTo(x + innerLongSide, y + shortSide);
        this.m_path.lineTo(x + height / 2.0f, y);
        this.m_path.lineTo(x + height - innerLongSide, y + shortSide);
        this.m_path.lineTo(x + height, y + shortSide);
        this.m_path.lineTo(x + height - innerMediumSide, y + shortSide + innerShortSide);
        this.m_path.lineTo(x + height - mediumSide, y + height);
        this.m_path.lineTo(x + height / 2.0f, y + shortSide + longSide - innerShortSide);
        this.m_path.lineTo(x + mediumSide, y + height);
        this.m_path.lineTo(x + innerMediumSide, y + shortSide + innerShortSide);
        this.m_path.closePath();
        return this.m_path;
    }

    public Shape hexagon(float x, float y, float height) {
        float width = height / 2.0f;
        this.m_path.reset();
        this.m_path.moveTo(x, y + 0.5f * height);
        this.m_path.lineTo(x + 0.5f * width, y);
        this.m_path.lineTo(x + 1.5f * width, y);
        this.m_path.lineTo(x + 2.0f * width, y + 0.5f * height);
        this.m_path.lineTo(x + 1.5f * width, y + height);
        this.m_path.lineTo(x + 0.5f * width, y + height);
        this.m_path.closePath();
        return this.m_path;
    }

    public Shape diamond(float x, float y, float height) {
        this.m_path.reset();
        this.m_path.moveTo(x, y + 0.5f * height);
        this.m_path.lineTo(x + 0.5f * height, y);
        this.m_path.lineTo(x + height, y + 0.5f * height);
        this.m_path.lineTo(x + 0.5f * height, y + height);
        this.m_path.closePath();
        return this.m_path;
    }
}

