/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.evaluation;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.evaluation.AbstractLogger;
import org.eclipse.ocl.pivot.evaluation.EvaluationLogger;

public abstract class IndentingLogger
extends AbstractLogger {
    public static final @NonNull EvaluationLogger OUT = new IndentingLogger(){

        @Override
        protected void print(@NonNull String string) {
            System.out.print(string);
        }
    };
    private int indentationLevel = 0;
    private final @NonNull StringBuilder s = new StringBuilder();

    @Override
    public void append(@NonNull String message) {
        int i = 0;
        while (i < message.length()) {
            if (this.s.length() == 0) {
                this.indent(this.indentationLevel);
            }
            char c = message.charAt(i);
            this.s.append(c);
            if (c == '\n') {
                this.print(this.s.toString());
                this.s.setLength(0);
            }
            ++i;
        }
    }

    @Override
    public void close() {
        if (this.s.length() > 0) {
            this.print(this.s.toString());
            this.s.setLength(0);
        }
    }

    protected void indent(int depth) {
        int k = 0;
        while (k < depth) {
            this.s.append(k % 5 == 0 ? ". " : "  ");
            ++k;
        }
    }

    @Override
    public void popIndentation() {
        if (this.indentationLevel > 0) {
            --this.indentationLevel;
        }
    }

    @Override
    public void pushIndentation() {
        ++this.indentationLevel;
    }
}

