/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.resource;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.Constraint;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.Feature;
import org.eclipse.ocl.pivot.InvalidType;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.PivotPackage;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.internal.resource.AS2ID;
import org.eclipse.ocl.pivot.internal.resource.ASResourceFactory;
import org.eclipse.ocl.pivot.internal.resource.ASResourceFactoryRegistry;
import org.eclipse.ocl.pivot.internal.resource.ASSaverNew;
import org.eclipse.ocl.pivot.internal.resource.AbstractASSaver;
import org.eclipse.ocl.pivot.internal.resource.LUSSIDs;
import org.eclipse.ocl.pivot.internal.resource.PivotSaveImpl;
import org.eclipse.ocl.pivot.internal.utilities.AS2XMIid;
import org.eclipse.ocl.pivot.internal.utilities.PivotObjectImpl;
import org.eclipse.ocl.pivot.resource.ASResource;
import org.eclipse.ocl.pivot.utilities.AS2XMIidVisitor;
import org.eclipse.ocl.pivot.utilities.TracingAdapter;
import org.eclipse.ocl.pivot.utilities.TracingOption;
import org.eclipse.ocl.pivot.utilities.TreeIterable;
import org.eclipse.ocl.pivot.utilities.XMIUtil;

public class ASResourceImpl
extends XMIResourceImpl
implements ASResource {
    public static final TracingOption CHECK_IMMUTABILITY = new TracingOption("org.eclipse.ocl.pivot", "resource/checkImmutability");
    public static boolean SKIP_CHECK_BAD_REFERENCES = false;
    private @Nullable ImmutabilityCheckingAdapter immutabilityCheckingAdapter = null;
    protected final @NonNull ASResourceFactory asResourceFactory;
    private @Nullable LUSSIDs lussids = null;
    private @Nullable Map<@NonNull String, @NonNull EObject> legacyXMIId2eObject = null;
    private boolean isSaveable = true;
    private boolean isUnloading = false;
    private boolean isUpdating = false;

    public ASResourceImpl(@NonNull URI uri, @NonNull ASResourceFactory asResourceFactory) {
        super(uri);
        this.asResourceFactory = asResourceFactory;
    }

    @Override
    public @Nullable EObject basicGetEObjectByID(@Nullable String id) {
        return this.idToEObjectMap != null ? (EObject)this.idToEObjectMap.get(id) : null;
    }

    @Override
    public @Nullable LUSSIDs basicGetLUSSIDs() {
        return this.lussids;
    }

    public NotificationChain basicSetResourceSet(ResourceSet resourceSet, NotificationChain notifications) {
        Object resourceFactory;
        String fileExtension;
        NotificationChain notificationChain = super.basicSetResourceSet(resourceSet, notifications);
        if (resourceSet != null && (fileExtension = this.getURI().fileExtension()) != null && (resourceFactory = resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().get(fileExtension)) == null) {
            ASResourceFactoryRegistry.INSTANCE.configureResourceFactoryRegistry(resourceSet);
        }
        return notificationChain;
    }

    protected @NonNull ImmutabilityCheckingAdapter createImmutabilityCheckingAdapter() {
        return new ImmutabilityCheckingAdapter();
    }

    protected @NonNull AbstractASSaver createASSaver() {
        return new ASSaverNew(this);
    }

    protected @NonNull PivotSaveImpl.PivotXMIHelperImpl createXMLHelper() {
        return new PivotSaveImpl.PivotXMIHelperImpl(this);
    }

    protected @NonNull PivotSaveImpl createXMLSave() {
        return new PivotSaveImpl((XMLHelper)this.createXMLHelper());
    }

    protected void doUnload() {
        this.isUnloading = true;
        try {
            super.doUnload();
            if (this.lussids != null) {
                this.resetLUSSIDs();
            }
        }
        finally {
            this.isUnloading = false;
        }
    }

    @Override
    public @NonNull ASResourceFactory getASResourceFactory() {
        return this.asResourceFactory;
    }

    public @NonNull Map<Object, Object> getDefaultSaveOptions() {
        Map<Object, Object> defaultSaveOptions2 = this.defaultSaveOptions;
        if (defaultSaveOptions2 == null) {
            this.defaultSaveOptions = defaultSaveOptions2 = XMIUtil.createPivotSaveOptions();
        }
        return defaultSaveOptions2;
    }

    protected EObject getEObjectByID(String id) {
        if (this.unloadingContents == null && this.idToEObjectMap == null) {
            AS2ID.assignIds(this, null);
        }
        if (this.idToEObjectMap == null) {
            return null;
        }
        EObject eObject = (EObject)this.idToEObjectMap.get(id);
        if (eObject != null) {
            return eObject;
        }
        if (this.isLoading()) {
            return null;
        }
        Map<@NonNull String, @NonNull EObject> legacyXMIId2eObject2 = this.legacyXMIId2eObject;
        if (legacyXMIId2eObject2 == null) {
            AS2XMIid as2id = new AS2XMIid();
            this.legacyXMIId2eObject = legacyXMIId2eObject2 = new HashMap<String, EObject>();
            for (EObject eObject2 : new TreeIterable((Resource)this)) {
                String legacyId;
                AS2XMIidVisitor idVisitor;
                Element element;
                Boolean status;
                if (!(eObject2 instanceof Element) || (status = (element = (Element)eObject2).accept(idVisitor = this.asResourceFactory.createAS2XMIidVisitor(as2id))) != Boolean.TRUE || (legacyId = idVisitor.toString()) == null) continue;
                legacyXMIId2eObject2.put(legacyId, eObject2);
            }
        }
        EObject eObject2 = legacyXMIId2eObject2.get(id);
        return eObject2;
    }

    @Override
    public @NonNull LUSSIDs getLUSSIDs(@NonNull Map<@NonNull Object, @Nullable Object> options) {
        LUSSIDs lussids2 = this.lussids;
        if (lussids2 == null) {
            this.lussids = lussids2 = ((ASResourceFactory.ASResourceFactoryExtension)this.asResourceFactory).createLUSSIDs(this, options);
        }
        return lussids2;
    }

    @Override
    public @NonNull Model getModel() {
        EList contents = this.getContents();
        if (contents.size() <= 0) {
            throw new IllegalStateException("No Model at root of empty '" + this.getURI() + "'");
        }
        EObject eObject = (EObject)contents.get(0);
        if (!(eObject instanceof Model)) {
            throw new IllegalStateException("Non-Model at root of '" + this.getURI() + "'");
        }
        return (Model)eObject;
    }

    @Override
    public int getXmiidVersion() {
        for (EObject eRoot : this.getContents()) {
            Number xmiidVersion;
            if (!(eRoot instanceof Model) || (xmiidVersion = ((Model)eRoot).getXmiidVersion()) == null) continue;
            return xmiidVersion.intValue();
        }
        return 0;
    }

    private boolean isFreeOfBadReferences() throws IOException {
        int len;
        InputStream inputStream = this.getResourceSet().getURIConverter().createInputStream(this.uri);
        InputStreamReader reader = new InputStreamReader(inputStream);
        StringBuilder s = new StringBuilder();
        char[] buf = new char[4096];
        while ((len = reader.read(buf)) > 0) {
            s.append(buf, 0, len);
        }
        ((Reader)reader).close();
        String string = s.toString();
        int index = string.indexOf("#//@");
        if (index < 0) {
            return true;
        }
        int preIndex = string.lastIndexOf("\n", index);
        int postIndex = string.indexOf("\n", index);
        String refText = string.substring(preIndex, postIndex).trim();
        System.err.println("Missing xmi:id for reference in '" + this.uri + "'\n\t" + refText);
        return false;
    }

    @Override
    public boolean isOrphanage() {
        return false;
    }

    @Override
    public boolean isSaveable() {
        return this.isSaveable;
    }

    @Override
    public void resetLUSSIDs() {
        LUSSIDs lussids2 = this.lussids;
        if (lussids2 != null) {
            this.lussids = null;
            lussids2.dispose();
        }
    }

    public void save(Map<?, ?> options) throws IOException {
        if (this.isSaveable) {
            this.setXmiidVersion(1);
            if (options == null) {
                options = this.getDefaultSaveOptions();
            }
            XMIUtil.IdResourceEntityHandler.reset(options);
            super.save(options);
            assert (SKIP_CHECK_BAD_REFERENCES || this.isFreeOfBadReferences());
        }
    }

    @Override
    public boolean setSaveable(boolean isSaveable) {
        boolean wasSaveable = this.isSaveable;
        this.isSaveable = isSaveable;
        if (isSaveable) {
            if (this.immutabilityCheckingAdapter != null) {
                this.eAdapters().remove((Object)this.immutabilityCheckingAdapter);
                TreeIterator i = this.getAllProperContents((List)this.getContents());
                while (i.hasNext()) {
                    EObject eObject = (EObject)i.next();
                    eObject.eAdapters().remove((Object)this.immutabilityCheckingAdapter);
                }
                this.immutabilityCheckingAdapter = null;
            }
        } else if (wasSaveable && CHECK_IMMUTABILITY.isActive()) {
            if (this.immutabilityCheckingAdapter == null) {
                this.immutabilityCheckingAdapter = this.createImmutabilityCheckingAdapter();
            }
            TreeIterator i = this.getAllProperContents((List)this.getContents());
            while (i.hasNext()) {
                EObject eObject = (EObject)i.next();
                eObject.eAdapters().add((Object)this.immutabilityCheckingAdapter);
            }
            this.eAdapters().add((Object)this.immutabilityCheckingAdapter);
        }
        return wasSaveable;
    }

    @Override
    public boolean setUpdating(boolean isUpdating) {
        boolean wasUpdating = this.isUpdating;
        this.isUpdating = isUpdating;
        return wasUpdating;
    }

    @Override
    public void setXmiidVersion(int xmiidVersion) {
        for (EObject eRoot : this.getContents()) {
            if (!(eRoot instanceof Model)) continue;
            ((Model)eRoot).setXmiidVersion(xmiidVersion);
        }
    }

    protected String superGetURIFragment(EObject eObject) {
        return super.getURIFragment(eObject);
    }

    protected void unloaded(InternalEObject internalEObject) {
        if (internalEObject instanceof PivotObjectImpl) {
            ((PivotObjectImpl)internalEObject).unloaded(this);
        }
        super.unloaded(internalEObject);
    }

    protected boolean useIDAttributes() {
        return false;
    }

    protected boolean useIDs() {
        return true;
    }

    protected class ImmutabilityCheckingAdapter
    extends AdapterImpl {
        protected ImmutabilityCheckingAdapter() {
        }

        private @NonNull String formatMutationMessage(@NonNull Notification notification) {
            StringBuilder s = new StringBuilder();
            s.append("'");
            s.append(ASResourceImpl.this.getURI());
            s.append("' modified at a '");
            s.append(TracingAdapter.getFeatureType(notification));
            s.append("'");
            return s.toString();
        }

        public void notifyChanged(Notification notification) {
            if (!(notification.isTouch() || ASResourceImpl.this.isUpdating || ASResourceImpl.this.isUnloading)) {
                Object notifier = notification.getNotifier();
                Object feature = notification.getFeature();
                int eventType = notification.getEventType();
                if (eventType == 3) {
                    if (notifier instanceof Resource) {
                        int featureID = notification.getFeatureID(Resource.class);
                        if (featureID == 6) {
                            return;
                        }
                        if (featureID == 7) {
                            return;
                        }
                    } else if (notifier instanceof Element) {
                        if (feature == PivotPackage.Literals.ELEMENT__OWNED_EXTENSIONS) {
                            return;
                        }
                        if (notifier instanceof ExpressionInOCL) {
                            if (feature == PivotPackage.Literals.EXPRESSION_IN_OCL__OWNED_PARAMETERS) {
                                return;
                            }
                        } else if (notifier instanceof Class) {
                            if (feature == PivotPackage.Literals.CLASS__OWNED_PROPERTIES) {
                                Object newValue = notification.getNewValue();
                                if (newValue instanceof Property && ((Property)newValue).isIsImplicit()) {
                                    return;
                                }
                                return;
                            }
                            boolean cfr_ignored_0 = notifier instanceof InvalidType;
                        }
                    }
                } else if (eventType == 4) {
                    if (notifier instanceof Class && feature == PivotPackage.Literals.CLASS__OWNED_PROPERTIES) {
                        Object oldValue = notification.getOldValue();
                        if (oldValue instanceof Property && ((Property)oldValue).isIsImplicit()) {
                            return;
                        }
                        return;
                    }
                } else if (eventType == 1) {
                    if (notifier instanceof Resource) {
                        int featureID = notification.getFeatureID(Resource.class);
                        if (featureID == 4) {
                            return;
                        }
                        if (featureID == 8) {
                            return;
                        }
                    } else if (notifier instanceof Feature) {
                        Object oldValue;
                        if (feature == PivotPackage.Literals.FEATURE__IMPLEMENTATION && (oldValue = notification.getOldValue()) == null) {
                            return;
                        }
                        if (notifier instanceof Property) {
                            ((Property)notifier).isIsImplicit();
                        }
                    } else if (notifier instanceof Constraint) {
                        if (feature == PivotPackage.Literals.CONSTRAINT__OWNED_SPECIFICATION) {
                            return;
                        }
                    } else if (notifier instanceof ExpressionInOCL) {
                        if (feature == PivotPackage.Literals.EXPRESSION_IN_OCL__OWNED_BODY) {
                            return;
                        }
                        if (feature == PivotPackage.Literals.EXPRESSION_IN_OCL__OWNED_CONTEXT) {
                            return;
                        }
                        if (feature == PivotPackage.Literals.EXPRESSION_IN_OCL__OWNED_RESULT) {
                            return;
                        }
                        if (feature == PivotPackage.Literals.LANGUAGE_EXPRESSION__BODY) {
                            return;
                        }
                        if (feature == PivotPackage.Literals.LANGUAGE_EXPRESSION__OWNING_CONSTRAINT) {
                            return;
                        }
                        if (feature == PivotPackage.Literals.TYPED_ELEMENT__IS_REQUIRED) {
                            return;
                        }
                        if (feature == PivotPackage.Literals.TYPED_ELEMENT__TYPE) {
                            return;
                        }
                    }
                }
                throw new IllegalStateException(this.formatMutationMessage(notification));
            }
        }

        public void setTarget(Notifier newTarget) {
        }

        public void unsetTarget(Notifier oldTarget) {
        }
    }

    public static interface ImmutableResource {
        public boolean isCompatibleWith(@NonNull String var1);
    }
}

