/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.java.codegen.xtend;

import com.google.common.base.Objects;
import java.util.Collection;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.designer.languages.common.base.GenUtils;
import org.eclipse.papyrus.designer.languages.java.codegen.Constants;
import org.eclipse.papyrus.designer.languages.java.codegen.utils.JavaGenUtils;
import org.eclipse.papyrus.designer.languages.java.codegen.utils.Modifier;
import org.eclipse.papyrus.designer.languages.java.codegen.xtend.JavaDocumentation;
import org.eclipse.papyrus.designer.languages.java.codegen.xtend.JavaParameter;
import org.eclipse.papyrus.designer.languages.java.profile.PapyrusJava.Default;
import org.eclipse.papyrus.designer.languages.java.profile.PapyrusJava.Native;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.profile.standard.Create;
import org.eclipse.uml2.uml.util.UMLUtil;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;

public class JavaOperations {
    public static CharSequence javaOperationImplementation(Operation operation) {
        StringConcatenation _builder = new StringConcatenation();
        String _body = GenUtils.getBody((Operation)operation, (Pattern)Constants.supportedLanguages);
        _builder.append(_body, "");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public static String javaReturnSpec(Operation operation) {
        boolean _isConstructor;
        String _xifexpression = null;
        boolean _or = false;
        Type _type = operation.getType();
        boolean _equals = Objects.equal((Object)_type, null);
        _or = _equals ? true : (_isConstructor = JavaOperations.isConstructor(operation));
        if (_or) {
            _xifexpression = JavaOperations.constructorOrVoid(operation);
        } else {
            Type _type_1 = operation.getType();
            Element _owner = operation.getOwner();
            String _javaQualifiedName = JavaGenUtils.javaQualifiedName((NamedElement)_type_1, _owner);
            Parameter _returnParameter = JavaOperations.returnParameter(operation);
            String _modArray = Modifier.modArray((Element)_returnParameter);
            String _plus = String.valueOf(_javaQualifiedName) + _modArray;
            _xifexpression = String.valueOf(_plus) + " ";
        }
        return _xifexpression;
    }

    public static Parameter returnParameter(Operation operation) {
        EList _returnResult = operation.returnResult();
        for (Parameter parameter : _returnResult) {
            boolean _and = false;
            ParameterDirectionKind _direction = parameter.getDirection();
            boolean _equals = Objects.equal((Object)_direction, (Object)ParameterDirectionKind.RETURN_LITERAL);
            if (!_equals) {
                _and = false;
            } else {
                boolean _equals_1;
                Type _type = parameter.getType();
                Type _type_1 = operation.getType();
                _and = _equals_1 = Objects.equal((Object)_type, (Object)_type_1);
            }
            if (!_and) continue;
            return parameter;
        }
        return null;
    }

    public static CharSequence throwss(Operation operation) {
        boolean _greaterThan;
        StringConcatenation _builder = new StringConcatenation();
        EList _raisedExceptions = operation.getRaisedExceptions();
        int _length = ((Object[])Conversions.unwrapArray((Object)_raisedExceptions, Object.class)).length;
        boolean bl = _greaterThan = _length > 0;
        if (_greaterThan) {
            _builder.append("throws ");
            EList _raisedExceptions_1 = operation.getRaisedExceptions();
            boolean _hasElements = false;
            for (Type re : _raisedExceptions_1) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)",", "");
                }
                String _name = re.getName();
                _builder.append(_name, "");
            }
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public static String constructorOrVoid(Operation operation) {
        String _xifexpression = null;
        boolean _isConstructor = JavaOperations.isConstructor(operation);
        _xifexpression = _isConstructor ? "" : "void ";
        return _xifexpression;
    }

    public static boolean isConstructor(Operation operation) {
        return GenUtils.hasStereotype((Element)operation, Create.class);
    }

    public static Collection<Operation> getOwnedOperations(Classifier cl) {
        EList<Operation> _xblockexpression = null;
        EList<Operation> operations = JavaOperations.getOwnedOperationsWNull(cl);
        EList<Operation> _xifexpression = null;
        boolean _equals = Objects.equal(operations, null);
        _xifexpression = _equals ? CollectionLiterals.emptySet() : operations;
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public static EList<Operation> getOwnedOperationsWNull(Classifier cl) {
        EList _xifexpression = null;
        if (cl instanceof Class) {
            _xifexpression = ((Class)cl).getOwnedOperations();
        } else {
            EList _xifexpression_1 = null;
            if (cl instanceof DataType) {
                _xifexpression_1 = ((DataType)cl).getOwnedOperations();
            } else {
                EList _xifexpression_2 = null;
                _xifexpression_2 = cl instanceof Interface ? ((Interface)cl).getOwnedOperations() : null;
                _xifexpression_1 = _xifexpression_2;
            }
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    public static CharSequence javaOperationDeclaration(Operation operation) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _javaOperationDoc = JavaDocumentation.javaOperationDoc(operation);
        _builder.append((Object)_javaOperationDoc, "");
        _builder.newLineIfNotEmpty();
        String _methodModifiers = Modifier.methodModifiers(operation);
        _builder.append(_methodModifiers, "");
        String _javaReturnSpec = JavaOperations.javaReturnSpec(operation);
        _builder.append(_javaReturnSpec, "");
        String _name = operation.getName();
        _builder.append(_name, "");
        _builder.append("(");
        CharSequence _javaOperationParameters = JavaParameter.javaOperationParameters(operation);
        _builder.append((Object)_javaOperationParameters, "");
        _builder.append(") ");
        CharSequence _throwss = JavaOperations.throwss(operation);
        _builder.append((Object)_throwss, "");
        boolean _mustGenerateBody = JavaOperations.mustGenerateBody(operation);
        if (_mustGenerateBody) {
            _builder.append("{");
        } else {
            _builder.append(";");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        boolean _mustGenerateBody_1 = JavaOperations.mustGenerateBody(operation);
        if (_mustGenerateBody_1) {
            CharSequence _javaOperationImplementation = JavaOperations.javaOperationImplementation(operation);
            _builder.append((Object)_javaOperationImplementation, "\t");
        }
        _builder.newLineIfNotEmpty();
        boolean _mustGenerateBody_2 = JavaOperations.mustGenerateBody(operation);
        if (_mustGenerateBody_2) {
            _builder.append("}");
        }
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public static boolean isAbstract(Operation operation) {
        Interface _interface;
        boolean _notEquals;
        boolean _or = false;
        boolean _and = false;
        boolean _and_1 = false;
        boolean _isAbstract = operation.isAbstract();
        if (!_isAbstract) {
            _and_1 = false;
        } else {
            Element _owner = operation.getOwner();
            _and_1 = _owner instanceof Classifier;
        }
        if (!_and_1) {
            _and = false;
        } else {
            boolean _or_1 = false;
            Element _owner_1 = operation.getOwner();
            boolean _isAbstract_1 = ((Classifier)_owner_1).isAbstract();
            if (_isAbstract_1) {
                _or_1 = true;
            } else {
                Element _owner_2 = operation.getOwner();
                _or_1 = _owner_2 instanceof Enumeration;
            }
            _and = _or_1;
        }
        _or = _and ? true : (_notEquals = !Objects.equal((Object)(_interface = operation.getInterface()), null));
        return _or;
    }

    public static boolean isDefault(Operation operation) {
        Default _stereotypeApplication;
        boolean _notEquals_1;
        boolean _notEquals;
        boolean _and = false;
        Interface _interface = operation.getInterface();
        boolean bl = _notEquals = !Objects.equal((Object)_interface, null);
        _and = !_notEquals ? false : (_notEquals_1 = !Objects.equal((Object)(_stereotypeApplication = (Default)UMLUtil.getStereotypeApplication((Element)operation, Default.class)), null));
        return _and;
    }

    public static boolean mustGenerateBody(Operation operation) {
        boolean _notEquals;
        boolean _not;
        boolean _isAbstract = JavaOperations.isAbstract(operation);
        boolean bl = _not = !_isAbstract;
        if (_not) {
            Native _stereotypeApplication = (Native)UMLUtil.getStereotypeApplication((Element)operation, Native.class);
            return Objects.equal((Object)_stereotypeApplication, null);
        }
        Interface _interface = operation.getInterface();
        boolean _equals = Objects.equal((Object)_interface, null);
        if (_equals) {
            boolean _isStatic = operation.isStatic();
            if (_isStatic) {
                Native _stereotypeApplication_1 = (Native)UMLUtil.getStereotypeApplication((Element)operation, Native.class);
                return Objects.equal((Object)_stereotypeApplication_1, null);
            }
            return false;
        }
        Interface _interface_1 = operation.getInterface();
        boolean bl2 = _notEquals = !Objects.equal((Object)_interface_1, null);
        if (_notEquals) {
            Default _stereotypeApplication_2;
            boolean _notEquals_1;
            boolean _or = false;
            boolean _isStatic_1 = operation.isStatic();
            _or = _isStatic_1 ? true : (_notEquals_1 = !Objects.equal((Object)(_stereotypeApplication_2 = (Default)UMLUtil.getStereotypeApplication((Element)operation, Default.class)), null));
            return _or;
        }
        return true;
    }
}

