/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.components.modellibs.core.transformations;

import java.util.Collection;
import java.util.HashMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.designer.components.FCM.InteractionComponent;
import org.eclipse.papyrus.designer.deployment.tools.DepPlanUtils;
import org.eclipse.papyrus.designer.deployment.tools.DepUtils;
import org.eclipse.papyrus.designer.transformation.base.utils.TransformationException;
import org.eclipse.papyrus.designer.transformation.core.m2minterfaces.IM2MTrafoElem;
import org.eclipse.papyrus.designer.transformation.profile.Transformation.M2MTrafo;
import org.eclipse.papyrus.uml.tools.utils.ConnectorUtil;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.DirectedRelationship;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Slot;
import org.eclipse.uml2.uml.StructuralFeature;
import org.eclipse.uml2.uml.util.UMLUtil;

public class FlattenInteractionComponents
implements IM2MTrafoElem {
    private static final String FLATTEN_SEP = "_";

    public void flattenAssembly(Class composite, InstanceSpecification instance, InstanceSpecification containingInstance, Slot containingSlot) {
        Classifier containingCompositeCl = DepUtils.getClassifier((InstanceSpecification)containingInstance);
        StructuralFeature sfForIA = containingSlot.getDefiningFeature();
        HashMap<Property, Property> replaceParts = new HashMap<Property, Property>();
        if (containingCompositeCl instanceof Class && sfForIA instanceof Property) {
            Class containingComposite = (Class)containingCompositeCl;
            Property partForIA = (Property)sfForIA;
            for (Property fragmentPart : composite.getAllAttributes()) {
                if (fragmentPart instanceof Port) continue;
                String partName = String.valueOf(partForIA.getName()) + FLATTEN_SEP + fragmentPart.getName();
                Property newPartForFragment = containingComposite.createOwnedAttribute(partName, fragmentPart.getType());
                replaceParts.put(fragmentPart, newPartForFragment);
                boolean foundConnector = false;
                for (Connector connector : composite.getOwnedConnectors()) {
                    if (!ConnectorUtil.connectsPart((Connector)connector, (Property)fragmentPart)) continue;
                    foundConnector = true;
                    ConnectorEnd ce = ConnectorUtil.connEndNotPart((Connector)connector, (Property)fragmentPart);
                    if (ce == null || ce.getPartWithPort() != null) continue;
                    Port port = (Port)ce.getRole();
                    this.retargetConnections(containingComposite, port, partForIA, newPartForFragment);
                }
                if (foundConnector) continue;
                throw new RuntimeException("the part <" + fragmentPart.getName() + "> within composite <" + composite.getName() + "> is not connected with any of its ports");
            }
            EList slots = instance.getSlots();
            containingInstance.getSlots().addAll((Collection)slots);
            for (Slot slot : containingInstance.getSlots()) {
                StructuralFeature sf = slot.getDefiningFeature();
                if (!replaceParts.containsKey(sf)) continue;
                slot.setDefiningFeature((StructuralFeature)replaceParts.get(sf));
                InstanceSpecification subInstance = DepUtils.getInstance((Slot)slot);
                if (subInstance == null || DepUtils.isShared((Slot)slot)) continue;
                DepPlanUtils.updateInstanceNames((InstanceSpecification)subInstance, (String)(String.valueOf(instance.getName()) + FLATTEN_SEP + sf.getName()));
            }
            containingSlot.destroy();
            for (DirectedRelationship dr : instance.getSourceDirectedRelationships()) {
                dr.destroy();
            }
            instance.destroy();
            partForIA.destroy();
        }
    }

    public void retargetConnections(Class containingComposite, Port port, Property part, Property subPart) {
        for (Connector connector : containingComposite.getOwnedConnectors()) {
            ConnectorEnd ce;
            if (!ConnectorUtil.connectsPart((Connector)connector, (Property)part) || !ConnectorUtil.connectsPort((Connector)connector, (Port)port) || (ce = ConnectorUtil.connEndForPart((Connector)connector, (Property)part)) == null) continue;
            ce.setPartWithPort(subPart);
        }
    }

    public void transformElement(M2MTrafo trafo, Element element) throws TransformationException {
        InteractionComponent ic;
        InstanceSpecification instance;
        Classifier cl;
        if (element instanceof InstanceSpecification && (cl = DepUtils.getClassifier((InstanceSpecification)(instance = (InstanceSpecification)element))) instanceof Class && (ic = (InteractionComponent)UMLUtil.getStereotypeApplication((Element)cl, InteractionComponent.class)) != null && ic.isForDistribution()) {
            Slot containingSlot = DepUtils.getParentSlot((InstanceSpecification)instance);
            InstanceSpecification containingInstance = containingSlot.getOwningInstance();
            this.flattenAssembly((Class)cl, instance, containingInstance, containingSlot);
        }
    }
}

