/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.cpp.cdt.texteditor.factory;

import org.eclipse.papyrus.designer.languages.cpp.cdt.texteditor.Activator;
import org.eclipse.papyrus.designer.languages.cpp.cdt.texteditor.editor.PapyrusCDTEditor;
import org.eclipse.papyrus.infra.core.editor.BackboneException;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IEditorModel;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IPageModel;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.ui.extension.diagrameditor.AbstractEditorFactory;
import org.eclipse.papyrus.infra.ui.multidiagram.actionbarcontributor.ActionBarContributorRegistry;
import org.eclipse.papyrus.languages.designer.common.texteditor.model.TextEditorModel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorActionBarContributor;

public class PapyrusCDTEditorFactory
extends AbstractEditorFactory {
    public PapyrusCDTEditorFactory() {
        super(PapyrusCDTEditor.class, "CDTEditorInPapyrus");
    }

    public IPageModel createIPageModel(Object pageIdentifier) {
        return new TextEditorModelDelegate(pageIdentifier);
    }

    public boolean isPageModelFactoryFor(Object pageIdentifier) {
        if (pageIdentifier instanceof TextEditorModel) {
            return ((TextEditorModel)pageIdentifier).getType().equals(this.getExpectedType());
        }
        return false;
    }

    class TextEditorModelDelegate
    implements IEditorModel {
        private IEditorPart editor;
        private TextEditorModel rawEditorModel;

        public TextEditorModelDelegate(Object pageIdentifier) {
            this.rawEditorModel = (TextEditorModel)pageIdentifier;
        }

        public IEditorPart createIEditorPart() throws PartInitException {
            try {
                this.editor = new PapyrusCDTEditor(PapyrusCDTEditorFactory.this.getServiceRegistry(), this.rawEditorModel);
                return this.editor;
            }
            catch (Exception e) {
                throw new PartInitException("Can't create TextEditor", (Throwable)e);
            }
        }

        public EditorActionBarContributor getActionBarContributor() {
            ActionBarContributorRegistry registry;
            String actionBarId = PapyrusCDTEditorFactory.this.editorDescriptor.getActionBarContributorId();
            if (actionBarId == null || actionBarId.length() == 0) {
                return null;
            }
            try {
                registry = (ActionBarContributorRegistry)PapyrusCDTEditorFactory.this.getServiceRegistry().getService(ActionBarContributorRegistry.class);
            }
            catch (ServiceException e) {
                Activator.log.error((Throwable)e);
                return null;
            }
            try {
                return registry.getActionBarContributor((Object)actionBarId);
            }
            catch (BackboneException e) {
                Activator.log.error((Throwable)e);
                return null;
            }
        }

        public Object getRawModel() {
            return this.rawEditorModel;
        }

        public Image getTabIcon() {
            org.eclipse.papyrus.infra.widgets.Activator widgetsActivator = org.eclipse.papyrus.infra.widgets.Activator.getDefault();
            if (widgetsActivator == null) {
                return null;
            }
            String path = PapyrusCDTEditorFactory.this.getEditorDescriptor().getIconURL();
            if (path.startsWith("org.eclipse.papyrus.designer.languages.cpp.cdt.texteditor")) {
                path = path.substring("org.eclipse.papyrus.designer.languages.cpp.cdt.texteditor".length());
            }
            return widgetsActivator.getImage("org.eclipse.papyrus.designer.languages.cpp.cdt.texteditor", path);
        }

        public String getTabTitle() {
            return this.rawEditorModel.getName();
        }

        public void dispose() {
        }
    }
}

