/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.java.reverse.ui.dnd;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.designer.languages.java.reverse.ui.dnd.IJobAndTransactionForDrop;
import org.eclipse.papyrus.designer.languages.java.reverse.ui.exception.StopExecutionException;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;

public abstract class AbstractJobAndTransactionForDrop
implements IJobAndTransactionForDrop {
    protected Request request;
    protected EditPart targetEditPart;

    @Override
    public void init(Request request, EditPart targetEditPart) throws StopExecutionException {
        this.request = request;
        this.targetEditPart = targetEditPart;
    }

    protected List<Object> getSourceObjects(Request request) {
        List editParts;
        LinkedList<Object> result = new LinkedList<Object>();
        if (request instanceof DropObjectsRequest) {
            List objects = ((DropObjectsRequest)request).getObjects();
            if (objects != null) {
                result.addAll(objects);
            }
        } else if (request instanceof GroupRequest && (editParts = ((ChangeBoundsRequest)request).getEditParts()) != null) {
            result.addAll(editParts);
        }
        return result;
    }

    protected List<EObject> getSourceEObjects(Request request) {
        LinkedList<EObject> result = new LinkedList<EObject>();
        for (Object object : this.getSourceObjects(request)) {
            EObject eObject = EMFHelper.getEObject((Object)object);
            if (eObject instanceof View) {
                eObject = ((View)eObject).getElement();
            }
            if (eObject == null) continue;
            result.add(eObject);
        }
        return result;
    }
}

