/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.infra.base;

import java.util.concurrent.CancellationException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.papyrus.designer.infra.base.RunnableWithResult;

public class CommandSupport {
    public static void exec(EObject eObject, String label, Runnable command) {
        CommandSupport.exec(TransactionUtil.getEditingDomain((EObject)eObject), label, command);
    }

    public static void exec(EObject eObject, String label, RunnableWithResult command) {
        CommandSupport.exec(TransactionUtil.getEditingDomain((EObject)eObject), label, command);
    }

    public static void exec(TransactionalEditingDomain domain, String label, final Runnable command) {
        if (domain == null) {
            command.run();
        } else {
            domain.getCommandStack().execute((Command)new RecordingCommand(domain, label){

                public void doExecute() {
                    command.run();
                }
            });
        }
    }

    public static void exec(TransactionalEditingDomain domain, String label, final RunnableWithResult command) {
        if (domain == null) {
            command.run();
        } else {
            try {
                domain.getCommandStack().execute((Command)new RecordingCommand(domain, label){

                    public void doExecute() {
                        IStatus status = command.run();
                        if (!status.isOK()) {
                            throw new CancellationException();
                        }
                    }
                });
            }
            catch (CancellationException cancellationException) {
                // empty catch block
            }
        }
    }

    public static void exec(TransactionalEditingDomain domain, Command command) {
        domain.getCommandStack().execute(command);
    }
}

