/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.transformation.tracing.barectf.library;

import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.papyrus.designer.deployment.profile.DepProfileResource;
import org.eclipse.papyrus.designer.deployment.profile.Deployment.ConfigurationProperty;
import org.eclipse.papyrus.designer.deployment.profile.Deployment.InstanceConfigurator;
import org.eclipse.papyrus.designer.deployment.profile.Deployment.UseInstanceConfigurator;
import org.eclipse.papyrus.designer.infra.base.StringUtils;
import org.eclipse.papyrus.designer.languages.common.base.StdUriConstants;
import org.eclipse.papyrus.designer.transformation.tracing.barectf.library.ModelQNames;
import org.eclipse.papyrus.designer.transformation.tracing.barectf.library.flatten.Flattener;
import org.eclipse.papyrus.designer.transformation.tracing.barectf.library.flatten.NameType;
import org.eclipse.papyrus.designer.transformation.tracing.library.EventNames;
import org.eclipse.papyrus.designer.transformation.tracing.library.utils.TraceUtils;
import org.eclipse.papyrus.designer.transformation.tracing.library.utils.TracingUriConstants;
import org.eclipse.papyrus.designer.uml.tools.utils.BehaviorUtils;
import org.eclipse.papyrus.designer.uml.tools.utils.ElementUtils;
import org.eclipse.papyrus.designer.uml.tools.utils.OperationUtils;
import org.eclipse.papyrus.designer.uml.tools.utils.PackageUtil;
import org.eclipse.papyrus.designer.uml.tools.utils.StereotypeUtil;
import org.eclipse.papyrus.moka.tracepoint.service.TraceActions;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.BehavioredClassifier;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.Event;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.SignalEvent;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Trigger;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.profile.standard.Create;
import org.eclipse.uml2.uml.profile.standard.Destroy;
import org.eclipse.uml2.uml.util.UMLUtil;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class InstrumentCTF {
    private static final String prefix = "barectf_default_trace";

    public static void instrument(List<Element> events) {
        Element[] _clone_1;
        Element[] _clone;
        Element[] elementArray = _clone = (Element[])((Element[])Conversions.unwrapArray(events, Element.class)).clone();
        int n = _clone.length;
        int n2 = 0;
        while (n2 < n) {
            Element event = elementArray[n2];
            if (event instanceof Port) {
                Port port = (Port)event;
                Class clazz = port.getClass_();
                EList _provideds = port.getProvideds();
                for (Interface intf : _provideds) {
                    EList _ownedOperations = intf.getOwnedOperations();
                    for (Operation iOp : _ownedOperations) {
                        Operation cOp = OperationUtils.getSameOperation((Operation)iOp, (Class)clazz);
                        if (cOp == null) continue;
                        InstrumentCTF.instrumentOperation(cOp, port);
                        boolean _contains = events.contains(cOp);
                        if (!_contains) continue;
                        events.remove(cOp);
                    }
                }
            }
            ++n2;
        }
        Element[] elementArray2 = _clone_1 = (Element[])((Element[])Conversions.unwrapArray(events, Element.class)).clone();
        int n3 = _clone_1.length;
        n = 0;
        while (n < n3) {
            Element event_1 = elementArray2[n];
            if (event_1 instanceof Transition) {
                Transition transition = (Transition)event_1;
                Behavior effect = transition.getEffect();
                if (effect == null) {
                    effect = transition.createEffect(null, UMLPackage.eINSTANCE.getOpaqueBehavior());
                }
                String attrStr = "";
                boolean _traceTransitionAction = TraceUtils.traceTransitionAction((Transition)transition, (TraceActions.TATransition)TraceActions.TATransition.TriggerValues);
                if (_traceTransitionAction) {
                    EList _triggers = transition.getTriggers();
                    for (Trigger trigger : _triggers) {
                        Event _event = trigger.getEvent();
                        if (!(_event instanceof SignalEvent)) continue;
                        Event _event_1 = trigger.getEvent();
                        SignalEvent sigEvent = (SignalEvent)_event_1;
                        List<NameType> attrList = Flattener.flattenParams(sigEvent.getSignal().getAttributes());
                        String _attrStr = attrStr;
                        StringConcatenation _builder = new StringConcatenation();
                        for (NameType attr : attrList) {
                            _builder.append(", sig.");
                            String _castAndName = InstrumentCTF.castAndName(attr);
                            _builder.append(_castAndName);
                        }
                        attrStr = String.valueOf(_attrStr) + _builder;
                    }
                }
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append(prefix);
                _builder_1.append("_");
                CharSequence _transitionEventName = EventNames.transitionEventName((Transition)transition);
                _builder_1.append((Object)_transitionEventName);
                _builder_1.append("(BareCTFInit::ctx(), instanceName");
                _builder_1.append(attrStr);
                _builder_1.append(");");
                BehaviorUtils.prefixBody((Behavior)effect, (String)_builder_1.toString());
                BehavioredClassifier _context = transition.containingStateMachine().getContext();
                Class clazz_1 = (Class)_context;
                InstrumentCTF.addDependencies(clazz_1);
                InstrumentCTF.addInstanceName(clazz_1);
            }
            if (event_1 instanceof State) {
                boolean _traceStateAction_1;
                State state = (State)event_1;
                boolean trace = false;
                boolean _traceStateAction = TraceUtils.traceStateAction((State)state, (TraceActions.TAState)TraceActions.TAState.StateEnter);
                if (_traceStateAction) {
                    Behavior entry = state.getEntry();
                    if (entry == null) {
                        entry = state.createEntry(null, UMLPackage.eINSTANCE.getOpaqueBehavior());
                    }
                    StringConcatenation _builder_2 = new StringConcatenation();
                    _builder_2.append(prefix);
                    _builder_2.append("_");
                    CharSequence _enterStateEventName = EventNames.enterStateEventName((State)state);
                    _builder_2.append((Object)_enterStateEventName);
                    _builder_2.append("(BareCTFInit::ctx(), instanceName);");
                    BehaviorUtils.prefixBody((Behavior)entry, (String)_builder_2.toString());
                    trace = true;
                }
                if (_traceStateAction_1 = TraceUtils.traceStateAction((State)state, (TraceActions.TAState)TraceActions.TAState.StateLeave)) {
                    Behavior exit = state.getExit();
                    if (exit == null) {
                        exit = state.createExit(null, UMLPackage.eINSTANCE.getOpaqueBehavior());
                    }
                    StringConcatenation _builder_3 = new StringConcatenation();
                    _builder_3.append(prefix);
                    _builder_3.append("_");
                    CharSequence _exitStateEventName = EventNames.exitStateEventName((State)state);
                    _builder_3.append((Object)_exitStateEventName);
                    _builder_3.append("(BareCTFInit::ctx(), instanceName);");
                    BehaviorUtils.prefixBody((Behavior)exit, (String)_builder_3.toString());
                    trace = true;
                }
                if (trace) {
                    BehavioredClassifier _context_1 = state.containingStateMachine().getContext();
                    Class clazz_2 = (Class)_context_1;
                    InstrumentCTF.addDependencies(clazz_2);
                    InstrumentCTF.addInstanceName(clazz_2);
                }
            }
            if (event_1 instanceof Operation) {
                Operation operation = (Operation)event_1;
                InstrumentCTF.instrumentOperation(operation, null);
            }
            if (event_1 instanceof Class) {
                boolean _isActionActive_1;
                Class clazz_3 = (Class)event_1;
                IMarker marker = TraceUtils.getMarkerForTraceElement((EObject)clazz_3);
                boolean _isActionActive = TraceUtils.isActionActive((IMarker)marker, (TraceActions.TraceFeature)TraceActions.TraceFeature.Class, (int)TraceActions.TAClass.Creation.ordinal());
                if (_isActionActive) {
                    Functions.Function1<Operation, Boolean> _function = new Functions.Function1<Operation, Boolean>(){

                        public Boolean apply(Operation it) {
                            return StereotypeUtil.isApplied((Element)it, Create.class);
                        }
                    };
                    Iterable constructors = IterableExtensions.filter((Iterable)clazz_3.getOwnedOperations(), (Functions.Function1)_function);
                    boolean _isEmpty = IterableExtensions.isEmpty((Iterable)constructors);
                    if (_isEmpty) {
                        Operation ctor = clazz_3.createOwnedOperation(clazz_3.getName(), null, null);
                        StereotypeUtil.apply((Element)ctor, Create.class);
                        BehaviorUtils.createOpaqueBehavior((BehavioredClassifier)clazz_3, (Operation)ctor);
                        InstrumentCTF.instrumentOperation(ctor, null);
                        events.add((Element)ctor);
                    }
                }
                if (_isActionActive_1 = TraceUtils.isActionActive((IMarker)marker, (TraceActions.TraceFeature)TraceActions.TraceFeature.Class, (int)TraceActions.TAClass.Destruction.ordinal())) {
                    Functions.Function1<Operation, Boolean> _function_1 = new Functions.Function1<Operation, Boolean>(){

                        public Boolean apply(Operation it) {
                            return StereotypeUtil.isApplied((Element)it, Destroy.class);
                        }
                    };
                    Iterable destructors = IterableExtensions.filter((Iterable)clazz_3.getOwnedOperations(), (Functions.Function1)_function_1);
                    boolean _isEmpty_1 = IterableExtensions.isEmpty((Iterable)destructors);
                    if (_isEmpty_1) {
                        String _name = clazz_3.getName();
                        String _plus = "~" + _name;
                        Operation dtor = clazz_3.createOwnedOperation(_plus, null, null);
                        StereotypeUtil.apply((Element)dtor, Destroy.class);
                        BehaviorUtils.createOpaqueBehavior((BehavioredClassifier)clazz_3, (Operation)dtor);
                        InstrumentCTF.instrumentOperation(dtor, null);
                        events.add((Element)dtor);
                    }
                }
            }
            ++n;
        }
    }

    public static void instrumentOperation(Operation operation, Port port) {
        boolean _greaterThan;
        int _size = operation.getMethods().size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            boolean _tripleNotEquals;
            Behavior method = (Behavior)operation.getMethods().get(0);
            String prepare = TraceUtils.prepareHint((Element)operation);
            StringConcatenation _builder = new StringConcatenation();
            if (prepare != null) {
                _builder.append(prepare);
            }
            _builder.newLineIfNotEmpty();
            _builder.append(prefix);
            _builder.append("_");
            CharSequence _operationStartsEventName = EventNames.operationStartsEventName((Operation)operation, (Port)port);
            _builder.append((Object)_operationStartsEventName);
            _builder.append("(BareCTFInit::ctx()");
            boolean _needInstanceName = TraceUtils.needInstanceName((Operation)operation);
            if (_needInstanceName) {
                _builder.append(", instanceName");
            }
            _builder.newLineIfNotEmpty();
            String _paramsHint = TraceUtils.paramsHint((Element)operation);
            boolean bl2 = _tripleNotEquals = _paramsHint != null;
            if (_tripleNotEquals) {
                _builder.append("\t");
                _builder.append(", ");
                String _paramsHint_1 = TraceUtils.paramsHint((Element)operation);
                _builder.append(_paramsHint_1, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t\t\t");
            } else {
                boolean _traceOpOrPortAction = TraceUtils.traceOpOrPortAction((Operation)operation, (Port)port, (TraceActions.TAOperation)TraceActions.TAOperation.ParameterValues);
                if (_traceOpOrPortAction) {
                    List<NameType> paramList = Flattener.flattenParams(TraceUtils.getInAndInout((Operation)operation));
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                    _builder.append("\t");
                    for (NameType param : paramList) {
                        _builder.append(", ");
                        String _castAndName = InstrumentCTF.castAndName(param);
                        _builder.append(_castAndName, "\t\t");
                    }
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t");
                }
            }
            _builder.append(");");
            BehaviorUtils.prefixBody((Behavior)method, (String)_builder.toString());
            if (TraceUtils.traceOpOrPortAction((Operation)operation, (Port)port, (TraceActions.TAOperation)TraceActions.TAOperation.MethodEnds) && operation.getType() == null) {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append(prefix);
                _builder_1.append("_");
                CharSequence _operationEndsEventName = EventNames.operationEndsEventName((Operation)operation, (Port)port);
                _builder_1.append((Object)_operationEndsEventName);
                _builder_1.append("(BareCTFInit::ctx()");
                boolean _needInstanceName_1 = TraceUtils.needInstanceName((Operation)operation);
                if (_needInstanceName_1) {
                    _builder_1.append(", instanceName");
                }
                _builder_1.append(");");
                BehaviorUtils.appendBody((Behavior)method, (String)_builder_1.toString());
            }
            Class clazz = operation.getClass_();
            InstrumentCTF.addDependencies(clazz);
            InstrumentCTF.addInstanceName(clazz);
        }
    }

    public static void addDependencies(Class clazz) {
        NamedElement _qualifiedElementFromRS = ElementUtils.getQualifiedElementFromRS((Element)clazz, (String)ModelQNames.BareCTFInit);
        Classifier initCl = (Classifier)_qualifiedElementFromRS;
        InstrumentCTF.addDependency(clazz, initCl);
        NamedElement _qualifiedElementFromRS_1 = ElementUtils.getQualifiedElementFromRS((Element)clazz, (String)ModelQNames.BareCTF);
        Classifier barectf = (Classifier)_qualifiedElementFromRS_1;
        InstrumentCTF.addDependency(clazz, barectf);
    }

    public static void addInstanceName(Class clazz) {
        UseInstanceConfigurator useIConfig;
        Property instAttrib = clazz.getOwnedAttribute("instanceName", null);
        if (instAttrib == null) {
            NamedElement _qualifiedElementFromRS = ElementUtils.getQualifiedElementFromRS((Element)clazz, (String)"PrimitiveTypes::String");
            Classifier string = (Classifier)_qualifiedElementFromRS;
            if (string == null) {
                PackageUtil.loadPackage((URI)StdUriConstants.UML_PRIM_TYPES_URI, (ResourceSet)clazz.eResource().getResourceSet());
                NamedElement _qualifiedElementFromRS_1 = ElementUtils.getQualifiedElementFromRS((Element)clazz, (String)"PrimitiveTypes::String");
                string = (Classifier)_qualifiedElementFromRS_1;
            }
            if (string != null) {
                instAttrib = clazz.createOwnedAttribute("instanceName", (Type)string);
                StereotypeUtil.apply((Element)instAttrib, ConfigurationProperty.class);
                ValueSpecification _createDefaultValue = instAttrib.createDefaultValue(null, null, UMLPackage.eINSTANCE.getLiteralString());
                LiteralString litString = (LiteralString)_createDefaultValue;
                litString.setValue(StringUtils.quote((String)clazz.getName()));
            }
        }
        if ((useIConfig = (UseInstanceConfigurator)StereotypeUtil.applyApp((Element)clazz, UseInstanceConfigurator.class)) == null) {
            Package depProfile = PackageUtil.loadPackage((URI)DepProfileResource.PROFILE_PATH_URI, (ResourceSet)clazz.eResource().getResourceSet());
            if (depProfile instanceof Profile) {
                PackageUtil.getRootPackage((Element)clazz).applyProfile((Profile)depProfile);
                useIConfig = (UseInstanceConfigurator)StereotypeUtil.applyApp((Element)clazz, UseInstanceConfigurator.class);
            } else {
                throw new RuntimeException("Cannot apply deployment profile");
            }
        }
        PackageUtil.loadPackage((URI)TracingUriConstants.TRACING_LIB_URI, (ResourceSet)clazz.eResource().getResourceSet());
        NamedElement _qualifiedElementFromRS_2 = ElementUtils.getQualifiedElementFromRS((Element)clazz, (String)"tracing::iconfigurators::InstanceNameConfigurator");
        Classifier iconfigCl = (Classifier)_qualifiedElementFromRS_2;
        InstanceConfigurator iconfig = (InstanceConfigurator)UMLUtil.getStereotypeApplication((Element)iconfigCl, InstanceConfigurator.class);
        useIConfig.setConfigurator(iconfig);
    }

    public static void addDependency(Class clazz, Classifier target) {
        if (target != null) {
            EList _clientDependencies = clazz.getClientDependencies();
            for (Dependency dependency : _clientDependencies) {
                boolean _contains = dependency.getSuppliers().contains((Object)target);
                if (!_contains) continue;
                return;
            }
            clazz.createDependency((NamedElement)target);
        }
    }

    public static String castAndName(NameType nt) {
        Type type = nt.getType();
        if (type instanceof Enumeration) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("(uint8_t) ");
            String _name = nt.getName();
            _builder.append(_name);
            return _builder.toString();
        }
        return nt.getName();
    }
}

