/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.transformation.ui.handlers;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.papyrus.designer.deployment.tools.DepUtils;
import org.eclipse.papyrus.designer.infra.base.CommandSupport;
import org.eclipse.papyrus.designer.infra.base.RunnableWithResult;
import org.eclipse.papyrus.designer.transformation.ui.Messages;
import org.eclipse.papyrus.designer.transformation.ui.dialogs.AllocationDialog;
import org.eclipse.papyrus.uml.diagram.common.handlers.CmdHandler;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Package;

public class AllocateHandler
extends CmdHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.updateSelectedEObject();
        if (!(this.selectedEObject instanceof Package)) {
            return null;
        }
        final Package cdp = (Package)this.selectedEObject;
        final Shell shell = Display.getCurrent().getActiveShell();
        if (DepUtils.getTopLevelInstances((Package)cdp).isEmpty()) {
            MessageDialog.openInformation((Shell)shell, (String)"Error", (String)Messages.AllocateHandler_NO_INSTANCES);
            return null;
        }
        CommandSupport.exec((EObject)cdp, (String)Messages.AllocateHandler_INSTANCE_ALLOCATION, (RunnableWithResult)new RunnableWithResult(){

            public IStatus run() {
                AllocationDialog allocDialog = new AllocationDialog(shell, cdp);
                allocDialog.setTitle(Messages.AllocateHandler_ALLOCATE_INSTANCES);
                allocDialog.open();
                if (allocDialog.getReturnCode() == 0) {
                    return Status.OK_STATUS;
                }
                return Status.CANCEL_STATUS;
            }
        });
        return null;
    }
}

