/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.transformation.ui.handlers;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.designer.infra.base.CommandSupport;
import org.eclipse.papyrus.designer.infra.base.RunnableWithResult;
import org.eclipse.papyrus.designer.transformation.ui.dialogs.ConfigureInstanceDialog;
import org.eclipse.papyrus.uml.diagram.common.handlers.CmdHandler;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Feature;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.NamedElement;

public class ConfigureInstanceHandler
extends CmdHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.updateSelectedEObject();
        if (!(this.selectedEObject instanceof NamedElement)) {
            return null;
        }
        final NamedElement element = (NamedElement)this.selectedEObject;
        final Shell shell = Display.getCurrent().getActiveShell();
        final ExecutionEvent from = event;
        if (element instanceof Class) {
            CommandSupport.exec((EObject)element, (String)"Configure associated component instance", (RunnableWithResult)new RunnableWithResult(){

                public IStatus run() {
                    ConfigureInstanceDialog configureInstanceDialog = new ConfigureInstanceDialog(shell);
                    if (configureInstanceDialog.init((Class)element, from)) {
                        configureInstanceDialog.setTitle("Configure instance");
                        configureInstanceDialog.setMessage("Configure instance for component " + element.getName());
                        configureInstanceDialog.open();
                        if (configureInstanceDialog.getReturnCode() == 0) {
                            return Status.OK_STATUS;
                        }
                    }
                    return Status.CANCEL_STATUS;
                }
            });
        } else if (element instanceof Feature) {
            CommandSupport.exec((EObject)element, (String)"Configure associated instance", (RunnableWithResult)new RunnableWithResult(){

                public IStatus run() {
                    ConfigureInstanceDialog configureInstanceDialog = new ConfigureInstanceDialog(shell);
                    if (configureInstanceDialog.init((Feature)element, from)) {
                        configureInstanceDialog.setTitle("Configure instance");
                        configureInstanceDialog.setMessage("Configure instance for property/connector " + element.getName());
                        configureInstanceDialog.open();
                        if (configureInstanceDialog.getReturnCode() == 0) {
                            return Status.OK_STATUS;
                        }
                    }
                    return Status.CANCEL_STATUS;
                }
            });
        } else if (element instanceof InstanceSpecification) {
            CommandSupport.exec((EObject)element, (String)"Configure instance", (RunnableWithResult)new RunnableWithResult(){

                public IStatus run() {
                    ConfigureInstanceDialog configureInstanceDialog = new ConfigureInstanceDialog(shell);
                    if (configureInstanceDialog.init((InstanceSpecification)element, from)) {
                        configureInstanceDialog.setMessage("Configure instance " + element.getName());
                        configureInstanceDialog.open();
                        if (configureInstanceDialog.getReturnCode() == 0) {
                            return Status.OK_STATUS;
                        }
                    }
                    return Status.CANCEL_STATUS;
                }
            });
        }
        return null;
    }
}

