/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.deployment.validation.constraints;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.papyrus.designer.transformation.profile.Transformation.DerivedElement;
import org.eclipse.papyrus.designer.uml.tools.utils.StereotypeUtil;
import org.eclipse.papyrus.designer.uml.tools.utils.TemplateUtils;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.TemplateableElement;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.TypedElement;

public class TemplateRefWithoutBinding
extends AbstractModelConstraint {
    public IStatus validate(IValidationContext ctx) {
        TypedElement te = (TypedElement)ctx.getTarget();
        Type type = te.getType();
        if (type != null) {
            Package owner = type.getNearestPackage();
            while (owner != null) {
                Package pkg;
                if (owner instanceof Package && TemplateUtils.getSignatureDirect((TemplateableElement)(pkg = owner)) != null && StereotypeUtil.isApplicable((Element)pkg, DerivedElement.class) && !this.isWithin(pkg, (Element)te)) {
                    return ctx.createFailureStatus(new Object[]{"This element is typed with '" + type.getQualifiedName() + "', but defined outside the package template '" + pkg.getQualifiedName() + "'"});
                }
                owner = owner.getOwner();
            }
        }
        return ctx.createSuccessStatus();
    }

    public boolean isWithin(Package pkg, Element e) {
        Element owner = e;
        while (owner != null) {
            if ((owner = owner.getOwner()) != pkg) continue;
            return true;
        }
        return false;
    }
}

