/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.c.codegen.transformation;

import java.util.HashMap;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ToolFactory;
import org.eclipse.cdt.core.formatter.CodeFormatter;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.papyrus.designer.languages.c.codegen.Activator;
import org.eclipse.papyrus.designer.languages.c.codegen.header.ClassHeaderScript;
import org.eclipse.papyrus.designer.languages.c.codegen.header.DataTypeHeaderScript;
import org.eclipse.papyrus.designer.languages.c.codegen.lib.DataTypeScript;
import org.eclipse.papyrus.designer.languages.c.codegen.module.ClassModuleScript;
import org.eclipse.papyrus.designer.languages.c.codegen.preferences.CCodeGenUtils;
import org.eclipse.papyrus.designer.languages.c.codegen.transformation.CLocationStrategy;
import org.eclipse.papyrus.designer.languages.c.codegen.transformation.Messages;
import org.eclipse.papyrus.designer.languages.common.base.GenUtils;
import org.eclipse.papyrus.designer.languages.common.base.ILocationStrategy;
import org.eclipse.papyrus.designer.languages.common.base.ModelElementsCreator;
import org.eclipse.papyrus.designer.languages.common.base.file.FileSystemAccessFactory;
import org.eclipse.papyrus.designer.languages.common.base.file.IFileExists;
import org.eclipse.papyrus.designer.languages.common.base.file.IPFileSystemAccess;
import org.eclipse.papyrus.designer.languages.common.profile.Codegen.External;
import org.eclipse.papyrus.designer.languages.common.profile.Codegen.NoCodeGen;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.CppRoot;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Include;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.ManualGeneration;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Template;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Relationship;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.SignalEvent;
import org.eclipse.uml2.uml.Usage;
import org.eclipse.uml2.uml.util.UMLUtil;

public class CModelElementsCreator
extends ModelElementsCreator {
    private static final String C_LANG = "C";
    protected String sourceFolder;
    protected boolean formatCode;
    protected String hExt;
    protected String cExt;
    protected String commentHeader;

    public CModelElementsCreator(IProject project) {
        this(project, FileSystemAccessFactory.create((IProject)project), null);
    }

    public CModelElementsCreator(IProject project, String commentHeader) {
        this(project, FileSystemAccessFactory.create((IProject)project), commentHeader);
    }

    public CModelElementsCreator(IPFileSystemAccess fileSystemAccess, String commentHeader) {
        this(null, fileSystemAccess, commentHeader);
    }

    public CModelElementsCreator(IProject project, IPFileSystemAccess fileSystemAccess, String commentHeader) {
        super(fileSystemAccess, (ILocationStrategy)new CLocationStrategy(), C_LANG);
        this.project = project;
        this.commentHeader = commentHeader != null ? commentHeader : CCodeGenUtils.getCommentHeader();
        this.hExt = CCodeGenUtils.getHeaderSuffix();
        this.cExt = CCodeGenUtils.getBodySuffix();
        this.formatCode = CCodeGenUtils.getFormatCode();
        this.sourceFolder = null;
    }

    protected void createPackageableElementFile(PackageableElement element, IProgressMonitor monitor) {
        if (this.sourceFolder == null) {
            this.sourceFolder = GenUtils.getSourceFolder((Element)element);
        }
        if (!(element instanceof Package) && !(element instanceof Usage)) {
            if (element instanceof Classifier) {
                this.generateClassifier((Classifier)element);
            } else if (!(element instanceof Relationship || element instanceof Signal || element instanceof SignalEvent)) {
                Activator.log.debug("C_LANG code generator: unsupported model element " + String.valueOf(element));
            }
        }
    }

    protected void generateClassifier(Classifier classifier) {
        String dot = ".";
        String LF = "\n";
        String classHeaderFileName = this.getFileName((NamedElement)classifier) + dot + this.hExt;
        String classBodyFileName = this.getFileName((NamedElement)classifier) + dot + this.cExt;
        if (GenUtils.hasStereotype((Element)classifier, ManualGeneration.class)) {
            ManualGeneration mg = (ManualGeneration)UMLUtil.getStereotypeApplication((Element)classifier, ManualGeneration.class);
            Include cppInclude = (Include)UMLUtil.getStereotypeApplication((Element)classifier, Include.class);
            String fileContent = this.commentHeader + cppInclude.getHeader();
            this.generateFile(classHeaderFileName, fileContent);
            fileContent = this.commentHeader + cppInclude.getPreBody() + LF + cppInclude.getBody();
            String ext = GenUtils.maskNull((String)mg.getExtensionBody());
            if (ext.length() == 0) {
                ext = this.cExt;
            }
            this.generateFile(classBodyFileName, fileContent);
        } else if (!(GenUtils.hasStereotype((Element)classifier, NoCodeGen.class) || GenUtils.hasStereotype((Element)classifier, External.class) || GenUtils.hasStereotype((Element)classifier, Template.class))) {
            if (classifier instanceof Class) {
                String fileContent = this.commentHeader + String.valueOf(ClassHeaderScript.classHeaderScript((Class)classifier));
                this.generateFile(classHeaderFileName, fileContent);
                fileContent = this.commentHeader + String.valueOf(ClassModuleScript.classModuleScript((Class)classifier));
                this.generateFile(classBodyFileName, fileContent);
            } else if (classifier instanceof Enumeration) {
                String fileContent = this.commentHeader + String.valueOf(DataTypeScript.genDataTypeStructDeclarations((Enumeration)classifier));
                this.generateFile(classHeaderFileName, fileContent);
            } else if (classifier instanceof DataType) {
                String fileContent = this.commentHeader + String.valueOf(DataTypeHeaderScript.dataTypeHeaderScript((DataType)classifier));
                this.generateFile(classHeaderFileName, fileContent);
                fileContent = this.commentHeader + String.valueOf(DataTypeScript.genDefaultIntialisationOperation((DataType)classifier));
                this.generateFile(classBodyFileName, fileContent);
            }
        }
    }

    public String getFileName(NamedElement element) {
        if (this.sourceFolder == null) {
            this.sourceFolder = GenUtils.getSourceFolder((Element)element);
        }
        return this.sourceFolder + this.locStrategy.getFileName(element);
    }

    protected void generateFile(String fileName, String content) {
        if (this.formatCode) {
            if (this.fileSystemAccess instanceof IFileExists) {
                if (!((IFileExists)this.fileSystemAccess).existsFile(fileName)) {
                    this.fileSystemAccess.generateFile(fileName, "");
                }
            } else {
                this.fileSystemAccess.generateFile(fileName, "");
            }
            this.fileSystemAccess.generateFile(fileName, this.format(fileName, content));
        } else {
            this.fileSystemAccess.generateFile(fileName, content);
        }
    }

    protected String format(String fileName, String content) {
        Document doc;
        CodeFormatter codeFormatter;
        TextEdit edit;
        if (Platform.getBundle((String)"org.eclipse.cdt.core") == null) {
            return content;
        }
        HashMap<String, String> options = new HashMap<String, String>();
        options.putAll(CCorePlugin.getOptions());
        if (this.project != null) {
            ProjectScope scope = new ProjectScope(this.project);
            IEclipsePreferences ref = scope.getNode("org.eclipse.cdt.core");
            for (String key : options.keySet()) {
                String value;
                if (!key.startsWith("org.eclipse.cdt.core.formatter") || (value = ref.get(key, "")) == null || value.length() <= 0) continue;
                options.put(key, value);
            }
        }
        if ((edit = (codeFormatter = ToolFactory.createCodeFormatter(options)).format(8, (doc = new Document(content)).get(), 0, doc.get().length(), 0, null)) == null) {
            Activator.log.debug("Cannot format content");
            return content;
        }
        try {
            edit.apply((IDocument)doc);
            return doc.get();
        }
        catch (MalformedTreeException e) {
            Activator.log.error((Throwable)e);
        }
        catch (BadLocationException e) {
            Activator.log.error((Throwable)e);
        }
        return content;
    }

    protected String format(String content) {
        Document doc;
        if (Platform.getBundle((String)"org.eclipse.cdt.core") == null) {
            return content;
        }
        CodeFormatter codeFormatter = ToolFactory.createCodeFormatter(null);
        TextEdit edit = codeFormatter.format(8, (doc = new Document(content)).get(), 0, doc.get().length(), 0, null);
        if (edit == null) {
            Activator.log.debug(Messages.CModelElementsCreator_CanNotFormatContent);
            return content;
        }
        try {
            edit.apply((IDocument)doc);
            return doc.get();
        }
        catch (MalformedTreeException e) {
            Activator.log.error((Throwable)e);
        }
        catch (BadLocationException e) {
            Activator.log.error((Throwable)e);
        }
        return content;
    }

    protected void createPackageFiles(IContainer packageContainer, IProgressMonitor monitor, Package pkg) throws CoreException {
    }

    protected boolean isRoot(Namespace ns) {
        return GenUtils.hasStereotype((Element)ns, CppRoot.class);
    }

    protected boolean noCodeGen(Element element) {
        return GenUtils.hasStereotype((Element)element, NoCodeGen.class);
    }
}

