/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.cpp.view.panels;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.papyrus.designer.infra.base.CommandSupport;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Array;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Const;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Ptr;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Ref;
import org.eclipse.papyrus.designer.languages.cpp.view.panels.CppAbstractPanel;
import org.eclipse.papyrus.designer.uml.tools.utils.StereotypeUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;

@Deprecated
public class CppPropertyPanel
extends CppAbstractPanel {
    private Button isStatic;
    private Button isConst;
    private Property selectedProperty;
    private IDocument docPtr;
    private IDocument docRef;
    private IDocument docArray;
    private IDocument docDefault;
    private SourceViewer viewerPtr;
    private SourceViewer viewerRef;
    private SourceViewer viewerArray;
    private SourceViewer viewerDefault;
    private Group groupPtr;
    private Group groupRef;
    private Group groupArray;
    private Group groupDefault;

    public CppPropertyPanel(Composite parent, int style) {
        super(parent, style);
    }

    public Property getSelectedElement() {
        return this.selectedProperty;
    }

    @Override
    public void setSelectedElement(Element newElement) {
        super.setSelectedElement(newElement);
        if (!(newElement instanceof Property)) {
            throw new RuntimeException("bad selection: " + String.valueOf(newElement) + " should be an uml2 Property");
        }
        this.selectedProperty = (Property)newElement;
    }

    @Override
    public Control createContent() {
        this.createSaveResetButtons();
        this.isStatic = this.createButton("isStatic", this, null);
        this.isConst = this.createButton("isConst", this, this.isStatic);
        this.isStatic.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CppPropertyPanel.this.updateModel();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.addStereotypeSelectionListener(this.isConst, "Const");
        this.docPtr = this.createDocument();
        this.groupPtr = this.createGroup(this, "Pointer declaration", (Control)this.buttonSave, null, false, 0, 25, false);
        this.viewerPtr = this.createViewer(this.docPtr, this.groupPtr);
        this.docRef = this.createDocument();
        this.groupRef = this.createGroup(this, "Reference declaration", (Control)this.buttonSave, (Control)this.groupPtr, false, 0, 50, false);
        this.viewerRef = this.createViewer(this.docRef, this.groupRef);
        this.docDefault = this.createDocument();
        this.groupDefault = this.createGroup(this, "Default value", (Control)this.buttonSave, (Control)this.groupRef, false, 0, 75, false);
        this.viewerDefault = this.createViewer(this.docDefault, this.groupDefault);
        this.docArray = this.createDocument();
        this.groupArray = this.createGroup(this, "Array value ([...])", (Control)this.buttonSave, (Control)this.groupDefault, true, 0, 0, false);
        this.viewerArray = this.createViewer(this.docArray, this.groupArray);
        return this;
    }

    @Override
    public void save() {
        if (this.selectedProperty != null) {
            CommandSupport.exec((EObject)this.selectedProperty, (String)"C++ package save", (Runnable)new Runnable(){

                @Override
                public void run() {
                    String newPtr = CppPropertyPanel.this.docPtr.get();
                    if (newPtr.equals("")) {
                        StereotypeUtil.unapply((Element)CppPropertyPanel.this.selectedProperty, Ptr.class);
                    } else {
                        StereotypeUtil.apply((Element)CppPropertyPanel.this.selectedProperty, Ptr.class);
                    }
                    String newRef = CppPropertyPanel.this.docRef.get();
                    if (newRef.equals("")) {
                        StereotypeUtil.unapply((Element)CppPropertyPanel.this.selectedProperty, Ref.class);
                    } else {
                        StereotypeUtil.apply((Element)CppPropertyPanel.this.selectedProperty, Ref.class);
                    }
                    String newArray = CppPropertyPanel.this.docArray.get();
                    if (newArray.equals("")) {
                        StereotypeUtil.unapply((Element)CppPropertyPanel.this.selectedProperty, Array.class);
                    } else {
                        StereotypeUtil.apply((Element)CppPropertyPanel.this.selectedProperty, Array.class);
                    }
                }
            });
        }
    }

    @Override
    protected void refreshPanel() {
        if (this.selectedProperty != null) {
            this.isStatic.setSelection(this.selectedProperty.isStatic());
            this.isConst.setSelection(StereotypeUtil.isApplied((Element)this.selectedProperty, Const.class));
            this.docPtr.set(StereotypeUtil.isApplied((Element)this.selectedProperty, Ptr.class) ? "*" : "");
            this.docRef.set(StereotypeUtil.isApplied((Element)this.selectedProperty, Ref.class) ? "&" : "");
            this.docDefault.set(this.selectedProperty.getDefault());
            this.docArray.set(StereotypeUtil.isApplied((Element)this.selectedProperty, Array.class) ? "[]" : "");
        }
    }

    protected void checkStatic() {
        boolean boxState = this.isStatic.getSelection();
        this.selectedProperty.setIsStatic(boxState);
    }

    protected void checkConst() {
        boolean boxState = this.isConst.getSelection();
        if (StereotypeUtil.isApplied((Element)this.selectedProperty, Const.class) != boxState) {
            if (boxState) {
                StereotypeUtil.apply((Element)this.selectedProperty, Const.class);
            } else {
                StereotypeUtil.unapply((Element)this.selectedProperty, Const.class);
            }
        }
    }

    @Override
    public void entryAction() {
        super.entryAction();
        this.reset();
    }

    @Override
    public void exitAction() {
        super.exitAction();
    }

    @Override
    public boolean checkModifications() {
        String arrayValue;
        String refValue;
        String ptrValue;
        String string = ptrValue = StereotypeUtil.isApplied((Element)this.selectedProperty, Ptr.class) ? "*" : "";
        if (!this.docPtr.get().equals(ptrValue)) {
            return true;
        }
        String string2 = refValue = StereotypeUtil.isApplied((Element)this.selectedProperty, Ref.class) ? "&" : "";
        if (!this.docRef.get().equals(refValue)) {
            return true;
        }
        String defaultValue = this.selectedProperty.getDefault();
        if (defaultValue == null ? !this.docDefault.get().equals("") : !this.docDefault.get().equals(defaultValue)) {
            return true;
        }
        String string3 = arrayValue = StereotypeUtil.isApplied((Element)this.selectedProperty, Array.class) ? "[]" : "";
        return !this.docArray.get().equals(arrayValue);
    }

    @Override
    protected void updateModel() {
        CommandSupport.exec((EObject)this.selectedProperty, (String)"C++ property save", (Runnable)new Runnable(){

            @Override
            public void run() {
                CppPropertyPanel.this.checkStatic();
                CppPropertyPanel.this.checkConst();
            }
        });
    }
}

