/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.java.codegen.xtend;

import java.util.Collection;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.designer.languages.common.base.GenUtils;
import org.eclipse.papyrus.designer.languages.common.profile.Codegen.AOverride;
import org.eclipse.papyrus.designer.languages.java.codegen.Constants;
import org.eclipse.papyrus.designer.languages.java.codegen.utils.Modifier;
import org.eclipse.papyrus.designer.languages.java.codegen.xtend.JavaDocumentation;
import org.eclipse.papyrus.designer.languages.java.codegen.xtend.JavaParameter;
import org.eclipse.papyrus.designer.languages.java.codegen.xtend.JavaTypedElement;
import org.eclipse.papyrus.designer.languages.java.profile.PapyrusJava.Default;
import org.eclipse.papyrus.designer.languages.java.profile.PapyrusJava.Native;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.TypedElement;
import org.eclipse.uml2.uml.profile.standard.Create;
import org.eclipse.uml2.uml.util.UMLUtil;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class JavaOperations {
    public static CharSequence javaOperationImplementation(Operation operation) {
        StringConcatenation _builder = new StringConcatenation();
        String _body = GenUtils.getBody((Operation)operation, (Pattern)Constants.supportedLanguages);
        _builder.append(_body);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public static String javaReturnSpec(Operation operation) {
        Object _xifexpression = null;
        if (operation.getType() == null || JavaOperations.isConstructor(operation)) {
            _xifexpression = JavaOperations.constructorOrVoid(operation);
        } else {
            String _javaTypeOrVoid = JavaOperations.javaTypeOrVoid((Parameter)IterableExtensions.head((Iterable)operation.returnResult()));
            _xifexpression = _javaTypeOrVoid + " ";
        }
        return _xifexpression;
    }

    public static String javaTypeOrVoid(Parameter parameter) {
        if (parameter != null) {
            return JavaTypedElement.javaType((TypedElement)parameter);
        }
        return "void";
    }

    public static CharSequence throwss(Operation operation) {
        boolean _greaterThan;
        StringConcatenation _builder = new StringConcatenation();
        int _length = ((Object[])Conversions.unwrapArray((Object)operation.getRaisedExceptions(), Object.class)).length;
        boolean bl = _greaterThan = _length > 0;
        if (_greaterThan) {
            _builder.append("throws ");
            EList _raisedExceptions = operation.getRaisedExceptions();
            boolean _hasElements = false;
            for (Type re : _raisedExceptions) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)",", "");
                }
                String _name = re.getName();
                _builder.append(_name);
            }
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public static String constructorOrVoid(Operation operation) {
        String _xifexpression = null;
        boolean _isConstructor = JavaOperations.isConstructor(operation);
        _xifexpression = _isConstructor ? "" : "void ";
        return _xifexpression;
    }

    public static boolean isConstructor(Operation operation) {
        return GenUtils.hasStereotype((Element)operation, Create.class);
    }

    public static Collection<Operation> getOwnedOperations(Classifier cl) {
        EList<Operation> _xblockexpression = null;
        EList<Operation> operations = JavaOperations.getOwnedOperationsWNull(cl);
        EList<Operation> _xifexpression = null;
        _xifexpression = operations == null ? CollectionLiterals.emptySet() : operations;
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public static EList<Operation> getOwnedOperationsWNull(Classifier cl) {
        EList _xifexpression = null;
        if (cl instanceof Class) {
            _xifexpression = ((Class)cl).getOwnedOperations();
        } else {
            EList _xifexpression_1 = null;
            if (cl instanceof DataType) {
                _xifexpression_1 = ((DataType)cl).getOwnedOperations();
            } else {
                EList _xifexpression_2 = null;
                _xifexpression_2 = cl instanceof Interface ? ((Interface)cl).getOwnedOperations() : null;
                _xifexpression_1 = _xifexpression_2;
            }
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    public static CharSequence javaOperationDeclaration(Operation operation) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _javaOperationDoc = JavaDocumentation.javaOperationDoc(operation);
        _builder.append((Object)_javaOperationDoc);
        _builder.newLineIfNotEmpty();
        boolean _hasStereotype = GenUtils.hasStereotype((Element)operation, AOverride.class);
        if (_hasStereotype) {
            _builder.append("@Override");
            _builder.newLine();
        }
        String _methodModifiers = Modifier.methodModifiers(operation);
        _builder.append(_methodModifiers);
        String _javaReturnSpec = JavaOperations.javaReturnSpec(operation);
        _builder.append(_javaReturnSpec);
        String _name = operation.getName();
        _builder.append(_name);
        _builder.append("(");
        CharSequence _javaOperationParameters = JavaParameter.javaOperationParameters(operation);
        _builder.append((Object)_javaOperationParameters);
        _builder.append(") ");
        CharSequence _throwss = JavaOperations.throwss(operation);
        _builder.append((Object)_throwss);
        boolean _mustGenerateBody = JavaOperations.mustGenerateBody(operation);
        if (_mustGenerateBody) {
            _builder.append("{");
        } else {
            _builder.append(";");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        boolean _mustGenerateBody_1 = JavaOperations.mustGenerateBody(operation);
        if (_mustGenerateBody_1) {
            CharSequence _javaOperationImplementation = JavaOperations.javaOperationImplementation(operation);
            _builder.append((Object)_javaOperationImplementation, "\t");
        }
        _builder.newLineIfNotEmpty();
        boolean _mustGenerateBody_2 = JavaOperations.mustGenerateBody(operation);
        if (_mustGenerateBody_2) {
            _builder.append("}");
        }
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public static boolean isAbstract(Operation operation) {
        return operation.isAbstract() && operation.getOwner() instanceof Classifier && (((Classifier)operation.getOwner()).isAbstract() || operation.getOwner() instanceof Enumeration) || operation.getInterface() != null;
    }

    public static boolean isDefault(Operation operation) {
        return operation.getInterface() != null && UMLUtil.getStereotypeApplication((Element)operation, Default.class) != null;
    }

    public static boolean mustGenerateBody(Operation operation) {
        boolean _tripleNotEquals;
        boolean _tripleEquals;
        boolean _not;
        boolean _isAbstract = JavaOperations.isAbstract(operation);
        boolean bl = _not = !_isAbstract;
        if (_not) {
            Native _stereotypeApplication = (Native)UMLUtil.getStereotypeApplication((Element)operation, Native.class);
            return _stereotypeApplication == null;
        }
        Interface _interface = operation.getInterface();
        boolean bl2 = _tripleEquals = _interface == null;
        if (_tripleEquals) {
            boolean _isStatic = operation.isStatic();
            if (_isStatic) {
                Native _stereotypeApplication_1 = (Native)UMLUtil.getStereotypeApplication((Element)operation, Native.class);
                return _stereotypeApplication_1 == null;
            }
            return false;
        }
        Interface _interface_1 = operation.getInterface();
        boolean bl3 = _tripleNotEquals = _interface_1 != null;
        if (_tripleNotEquals) {
            return operation.isStatic() || UMLUtil.getStereotypeApplication((Element)operation, Default.class) != null;
        }
        return true;
    }
}

