/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.transformation.library.xtend;

import java.util.List;
import java.util.Objects;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Typedef;
import org.eclipse.papyrus.designer.transformation.extensions.ITextTemplate;
import org.eclipse.papyrus.designer.uml.tools.utils.ElementUtils;
import org.eclipse.papyrus.designer.uml.tools.utils.OperationUtils;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.util.UMLUtil;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class CppUtils
implements ITextTemplate {
    public static CharSequence cppSignature(Operation operation) {
        StringConcatenation _builder = new StringConcatenation();
        String _name = operation.getName();
        _builder.append(_name);
        _builder.append("(");
        EList _ownedParameters = operation.getOwnedParameters();
        boolean _hasElements = false;
        for (Parameter parameter : _ownedParameters) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            _builder.newLineIfNotEmpty();
            CharSequence _cppParameter = CppUtils.cppParameter(parameter);
            _builder.append((Object)_cppParameter);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public static CharSequence cppCall(Operation operation) {
        StringConcatenation _builder = new StringConcatenation();
        String _name = operation.getName();
        _builder.append(_name);
        _builder.append("(");
        EList _parametersNonRet = OperationUtils.parametersNonRet((Operation)operation);
        boolean _hasElements = false;
        for (Parameter parameter : _parametersNonRet) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            _builder.newLineIfNotEmpty();
            String _name_1 = parameter.getName();
            _builder.append(_name_1);
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
        }
        _builder.append(")");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public static String dereferenceTypedef(Type type) {
        Typedef cppType;
        if (type instanceof PrimitiveType && (cppType = (Typedef)UMLUtil.getStereotypeApplication((Element)type, Typedef.class)) != null) {
            cppType.getDefinition();
        }
        return type.getQualifiedName();
    }

    public static CharSequence returnCppCall(Operation operation) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        Type _type = operation.getType();
        boolean bl = _tripleNotEquals = _type != null;
        if (_tripleNotEquals) {
            _builder.append("return ");
        }
        CharSequence _cppCall = CppUtils.cppCall(operation);
        _builder.append((Object)_cppCall);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public static CharSequence cppParameter(Parameter parameter) {
        StringConcatenation _builder = new StringConcatenation();
        Type _type = parameter.getType();
        _builder.append((Object)_type);
        ParameterDirectionKind _direction = parameter.getDirection();
        boolean _equals = Objects.equals(_direction, 2);
        if (_equals) {
            _builder.append("_out");
        }
        _builder.append(" ");
        String _name = parameter.getName();
        _builder.append(_name);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public static CharSequence cppType(Type type) {
        StringConcatenation _builder = new StringConcatenation();
        String _qualifiedName = type.getQualifiedName();
        boolean _equals = Objects.equals(_qualifiedName, "UMLPrimitiveTypes::Boolean");
        if (_equals) {
            _builder.append("bool");
            _builder.newLine();
        } else {
            String _qualifiedName_1 = type.getQualifiedName();
            boolean _equals_1 = Objects.equals(_qualifiedName_1, "UMLPrimitiveTypes::Integer");
            if (_equals_1) {
                _builder.append("int");
                _builder.newLine();
            } else {
                String _dereferenceTypedef = CppUtils.dereferenceTypedef(type);
                _builder.append(_dereferenceTypedef);
                _builder.newLineIfNotEmpty();
            }
        }
        return _builder;
    }

    public static CharSequence cppRetType(Operation operation) {
        boolean _tripleEquals;
        StringConcatenation _builder = new StringConcatenation();
        Type _type = operation.getType();
        boolean bl = _tripleEquals = _type == null;
        if (_tripleEquals) {
            _builder.append("void");
            _builder.newLine();
        } else {
            CharSequence _cppType = CppUtils.cppType(operation.getType());
            _builder.append((Object)_cppType);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public static CharSequence openNamespace(NamedElement namedElement) {
        StringConcatenation _builder = new StringConcatenation();
        List _reverse = ListExtensions.reverse((List)ElementUtils.usedNamespaces((NamedElement)namedElement));
        for (Namespace ns : _reverse) {
            _builder.append("namespace ");
            String _name = ns.getName();
            _builder.append(_name);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public static CharSequence closeNamespace(NamedElement namedElement) {
        StringConcatenation _builder = new StringConcatenation();
        EList _usedNamespaces = ElementUtils.usedNamespaces((NamedElement)namedElement);
        for (Namespace ns : _usedNamespaces) {
            _builder.append("}; // of namespace [ns.name/]");
            _builder.newLine();
        }
        return _builder;
    }
}

