/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.transformation.tracing.library.utils;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.papyrus.designer.languages.common.profile.Codegen.TraceHint;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Typedef;
import org.eclipse.papyrus.designer.transformation.core.transformations.TransformationContext;
import org.eclipse.papyrus.designer.transformation.tracing.library.utils.ImplicitTrace;
import org.eclipse.papyrus.designer.uml.tools.utils.StereotypeUtil;
import org.eclipse.papyrus.moka.tracepoint.service.MarkerUtils;
import org.eclipse.papyrus.moka.tracepoint.service.TraceActions;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.profile.standard.Create;
import org.eclipse.uml2.uml.util.UMLUtil;

public class TraceUtils {
    public static IMarker[] getMarkersForEObject(EObject eObject, String markerType) {
        Resource resource = eObject.eResource();
        IFile file = WorkspaceSynchronizer.getFile((Resource)resource);
        if (file != null) {
            try {
                return file.findMarkers(markerType, true, 2);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return new IMarker[0];
    }

    public static boolean hasTrace(EObject eObject) {
        if (TraceUtils.getMarkerForTraceElement(eObject) != null) {
            return true;
        }
        if (eObject instanceof Operation) {
            return ImplicitTrace.traceOperation((Operation)eObject);
        }
        if (eObject instanceof Port) {
            return ImplicitTrace.tracePort((Port)eObject);
        }
        if (eObject instanceof State) {
            return ImplicitTrace.traceState((State)eObject);
        }
        if (eObject instanceof Transition) {
            return ImplicitTrace.traceTransition((Transition)eObject);
        }
        return false;
    }

    public static boolean traceOpOrPortAction(Operation operation, Port port, TraceActions.TAOperation opAction) {
        IMarker marker;
        IMarker iMarker = marker = port != null ? TraceUtils.getMarkerForTraceElement((EObject)port) : null;
        if (marker == null) {
            marker = TraceUtils.getMarkerForTraceElement((EObject)operation);
        }
        if (marker == null && operation.getClass_() != null) {
            marker = TraceUtils.getMarkerForTraceElement((EObject)operation.getClass_());
        }
        return marker != null && TraceUtils.isActionActive(marker, TraceActions.TraceFeature.Operation, opAction.ordinal());
    }

    public static boolean traceStateAction(State state, TraceActions.TAState stateAction) {
        IMarker marker = TraceUtils.getMarkerForTraceElement((EObject)state);
        if (marker == null) {
            marker = TraceUtils.getMarkerForTraceElement((EObject)state.containingStateMachine().getContext());
        }
        return marker != null && TraceUtils.isActionActive(marker, TraceActions.TraceFeature.State, stateAction.ordinal());
    }

    public static boolean traceTransitionAction(Transition transition, TraceActions.TATransition transitionAction) {
        IMarker marker = TraceUtils.getMarkerForTraceElement((EObject)transition);
        if (marker == null) {
            marker = TraceUtils.getMarkerForTraceElement((EObject)transition.containingStateMachine().getContext());
        }
        return marker != null && TraceUtils.isActionActive(marker, TraceActions.TraceFeature.Transition, transitionAction.ordinal());
    }

    public static boolean isActionActive(IMarker marker, TraceActions.TraceFeature feature, int ordinal) {
        if (marker != null) {
            String traceAction = marker.getAttribute("traceAction", "");
            int binaryEncoding = 0;
            if (!traceAction.equals("")) {
                String option = TraceActions.getOptions((String)traceAction, (TraceActions.TraceFeature)feature);
                if (option == null) {
                    option = traceAction;
                }
                try {
                    binaryEncoding = Integer.parseInt(option);
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                binaryEncoding = marker.getAttribute("traceAction", 0);
            }
            return (binaryEncoding & 1 << ordinal) != 0;
        }
        return false;
    }

    public static EObject getSourceElement(EObject eObject) {
        String fragment;
        Resource currentRes = eObject.eResource();
        Resource sourceRes = TransformationContext.initialSourceRoot.eResource();
        EObject sourceEObj = sourceRes.getEObject(fragment = currentRes.getURIFragment(eObject));
        if (sourceEObj != null) {
            return sourceEObj;
        }
        return eObject;
    }

    public static IMarker getMarkerForTraceElement(EObject eObject) {
        IMarker[] markers;
        IMarker[] iMarkerArray = markers = TraceUtils.getMarkersForEObject((EObject)TransformationContext.initialSourceRoot, "org.eclipse.papyrus.tracepointmarker");
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            if (MarkerUtils.isActive((IMarker)marker)) {
                EObject eObjOfMarker = MarkerUtils.getEObjectOfMarker((ResourceSet)TransformationContext.initialSourceRoot.eResource().getResourceSet(), (IMarker)marker);
                if (eObjOfMarker == eObject) {
                    return marker;
                }
                EObject eObjCopy = eObjOfMarker;
                for (TransformationContext tc : TransformationContext.chainContexts()) {
                    if ((eObjCopy = (EObject)tc.copier.get((Object)eObjCopy)) != eObject) continue;
                    return marker;
                }
            }
            ++n2;
        }
        return null;
    }

    public static List<Element> getElementsToTrace(Package root) {
        ArrayList<Element> list = new ArrayList<Element>();
        TreeIterator iter = root.eAllContents();
        while (iter.hasNext()) {
            EObject eObj = (EObject)iter.next();
            if (!TraceUtils.hasTrace(eObj) || list.contains(eObj)) continue;
            if (eObj instanceof Port) {
                Port port = (Port)eObj;
                if (port.getProvideds().size() <= 0) continue;
                list.add((Element)port);
                continue;
            }
            if (!(eObj instanceof Operation) && !(eObj instanceof State) && !(eObj instanceof Transition) && !(eObj instanceof Class)) continue;
            list.add((Element)eObj);
        }
        return list;
    }

    public static boolean isSTLstring(Type type) {
        String def;
        Typedef typedef = (Typedef)UMLUtil.getStereotypeApplication((Element)type, Typedef.class);
        return typedef != null && (def = typedef.getDefinition()).equals("std::string");
    }

    public static boolean hasHint(Element element) {
        return StereotypeUtil.isApplied((Element)element, TraceHint.class);
    }

    public static String declarationHint(Element element) {
        TraceHint hint = (TraceHint)UMLUtil.getStereotypeApplication((Element)element, TraceHint.class);
        if (hint != null) {
            return hint.getDeclaration();
        }
        return null;
    }

    public static String paramsHint(Element element) {
        String params;
        TraceHint hint = (TraceHint)UMLUtil.getStereotypeApplication((Element)element, TraceHint.class);
        if (hint != null && (params = hint.getParams()) != null && params.length() > 0) {
            return params;
        }
        return null;
    }

    public static String prepareHint(Element element) {
        String prepare;
        TraceHint hint = (TraceHint)UMLUtil.getStereotypeApplication((Element)element, TraceHint.class);
        if (hint != null && (prepare = hint.getPrepare()) != null && prepare.length() > 0) {
            return prepare;
        }
        return null;
    }

    public static boolean needInstanceName(Operation op) {
        if (op.isStatic()) {
            return false;
        }
        return !StereotypeUtil.isApplied((Element)op, Create.class);
    }

    public static List<Parameter> getInAndInout(Operation op) {
        ArrayList<Parameter> list = new ArrayList<Parameter>();
        for (Parameter param : op.getOwnedParameters()) {
            if (param.getDirection() != ParameterDirectionKind.IN_LITERAL && param.getDirection() != ParameterDirectionKind.INOUT_LITERAL) continue;
            list.add(param);
        }
        return list;
    }
}

