/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.ease.AbstractCodeParser;
import org.eclipse.ease.ICodeFactory;
import org.eclipse.ease.IScriptEngine;
import org.eclipse.ease.Logger;
import org.eclipse.ease.modules.IEnvironment;
import org.eclipse.ease.modules.ModuleHelper;
import org.eclipse.ease.modules.WrapToScript;

public abstract class AbstractCodeFactory
implements ICodeFactory {
    public static final String LINE_DELIMITER = System.getProperty("line.separator");

    protected String buildParameterList(List<ICodeFactory.Parameter> parameters) {
        StringBuilder parameterList = new StringBuilder();
        for (ICodeFactory.Parameter parameter : parameters) {
            parameterList.append(", ").append(this.toSafeName(parameter.getName()));
        }
        if (parameterList.length() > 2) {
            parameterList.delete(0, 2);
        }
        return parameterList.toString();
    }

    @Override
    public String createKeywordHeader(Map<String, String> keywords, String existingHeader) {
        StringBuilder header = new StringBuilder();
        if (existingHeader == null) {
            existingHeader = "";
        }
        String[] existingLines = existingHeader.split("\\r?\\n");
        int index = 0;
        while (index < existingLines.length) {
            Matcher matcher = AbstractCodeParser.PARAMETER_PATTERN.matcher(existingLines[index]);
            if (matcher.matches()) break;
            header.append(existingLines[index]).append(LINE_DELIMITER);
            ++index;
        }
        if (header.length() > 0 && !keywords.isEmpty()) {
            header.append(LINE_DELIMITER);
        }
        for (Map.Entry<String, String> entry : keywords.entrySet()) {
            header.append(entry.getKey());
            header.append(new String(new char[Math.max(16 - entry.getKey().length(), 1)]).replace('\u0000', ' '));
            header.append(": ");
            header.append(entry.getValue()).append(LINE_DELIMITER);
        }
        boolean isFirstLineAfterKeywords = true;
        while (index < existingLines.length) {
            Matcher matcher = AbstractCodeParser.PARAMETER_PATTERN.matcher(existingLines[index]);
            if (!matcher.matches()) {
                if (isFirstLineAfterKeywords) {
                    header.append(LINE_DELIMITER);
                    isFirstLineAfterKeywords = false;
                }
                header.append(existingLines[index]).append(LINE_DELIMITER);
            }
            ++index;
        }
        return header.toString();
    }

    @Override
    public String getDefaultValue(ICodeFactory.Parameter parameter) {
        String defaultStringValue = parameter.getDefaultValue().replaceAll("\\r", "\\\\r").replaceAll("\\n", "\\\\n");
        Class<String> clazz = parameter.getClazz();
        if ("org.eclipse.ease.modules.ScriptParameter.null".equals(defaultStringValue)) {
            return this.getNullString();
        }
        if (Integer.class.equals(clazz) || Integer.TYPE.equals(clazz)) {
            try {
                return Integer.toString(Integer.parseInt(defaultStringValue));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (Long.class.equals(clazz) || Long.TYPE.equals(clazz)) {
            try {
                return Long.toString(Long.parseLong(defaultStringValue));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (Float.class.equals(clazz) || Float.TYPE.equals(clazz)) {
            try {
                return Float.toString(Float.parseFloat(defaultStringValue));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (Double.class.equals(clazz) || Double.TYPE.equals(clazz)) {
            try {
                return Double.toString(Double.parseDouble(defaultStringValue));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (Boolean.class.equals(clazz) || Boolean.TYPE.equals(clazz)) {
            return Boolean.parseBoolean(defaultStringValue) ? this.getTrueString() : this.getFalseString();
        }
        if (String.class.equals(clazz)) {
            return "\"" + defaultStringValue + "\"";
        }
        if ("org.eclipse.ease.modules.ScriptParameter.undefined".equals(defaultStringValue)) {
            try {
                clazz.getConstructor(new Class[0]);
                return this.classInstantiation(clazz, null);
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        try {
            clazz.getConstructor(String.class);
            return this.classInstantiation(clazz, new String[]{"\"" + defaultStringValue + "\""});
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (clazz.isAssignableFrom(String.class)) {
            return this.classInstantiation(String.class, new String[]{"\"" + defaultStringValue + "\""});
        }
        return this.getNullString();
    }

    public static Collection<String> getMethodNames(Method method) {
        HashSet<String> methodNames = new HashSet<String>();
        methodNames.add(method.getName());
        methodNames.addAll(AbstractCodeFactory.getMethodAliases(method));
        return methodNames;
    }

    public static Collection<String> getMethodAliases(Method method) {
        HashSet<String> methodAliases = new HashSet<String>();
        WrapToScript wrapAnnotation = method.getAnnotation(WrapToScript.class);
        if (wrapAnnotation != null) {
            String[] stringArray = wrapAnnotation.alias().split(";");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                if (!name.trim().isEmpty()) {
                    methodAliases.add(name.trim());
                }
                ++n2;
            }
        }
        return methodAliases;
    }

    protected abstract String getNullString();

    protected String getTrueString() {
        return Boolean.TRUE.toString();
    }

    protected String getFalseString() {
        return Boolean.FALSE.toString();
    }

    @Override
    public String createFunctionCall(Method method, Object ... parameters) {
        StringBuilder code = new StringBuilder();
        code.append(method.getName()).append('(');
        Object[] objectArray = parameters;
        int n = parameters.length;
        int n2 = 0;
        while (n2 < n) {
            Object parameter = objectArray[n2];
            if (parameter instanceof String) {
                code.append('\"').append(((String)parameter).replace("\"", "\\\"").replace("\\", "\\\\")).append('\"');
            } else if (parameter == null) {
                code.append(this.getNullString());
            } else if (parameter instanceof Boolean) {
                code.append((Boolean)parameter != false ? this.getTrueString() : this.getFalseString());
            } else {
                code.append(parameter.toString());
            }
            code.append(", ");
            ++n2;
        }
        if (parameters.length > 0) {
            code.delete(code.length() - 2, code.length());
        }
        code.append(");");
        return code.toString();
    }

    protected String getSingleLineCommentToken() {
        return "// ";
    }

    protected String getMultiLineCommentStartToken() {
        return "/*";
    }

    protected String getMultiLineCommentEndToken() {
        return "*/";
    }

    @Override
    public String createCommentedString(String comment, boolean addBlockComment) {
        if (addBlockComment) {
            return String.valueOf(this.getMultiLineCommentStartToken()) + comment + this.getMultiLineCommentEndToken();
        }
        String token = this.getSingleLineCommentToken();
        Stream<String> split = Pattern.compile("\r?\n").splitAsStream(comment);
        return split.map(s -> String.valueOf(token) + s).collect(Collectors.joining(System.lineSeparator()));
    }

    @Override
    public String createWrapper(IEnvironment environment, Object instance, String identifier, boolean customNamespace, IScriptEngine engine) {
        if (!customNamespace) {
            StringBuilder scriptCode = new StringBuilder();
            for (Method method : ModuleHelper.getMethods(instance.getClass())) {
                String code;
                if (!this.isSupportedByLanguage(method) || (code = this.createFunctionWrapper(environment, identifier, method)) == null || code.isEmpty()) continue;
                scriptCode.append(code);
                scriptCode.append('\n');
            }
            for (Field field : ModuleHelper.getFields(instance.getClass())) {
                if (!this.isSupportedByLanguage(field)) continue;
                try {
                    Object toBeInjected = field.get(instance);
                    if (!engine.hasVariable(this.getSaveVariableName(field.getName()))) {
                        engine.setVariable(this.getSaveVariableName(field.getName()), toBeInjected);
                        continue;
                    }
                    Object existing = engine.getVariable(this.getSaveVariableName(field.getName()));
                    if ((existing == null || existing.equals(toBeInjected)) && (existing != null || toBeInjected == null)) continue;
                    Logger.trace("org.eclipse.ease", ICodeFactory.TRACE_MODULE_WRAPPER, "Skipped wrapping of field \"" + field.getName() + "\" (module \"" + instance.getClass().getName() + "\") as variable is already declared.");
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    Logger.error("org.eclipse.ease", "Could not wrap field \"" + field.getName() + " \" of module \"" + instance.getClass() + "\".", e);
                }
            }
            return scriptCode.toString();
        }
        throw new RuntimeException("Object wrappers not supported by default wrapper");
    }

    protected boolean isSupportedByLanguage(Method method) {
        return this.isSupportedByLanguage(method.getAnnotation(WrapToScript.class));
    }

    protected boolean isSupportedByLanguage(Field field) {
        return this.isSupportedByLanguage(field.getAnnotation(WrapToScript.class));
    }

    private boolean isSupportedByLanguage(WrapToScript annotation) {
        String languages;
        if (annotation != null && !(languages = annotation.supportedLanguages().trim()).isEmpty()) {
            String[] supportedLanguages = languages.split(",");
            if (supportedLanguages[0].startsWith("!")) {
                String[] stringArray = supportedLanguages;
                int n = supportedLanguages.length;
                int n2 = 0;
                while (n2 < n) {
                    String language = stringArray[n2];
                    if (language.substring(1).equals(this.getLanguageIdentifier())) {
                        return false;
                    }
                    ++n2;
                }
            } else {
                String[] stringArray = supportedLanguages;
                int n = supportedLanguages.length;
                int n3 = 0;
                while (n3 < n) {
                    String language = stringArray[n3];
                    if (language.equals(this.getLanguageIdentifier())) {
                        return true;
                    }
                    ++n3;
                }
                return false;
            }
        }
        return true;
    }

    protected abstract Object getLanguageIdentifier();

    protected abstract String createFunctionWrapper(IEnvironment var1, String var2, Method var3);

    protected abstract String toSafeName(String var1);
}

