/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.BadStateException;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.LayersException;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.command.ComputePropertyValueCommand;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayerExpression;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayerState;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayersPackage;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayersStack;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.Property;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.notifier.ILayersTreeEventListener;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.notifier.LayersTreeEventNotifier;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.notifier.LayersTreeEventNotifierFactory;

public class LayersStackImpl
extends EObjectImpl
implements LayersStack {
    protected LayerExpression layers;
    protected static final String NAME_EDEFAULT = null;
    protected String name = NAME_EDEFAULT;
    protected static final String DESCRIPTION_EDEFAULT = null;
    protected String description = DESCRIPTION_EDEFAULT;
    protected Diagram diagram;
    protected static final LayerState STATE_EDEFAULT = LayerState.DETACHED;
    protected LayerState state = STATE_EDEFAULT;
    private ILayersTreeEventListener layersTreeEventListener = new ILayersTreeEventListener(){

        @Override
        public void layerSet(Notification notification) {
            LayersStackImpl.this.layerAdded((LayerExpression)notification.getNewValue());
        }

        @Override
        public void layerRemoved(Notification notification) {
        }

        @Override
        public void layerMoved(Notification notification) {
        }

        @Override
        public void layerAdded(Notification notification) {
            LayersStackImpl.this.layerAdded((LayerExpression)notification.getNewValue());
        }
    };

    protected LayersStackImpl() {
    }

    private void init() {
        LayersTreeEventNotifier layersTreeEventnotifier = LayersTreeEventNotifierFactory.instance.adapt((Notifier)this);
        layersTreeEventnotifier.addLayersModelEventListener(this.layersTreeEventListener);
    }

    protected EClass eStaticClass() {
        return LayersPackage.Literals.LAYERS_STACK;
    }

    @Override
    public LayerExpression getLayers() {
        return this.layers;
    }

    public NotificationChain basicSetLayers(LayerExpression newLayers, NotificationChain msgs) {
        LayerExpression oldLayers = this.layers;
        this.layers = newLayers;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldLayers, (Object)newLayers);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setLayers(LayerExpression newLayers) {
        if (newLayers != this.layers) {
            NotificationChain msgs = null;
            if (this.layers != null) {
                msgs = ((InternalEObject)this.layers).eInverseRemove((InternalEObject)this, -1, null, msgs);
            }
            if (newLayers != null) {
                msgs = ((InternalEObject)newLayers).eInverseAdd((InternalEObject)this, -1, null, msgs);
            }
            if ((msgs = this.basicSetLayers(newLayers, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)newLayers, (Object)newLayers));
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldName, (Object)this.name));
        }
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String newDescription) {
        String oldDescription = this.description;
        this.description = newDescription;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldDescription, (Object)this.description));
        }
    }

    @Override
    public Diagram getDiagram() {
        if (this.diagram != null && this.diagram.eIsProxy()) {
            InternalEObject oldDiagram = (InternalEObject)this.diagram;
            this.diagram = (Diagram)this.eResolveProxy(oldDiagram);
            if (this.diagram != oldDiagram && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 3, (Object)oldDiagram, (Object)this.diagram));
            }
        }
        return this.diagram;
    }

    public Diagram basicGetDiagram() {
        return this.diagram;
    }

    @Override
    public void setDiagram(Diagram newDiagram) {
        Diagram oldDiagram = this.diagram;
        this.diagram = newDiagram;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldDiagram, (Object)this.diagram));
        }
    }

    @Override
    public LayerState getState() {
        return this.state;
    }

    @Override
    public void setState(LayerState newState) {
        LayerState oldState = this.state;
        LayerState layerState = this.state = newState == null ? STATE_EDEFAULT : newState;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)oldState, (Object)this.state));
        }
    }

    @Override
    public void addLayer(LayerExpression layer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ComputePropertyValueCommand getComputePropertyValueCommand(View view, Property property) throws LayersException {
        LayerExpression layers = this.getLayers();
        if (layers == null) {
            throw new BadStateException("Layers should be set first.");
        }
        return layers.getComputePropertyValueCommand(view, property);
    }

    @Override
    public EList<ComputePropertyValueCommand> getPropertiesComputePropertyValueCommand(View view, EList<Property> property) throws LayersException {
        throw new UnsupportedOperationException();
    }

    @Override
    public EList<ComputePropertyValueCommand> getViewsComputePropertyValueCommand(EList<View> view, Property property) throws LayersException {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void startAfterCreation() {
        if (this.getLayers() != null) {
            this.getLayers().attachToLayersStack(this);
        }
        this.init();
    }

    @Override
    public void attachLayers() throws LayersException {
        if (this.getLayers() != null) {
            this.getLayers().attach();
        }
    }

    @Override
    public void attach() throws LayersException {
        if (this.getState() == LayerState.ATTACHED) {
            return;
        }
        if (this.getDiagram() == null) {
            throw new BadStateException("A required attribute is not set. The Layer can't be attached.[layerName=" + this.getName() + ", diagram=" + (this.getDiagram() == null ? "null" : "ok") + "]");
        }
        this.setState(LayerState.ATTACHED);
        this.enterAttachedState();
        this.attachLayers();
    }

    @Override
    public void detach() throws LayersException {
        this.exitAttachedState();
        this.setState(LayerState.DETACHED);
        if (this.getLayers() != null) {
            this.getLayers().detach();
        }
    }

    @Override
    public void enterAttachedState() throws LayersException {
        this.init();
    }

    @Override
    public void exitAttachedState() {
        throw new UnsupportedOperationException();
    }

    @Override
    public EList<ComputePropertyValueCommand> getPropertiesComputePropertyValueCommand(View view, List<Property> property) throws LayersException {
        LayerExpression layers = this.getLayers();
        if (layers == null) {
            throw new BadStateException("Layers should be set first.");
        }
        return layers.getPropertiesComputePropertyValueCommand(view, property);
    }

    @Override
    public EList<ComputePropertyValueCommand> getViewsComputePropertyValueCommand(List<View> view, Property property) throws LayersException {
        LayerExpression layers = this.getLayers();
        if (layers == null) {
            throw new BadStateException("Layers should be set first.");
        }
        return layers.getViewsComputePropertyValueCommand(view, property);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                return this.basicSetLayers(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getLayers();
            }
            case 1: {
                return this.getName();
            }
            case 2: {
                return this.getDescription();
            }
            case 3: {
                if (resolve) {
                    return this.getDiagram();
                }
                return this.basicGetDiagram();
            }
            case 4: {
                return this.getState();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setLayers((LayerExpression)newValue);
                return;
            }
            case 1: {
                this.setName((String)newValue);
                return;
            }
            case 2: {
                this.setDescription((String)newValue);
                return;
            }
            case 3: {
                this.setDiagram((Diagram)newValue);
                return;
            }
            case 4: {
                this.setState((LayerState)((Object)newValue));
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setLayers(null);
                return;
            }
            case 1: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 2: {
                this.setDescription(DESCRIPTION_EDEFAULT);
                return;
            }
            case 3: {
                this.setDiagram(null);
                return;
            }
            case 4: {
                this.setState(STATE_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.layers != null;
            }
            case 1: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 2: {
                return DESCRIPTION_EDEFAULT == null ? this.description != null : !DESCRIPTION_EDEFAULT.equals(this.description);
            }
            case 3: {
                return this.diagram != null;
            }
            case 4: {
                return this.state != STATE_EDEFAULT;
            }
        }
        return super.eIsSet(featureID);
    }

    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 0: {
                this.addLayer((LayerExpression)arguments.get(0));
                return null;
            }
            case 1: {
                try {
                    return this.getComputePropertyValueCommand((View)arguments.get(0), (Property)arguments.get(1));
                }
                catch (Throwable throwable) {
                    throw new InvocationTargetException(throwable);
                }
            }
            case 2: {
                try {
                    return this.getPropertiesComputePropertyValueCommand((View)arguments.get(0), (EList<Property>)((EList)arguments.get(1)));
                }
                catch (Throwable throwable) {
                    throw new InvocationTargetException(throwable);
                }
            }
            case 3: {
                try {
                    return this.getViewsComputePropertyValueCommand((EList<View>)((EList)arguments.get(0)), (Property)arguments.get(1));
                }
                catch (Throwable throwable) {
                    throw new InvocationTargetException(throwable);
                }
            }
            case 4: {
                this.startAfterCreation();
                return null;
            }
            case 5: {
                try {
                    this.attachLayers();
                    return null;
                }
                catch (Throwable throwable) {
                    throw new InvocationTargetException(throwable);
                }
            }
            case 6: {
                try {
                    this.attach();
                    return null;
                }
                catch (Throwable throwable) {
                    throw new InvocationTargetException(throwable);
                }
            }
            case 7: {
                try {
                    this.detach();
                    return null;
                }
                catch (Throwable throwable) {
                    throw new InvocationTargetException(throwable);
                }
            }
            case 8: {
                try {
                    this.enterAttachedState();
                    return null;
                }
                catch (Throwable throwable) {
                    throw new InvocationTargetException(throwable);
                }
            }
            case 9: {
                this.exitAttachedState();
                return null;
            }
        }
        return super.eInvoke(operationID, arguments);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (name: ");
        result.append(this.name);
        result.append(", description: ");
        result.append(this.description);
        result.append(", state: ");
        result.append((Object)this.state);
        result.append(')');
        return result.toString();
    }

    protected void layerAdded(LayerExpression addedLayer) {
        if (addedLayer == null) {
            return;
        }
        addedLayer.attachToLayersStack(this);
    }
}

