/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.notifier;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.notifier.IUmlNamedElementChangedEventListener;
import org.eclipse.uml2.uml.NamedElement;

public class UmlNamedElementChangedEventNotifier
extends EContentAdapter {
    boolean isDisposed = false;
    protected List<IUmlNamedElementChangedEventListener> listeners = new ArrayList<IUmlNamedElementChangedEventListener>();

    public void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        if (!(notification.getNotifier() instanceof NamedElement)) {
            return;
        }
        this.fireValueChangedEvent(notification);
    }

    public boolean isAdapterForType(Object type) {
        return type == UmlNamedElementChangedEventNotifier.class;
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        this.isDisposed = true;
        this.listeners.clear();
    }

    public boolean isDisposed() {
        return this.isDisposed;
    }

    public void addEventListener(IUmlNamedElementChangedEventListener listener) {
        if (listener == null) {
            return;
        }
        if (this.listeners.contains(listener)) {
            return;
        }
        this.listeners.add(listener);
    }

    public void removeEventListener(IUmlNamedElementChangedEventListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireValueChangedEvent(Notification msg) {
        for (IUmlNamedElementChangedEventListener listener : this.listeners) {
            listener.valueChanged(msg);
        }
    }
}

