/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.loaders;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.configmodel.layersconfig.Folder;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.configmodel.layersconfig.LayerOperatorConfig;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.configmodel.layersconfig.LayerOperatorMultipleBinding;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.configmodel.layersconfig.LayersConfigFactory;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.configmodel.layersconfig.OperatorBinding;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.configmodel.layersconfig.OperatorConfig;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.configmodel.layersconfig.PropertyId;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.configmodel.layersconfig.TypeConfig;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayersPackage;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.loaders.LayersConfigModelUtils;

public class LayersConfigModel {
    protected static final LayersConfigModel instance = new LayersConfigModel();
    protected Resource resource;

    static {
        instance.initDefaultModel();
    }

    public LayersConfigModel() {
        this.createResourceAndRootFolder();
    }

    public static LayersConfigModel getInstance() {
        return instance;
    }

    private void initDefaultModel() {
        Folder layeropFolder = LayersConfigModelUtils.createFolder(this.getRootFolder(), "layerOp");
        LayerOperatorConfig stackedLayersOperatorConfig = LayersConfigModelUtils.createLayerOperatorConfig(layeropFolder, "stackedLayersOperator", LayersPackage.eINSTANCE.getStackedLayerOperatorDescriptor().getName());
        LayerOperatorConfig stackedLayersOperatorMinimunConfig = LayersConfigModelUtils.createLayerOperatorConfig(layeropFolder, "stackedLayersOperatorMinimum", LayersPackage.eINSTANCE.getStackedLayerOperatorDescriptor().getName());
        LayersConfigModelUtils.createLayerOperatorConfig(layeropFolder, "stackedLayersOperatorMaximum", LayersPackage.eINSTANCE.getStackedLayerOperatorDescriptor().getName());
        LayerOperatorConfig stackedLayersOperatorAverage = LayersConfigModelUtils.createLayerOperatorConfig(layeropFolder, "stackedLayersOperatorAverage", LayersPackage.eINSTANCE.getStackedLayerOperatorDescriptor().getName());
        Folder operatorFolder = LayersConfigModelUtils.createFolder(this.getRootFolder(), "operatorDesc");
        Folder typeFolder = LayersConfigModelUtils.createFolder(this.getRootFolder(), "types");
        TypeConfig typeBoolean = LayersConfigModelUtils.createTypeConfig(typeFolder, "boolean");
        TypeConfig typeInt = LayersConfigModelUtils.createTypeConfig(typeFolder, "int");
        TypeConfig typeString = LayersConfigModelUtils.createTypeConfig(typeFolder, "String");
        TypeConfig typeFont = LayersConfigModelUtils.createTypeConfig(typeFolder, "Font");
        TypeConfig typeColor = LayersConfigModelUtils.createTypeConfig(typeFolder, "Color");
        TypeConfig typeFill = LayersConfigModelUtils.createTypeConfig(typeFolder, "Fill");
        TypeConfig typeLine = LayersConfigModelUtils.createTypeConfig(typeFolder, "Line");
        Folder propertiesFolder = LayersConfigModelUtils.createFolder(this.getRootFolder(), "properties");
        PropertyId propertyIsVisible = LayersConfigModelUtils.createPropertyId(propertiesFolder, "isVisible", typeBoolean);
        PropertyId propertyIsAbstract = LayersConfigModelUtils.createPropertyId(propertiesFolder, "isAbstract", typeBoolean);
        PropertyId propertyFill = LayersConfigModelUtils.createPropertyId(propertiesFolder, "fill", typeFill);
        PropertyId propertyLine = LayersConfigModelUtils.createPropertyId(propertiesFolder, "line", typeLine);
        PropertyId propertyFont = LayersConfigModelUtils.createPropertyId(propertiesFolder, "font", typeFont);
        PropertyId propertyBgcolor = LayersConfigModelUtils.createPropertyId(propertiesFolder, "bgcolor", typeColor);
        PropertyId propertyFgcolor = LayersConfigModelUtils.createPropertyId(propertiesFolder, "fgcolor", typeColor);
        PropertyId propertyCSS = LayersConfigModelUtils.createPropertyId(propertiesFolder, "css", typeString);
        Folder opBindingFolder = LayersConfigModelUtils.createFolder(this.getRootFolder(), "opBindings");
        LayerOperatorMultipleBinding layerOpBindingsA = LayersConfigModelUtils.createLayerOperatorsMultipleBinding(opBindingFolder, stackedLayersOperatorConfig);
        LayerOperatorMultipleBinding layerOpBindingsB = LayersConfigModelUtils.createLayerOperatorsMultipleBinding(opBindingFolder, stackedLayersOperatorMinimunConfig);
        LayerOperatorMultipleBinding layerOpBindingsAverage = LayersConfigModelUtils.createLayerOperatorsMultipleBinding(opBindingFolder, stackedLayersOperatorAverage);
    }

    protected Folder createResourceAndRootFolder() {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        URI fileURI = URI.createURI((String)"config.layersconfig");
        this.resource = resourceSet.createResource(fileURI);
        Folder parent = LayersConfigFactory.eINSTANCE.createFolder();
        this.resource.getContents().add((Object)parent);
        return parent;
    }

    public Resource getResource() {
        return this.resource;
    }

    public Folder getRootFolder() {
        return (Folder)this.getResource().getContents().get(0);
    }

    public List<LayerOperatorConfig> getAllLayerOperatorConfig() {
        ArrayList<LayerOperatorConfig> res = new ArrayList<LayerOperatorConfig>();
        TreeIterator iter = this.resource.getAllContents();
        while (iter.hasNext()) {
            EObject obj = (EObject)iter.next();
            if (!(obj instanceof LayerOperatorConfig)) continue;
            res.add((LayerOperatorConfig)obj);
        }
        return res;
    }

    public <T extends EObject> List<T> getAllOfType(Class<T> type) {
        ArrayList<EObject> res = new ArrayList<EObject>();
        TreeIterator iter = this.resource.getAllContents();
        while (iter.hasNext()) {
            EObject obj = (EObject)iter.next();
            if (!type.isInstance(obj)) continue;
            res.add(obj);
        }
        return res;
    }

    public List<OperatorConfig> getAllOperatorConfig() {
        return this.getAllOfType(OperatorConfig.class);
    }

    public List<OperatorBinding> getAllOperatorBinding() {
        return this.getAllOfType(OperatorBinding.class);
    }

    private void initLayersConfigModel(LayersConfigModel model) {
    }
}

