/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.internal.infra.gmfdiag.layers.ui.commands;

import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.papyrus.infra.core.resource.NotFoundException;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.LayersException;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.AbstractLayer;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayersStackApplication;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.Property;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.ui.commands.AbstractLayersCommand;

public class AttachCSSToLayer
extends AbstractLayersCommand {
    @Override
    public String getCommandName() {
        return "Attach a CSS";
    }

    @Override
    protected void doExecute(ExecutionEvent event, IEvaluationContext context, List<Object> selections) {
        if (!this.isEnabled(context, selections)) {
            return;
        }
        try {
            LayersStackApplication application = this.lookupLayersStackApplicationChecked(context);
            AbstractLayer layer = (AbstractLayer)this.getSelections(context).get(0);
            Property CSSproperty = application.getPropertyRegistry().getProperty("css");
            layer.addPropertyInstance(CSSproperty);
        }
        catch (LayersException e) {
            e.printStackTrace();
        }
        catch (NotFoundException e) {
            e.printStackTrace();
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean isEnabled(IEvaluationContext context, List<Object> selections) {
        return this.selectionFirstElementInstanceOf(selections, AbstractLayer.class);
    }
}

