/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.impl.custom;

import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.NotFoundException;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayerApplicationFactory;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayerDescriptorRegistry;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayerOperatorDescriptorRegistry;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayerStackDescriptorRegistry;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayersFactory;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayersStack;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.PropertyRegistry;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.PropertySetterRegistry;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.TopLayerOperator;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.impl.LayersStackApplicationImpl;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.loaders.LayersConfigModel;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.loaders.RegistriesLoader;

public class CustomLayersStackApplicationImpl
extends LayersStackApplicationImpl {
    protected CustomLayersStackApplicationImpl() {
        this.init();
    }

    protected void init() {
        PropertyRegistry propertyRegistry = LayersFactory.eINSTANCE.createPropertyRegistry();
        this.setPropertyRegistry(propertyRegistry);
        LayerStackDescriptorRegistry layerStackDescriptorRegistry = LayersFactory.eINSTANCE.createLayerStackDescriptorRegistry();
        this.setLayerStackRegistry(layerStackDescriptorRegistry);
        LayerDescriptorRegistry layerDescriptorRegistry = LayersFactory.eINSTANCE.createLayerDescriptorRegistry();
        this.setLayerDescriptorRegistry(layerDescriptorRegistry);
        LayersConfigModel configModel = LayersConfigModel.getInstance();
        RegistriesLoader registriesLoader = new RegistriesLoader(configModel);
        LayerOperatorDescriptorRegistry layerOperatorDescriptorRegistry = LayersFactory.eINSTANCE.createLayerOperatorDescriptorRegistry();
        layerOperatorDescriptorRegistry.setPropertyCollectionSize(propertyRegistry.getPropertiesCount());
        registriesLoader.loadLayerOperatorDescriptorRegistry(layerOperatorDescriptorRegistry, propertyRegistry);
        this.setLayerOperatorDescriptorRegistry(layerOperatorDescriptorRegistry);
        LayerApplicationFactory layerApplicationFactory = LayersFactory.eINSTANCE.createLayerApplicationFactory();
        this.setFactory(layerApplicationFactory);
        PropertySetterRegistry propertySetterRegistry = LayersFactory.eINSTANCE.createPropertySetterRegistry();
        propertySetterRegistry.setApplication(this);
        this.setPropertySetterRegistry(propertySetterRegistry);
    }

    @Override
    public void removeLayersStackFor(Diagram diagram) {
        try {
            LayersStack stack = this.lookupLayersStackFor(diagram);
            this.getLayersStacks().remove(stack);
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    @Override
    public boolean isLayersStackAttachedFor(Diagram diagram) {
        try {
            this.lookupLayersStackFor(diagram);
            return true;
        }
        catch (NotFoundException e) {
            return false;
        }
    }

    @Override
    public LayersStack lookupLayersStackFor(Diagram diagram) throws NotFoundException {
        for (LayersStack stack : this.getLayersStacks()) {
            if (stack.getDiagram() != diagram) continue;
            return stack;
        }
        throw new NotFoundException("No LayersStack attached for diagram: " + diagram);
    }

    @Override
    public LayersStack getLayersStackFor(Diagram diagram) {
        try {
            return this.lookupLayersStackFor(diagram);
        }
        catch (NotFoundException e) {
            return this.createLayersStackFor(diagram);
        }
    }

    @Override
    public LayersStack createLayersStackFor(Diagram diagram) {
        LayersStack layer = LayersFactory.eINSTANCE.createLayersStack();
        layer.startAfterCreation();
        layer.setDiagram(diagram);
        TopLayerOperator rootLayer = LayersFactory.eINSTANCE.createTopLayerOperator();
        rootLayer.setName("Top Layer");
        rootLayer.setApplication(this);
        layer.setLayers(rootLayer);
        this.getLayersStacks().add(layer);
        return layer;
    }
}

