/**
 * Copyright (c) 2018 CEA
 * 
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Jrmie Tatibouet (CEA) jeremie.tatibouet@cea.fr - Initial API and implementation
 *   Benoit Maggi (CEA) benoit.maggi@cea.fr - Initial API and implementation
 * 
 */
package  org.eclipse.papyrus.iotml.hardware.actuator;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;

import org.eclipse.papyrus.MARTE.MARTE_DesignModel.HRM.HwLogical.HwDevice.HwDevicePackage;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see org.eclipse.papyrus.iotml.hardware.actuator.ActuatorFactory
 * @model kind="package"
 *        annotation="http://www.eclipse.org/uml2/2.0.0/UML originalName='Actuator'"
 * @generated
 */
public interface ActuatorPackage extends EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "actuator";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://www.eclipse.org/papyrus/iotml/0.7/IoTML/Hardware/Actuator";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "Actuator";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	ActuatorPackage eINSTANCE = org.eclipse.papyrus.iotml.hardware.actuator.impl.ActuatorPackageImpl.init();

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.iotml.hardware.actuator.impl.HwCommonActuatorImpl <em>Hw Common Actuator</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.iotml.hardware.actuator.impl.HwCommonActuatorImpl
	 * @see org.eclipse.papyrus.iotml.hardware.actuator.impl.ActuatorPackageImpl#getHwCommonActuator()
	 * @generated
	 */
	int HW_COMMON_ACTUATOR = 0;

	/**
	 * The feature id for the '<em><b>Res Mult</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_COMMON_ACTUATOR__RES_MULT = HwDevicePackage.HW_ACTUATOR__RES_MULT;

	/**
	 * The feature id for the '<em><b>Is Protected</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_COMMON_ACTUATOR__IS_PROTECTED = HwDevicePackage.HW_ACTUATOR__IS_PROTECTED;

	/**
	 * The feature id for the '<em><b>Is Active</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_COMMON_ACTUATOR__IS_ACTIVE = HwDevicePackage.HW_ACTUATOR__IS_ACTIVE;

	/**
	 * The feature id for the '<em><b>Base Property</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_COMMON_ACTUATOR__BASE_PROPERTY = HwDevicePackage.HW_ACTUATOR__BASE_PROPERTY;

	/**
	 * The feature id for the '<em><b>Base Instance Specification</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_COMMON_ACTUATOR__BASE_INSTANCE_SPECIFICATION = HwDevicePackage.HW_ACTUATOR__BASE_INSTANCE_SPECIFICATION;

	/**
	 * The feature id for the '<em><b>Base Classifier</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_COMMON_ACTUATOR__BASE_CLASSIFIER = HwDevicePackage.HW_ACTUATOR__BASE_CLASSIFIER;

	/**
	 * The feature id for the '<em><b>Base Lifeline</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_COMMON_ACTUATOR__BASE_LIFELINE = HwDevicePackage.HW_ACTUATOR__BASE_LIFELINE;

	/**
	 * The feature id for the '<em><b>Base Connectable Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_COMMON_ACTUATOR__BASE_CONNECTABLE_ELEMENT = HwDevicePackage.HW_ACTUATOR__BASE_CONNECTABLE_ELEMENT;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_COMMON_ACTUATOR__DESCRIPTION = HwDevicePackage.HW_ACTUATOR__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Frequency</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_COMMON_ACTUATOR__FREQUENCY = HwDevicePackage.HW_ACTUATOR__FREQUENCY;

	/**
	 * The feature id for the '<em><b>End Points</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_COMMON_ACTUATOR__END_POINTS = HwDevicePackage.HW_ACTUATOR__END_POINTS;

	/**
	 * The feature id for the '<em><b>PHW Services</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_COMMON_ACTUATOR__PHW_SERVICES = HwDevicePackage.HW_ACTUATOR__PHW_SERVICES;

	/**
	 * The feature id for the '<em><b>RHW Services</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_COMMON_ACTUATOR__RHW_SERVICES = HwDevicePackage.HW_ACTUATOR__RHW_SERVICES;

	/**
	 * The feature id for the '<em><b>Owned HW</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_COMMON_ACTUATOR__OWNED_HW = HwDevicePackage.HW_ACTUATOR__OWNED_HW;

	/**
	 * The feature id for the '<em><b>Speed Factor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_COMMON_ACTUATOR__SPEED_FACTOR = HwDevicePackage.HW_ACTUATOR__SPEED_FACTOR;

	/**
	 * The feature id for the '<em><b>Main Scheduler</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_COMMON_ACTUATOR__MAIN_SCHEDULER = HwDevicePackage.HW_ACTUATOR__MAIN_SCHEDULER;

	/**
	 * The feature id for the '<em><b>Energy Kind</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_COMMON_ACTUATOR__ENERGY_KIND = HwDevicePackage.HW_ACTUATOR_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Movement Kind</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_COMMON_ACTUATOR__MOVEMENT_KIND = HwDevicePackage.HW_ACTUATOR_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Is Powered</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_COMMON_ACTUATOR__IS_POWERED = HwDevicePackage.HW_ACTUATOR_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Hw Common Actuator</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HW_COMMON_ACTUATOR_FEATURE_COUNT = HwDevicePackage.HW_ACTUATOR_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.iotml.hardware.actuator.EnergyKind <em>Energy Kind</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.iotml.hardware.actuator.EnergyKind
	 * @see org.eclipse.papyrus.iotml.hardware.actuator.impl.ActuatorPackageImpl#getEnergyKind()
	 * @generated
	 */
	int ENERGY_KIND = 1;

	/**
	 * The meta object id for the '{@link org.eclipse.papyrus.iotml.hardware.actuator.MovementKind <em>Movement Kind</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.papyrus.iotml.hardware.actuator.MovementKind
	 * @see org.eclipse.papyrus.iotml.hardware.actuator.impl.ActuatorPackageImpl#getMovementKind()
	 * @generated
	 */
	int MOVEMENT_KIND = 2;


	/**
	 * Returns the meta object for class '{@link org.eclipse.papyrus.iotml.hardware.actuator.HwCommonActuator <em>Hw Common Actuator</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Hw Common Actuator</em>'.
	 * @see org.eclipse.papyrus.iotml.hardware.actuator.HwCommonActuator
	 * @generated
	 */
	EClass getHwCommonActuator();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.papyrus.iotml.hardware.actuator.HwCommonActuator#getEnergyKind <em>Energy Kind</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Energy Kind</em>'.
	 * @see org.eclipse.papyrus.iotml.hardware.actuator.HwCommonActuator#getEnergyKind()
	 * @see #getHwCommonActuator()
	 * @generated
	 */
	EAttribute getHwCommonActuator_EnergyKind();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.papyrus.iotml.hardware.actuator.HwCommonActuator#getMovementKind <em>Movement Kind</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Movement Kind</em>'.
	 * @see org.eclipse.papyrus.iotml.hardware.actuator.HwCommonActuator#getMovementKind()
	 * @see #getHwCommonActuator()
	 * @generated
	 */
	EAttribute getHwCommonActuator_MovementKind();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.papyrus.iotml.hardware.actuator.HwCommonActuator#isPowered <em>Is Powered</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Is Powered</em>'.
	 * @see org.eclipse.papyrus.iotml.hardware.actuator.HwCommonActuator#isPowered()
	 * @see #getHwCommonActuator()
	 * @generated
	 */
	EAttribute getHwCommonActuator_IsPowered();

	/**
	 * Returns the meta object for enum '{@link org.eclipse.papyrus.iotml.hardware.actuator.EnergyKind <em>Energy Kind</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Energy Kind</em>'.
	 * @see org.eclipse.papyrus.iotml.hardware.actuator.EnergyKind
	 * @generated
	 */
	EEnum getEnergyKind();

	/**
	 * Returns the meta object for enum '{@link org.eclipse.papyrus.iotml.hardware.actuator.MovementKind <em>Movement Kind</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Movement Kind</em>'.
	 * @see org.eclipse.papyrus.iotml.hardware.actuator.MovementKind
	 * @generated
	 */
	EEnum getMovementKind();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	ActuatorFactory getActuatorFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals {
		/**
		 * The meta object literal for the '{@link org.eclipse.papyrus.iotml.hardware.actuator.impl.HwCommonActuatorImpl <em>Hw Common Actuator</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.papyrus.iotml.hardware.actuator.impl.HwCommonActuatorImpl
		 * @see org.eclipse.papyrus.iotml.hardware.actuator.impl.ActuatorPackageImpl#getHwCommonActuator()
		 * @generated
		 */
		EClass HW_COMMON_ACTUATOR = eINSTANCE.getHwCommonActuator();

		/**
		 * The meta object literal for the '<em><b>Energy Kind</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute HW_COMMON_ACTUATOR__ENERGY_KIND = eINSTANCE.getHwCommonActuator_EnergyKind();

		/**
		 * The meta object literal for the '<em><b>Movement Kind</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute HW_COMMON_ACTUATOR__MOVEMENT_KIND = eINSTANCE.getHwCommonActuator_MovementKind();

		/**
		 * The meta object literal for the '<em><b>Is Powered</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute HW_COMMON_ACTUATOR__IS_POWERED = eINSTANCE.getHwCommonActuator_IsPowered();

		/**
		 * The meta object literal for the '{@link org.eclipse.papyrus.iotml.hardware.actuator.EnergyKind <em>Energy Kind</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.papyrus.iotml.hardware.actuator.EnergyKind
		 * @see org.eclipse.papyrus.iotml.hardware.actuator.impl.ActuatorPackageImpl#getEnergyKind()
		 * @generated
		 */
		EEnum ENERGY_KIND = eINSTANCE.getEnergyKind();

		/**
		 * The meta object literal for the '{@link org.eclipse.papyrus.iotml.hardware.actuator.MovementKind <em>Movement Kind</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.papyrus.iotml.hardware.actuator.MovementKind
		 * @see org.eclipse.papyrus.iotml.hardware.actuator.impl.ActuatorPackageImpl#getMovementKind()
		 * @generated
		 */
		EEnum MOVEMENT_KIND = eINSTANCE.getMovementKind();

	}

} //ActuatorPackage
