/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aas.basyx.codegen;

import io.adminshell.aas.v3.model.AssetKind;
import io.adminshell.aas.v3.model.Identifier;
import io.adminshell.aas.v3.model.IdentifierType;
import io.adminshell.aas.v3.model.KeyElements;
import io.adminshell.aas.v3.model.KeyType;
import io.adminshell.aas.v3.model.ModelingKind;
import io.adminshell.aas.v3.model.impl.DefaultIdentifier;
import org.eclipse.aas.api.aas.AssetAdministrationShell;
import org.eclipse.aas.api.aas.parts.ConceptDictionary;
import org.eclipse.aas.api.asset.Asset;
import org.eclipse.aas.api.communications.AASEndpoint;
import org.eclipse.aas.api.communications.Endpoint;
import org.eclipse.aas.api.communications.ProtocolKind;
import org.eclipse.aas.api.reference.IReference;
import org.eclipse.aas.api.reference.Key;
import org.eclipse.aas.api.reference.Reference;
import org.eclipse.aas.api.submodel.SubModel;
import org.eclipse.aas.api.submodel.parts.Category;
import org.eclipse.aas.api.submodel.parts.ConceptDescription;
import org.eclipse.aas.api.submodel.submodelelement.Operation;
import org.eclipse.aas.api.submodel.submodelelement.SubModelElementCollection;
import org.eclipse.aas.api.submodel.submodelelement.dataelement.File;
import org.eclipse.aas.api.submodel.submodelelement.dataelement.IOperationVariable;
import org.eclipse.aas.api.submodel.submodelelement.dataelement.MultiLanguageProperty;
import org.eclipse.aas.api.submodel.submodelelement.dataelement.OperationVariable;
import org.eclipse.aas.api.submodel.submodelelement.dataelement.Property;
import org.eclipse.aas.api.submodel.submodelelement.dataelement.valuetypes.ValueType;
import org.eclipse.aas.basyx.codegen.generator.Project;

public class Test {
    public static void main(String[] args) {
        Test.test7();
    }

    public static void test1() {
        Endpoint assetEndpoint1 = new Endpoint("CalculatorServer", ProtocolKind.OPCUA, "opc.tcp://127.0.0.1:4840/");
        Endpoint assetEndpoint2 = new Endpoint("MinimalServer", ProtocolKind.OPCUA, "opc.tcp://127.0.0.1:4841/");
        SubModel documentation = new SubModel("Documentation");
        SubModel controlSubModel = new SubModel("Control");
        SubModel calculationSubModel = new SubModel("Calculation");
        DefaultIdentifier idDoc = new DefaultIdentifier();
        idDoc.setIdType(IdentifierType.IRI);
        idDoc.setIdentifier("https://www.dfki.de/ids/sm/8c47c091-195e-43c5-bfb2-7248b6a31bf1");
        documentation.setIdentification((Identifier)idDoc);
        DefaultIdentifier idControl = new DefaultIdentifier();
        idControl.setIdType(IdentifierType.IRI);
        idControl.setIdentifier("https://www.dfki.de/ids/sm/9a1bdba6-eb24-418a-a56e-f9d0ae621941");
        controlSubModel.setIdentification((Identifier)idControl);
        DefaultIdentifier idCalculation = new DefaultIdentifier();
        idCalculation.setIdType(IdentifierType.IRI);
        idCalculation.setIdentifier("https://www.dfki.de/ids/sm/79c44263-30ad-4296-a51e-2df3a4aed4ae");
        calculationSubModel.setIdentification((Identifier)idCalculation);
        documentation.setKind(ModelingKind.INSTANCE);
        controlSubModel.setKind(ModelingKind.INSTANCE);
        calculationSubModel.setKind(ModelingKind.INSTANCE);
        Key docKey = new Key(KeyElements.CONCEPT_DESCRIPTION, true, "0112/2///61360_4#AAF891#001", KeyType.IRDI);
        Reference docRef = new Reference(docKey);
        documentation.setSemanticIdentifier((IReference)docRef);
        Key controlKey = new Key(KeyElements.CONCEPT_DESCRIPTION, true, "0112/2///61360_4#AAF891#002", KeyType.IRDI);
        Reference controlRef = new Reference(controlKey);
        controlSubModel.setSemanticIdentifier((IReference)controlRef);
        Key calculationKey = new Key(KeyElements.CONCEPT_DESCRIPTION, true, "0112/2///61360_4#AAF891#002", KeyType.IRDI);
        Reference calculationRef = new Reference(calculationKey);
        calculationSubModel.setSemanticIdentifier((IReference)calculationRef);
        File exampleFile = new File();
        exampleFile.setIdShort("exampleFile");
        exampleFile.setKind(ModelingKind.INSTANCE);
        exampleFile.setMimeType("audio/aac");
        exampleFile.setValue("example.com/myexample");
        documentation.setFile(exampleFile);
        MultiLanguageProperty manufacName = new MultiLanguageProperty("ManufacturerName");
        manufacName.setKind(ModelingKind.INSTANCE);
        manufacName.setValue("en", "Smartfactory KL");
        documentation.setMultiLanguageProperty(manufacName);
        MultiLanguageProperty prodName = new MultiLanguageProperty("ManufacturerProductDesignation");
        prodName.setKind(ModelingKind.INSTANCE);
        prodName.setValue("de", "Rechner");
        prodName.setValue("en", "Calculator");
        prodName.setValue("fr", "Calculatrice");
        documentation.setMultiLanguageProperty(prodName);
        SubModelElementCollection controlSEC = new SubModelElementCollection("ControlParameters");
        controlSEC.setAllowDuplicates(false);
        controlSEC.setOrdered(true);
        controlSEC.setKind(ModelingKind.INSTANCE);
        SubModelElementCollection exampleSEC = new SubModelElementCollection("Example");
        exampleSEC.setAllowDuplicates(false);
        exampleSEC.setOrdered(true);
        exampleSEC.setKind(ModelingKind.INSTANCE);
        controlSEC.setSubModelElementCollection(exampleSEC);
        Property opVolt = new Property("OperatingVoltage");
        opVolt.setValueType(ValueType.Integer);
        opVolt.setDynamic(true);
        opVolt.setValue((Object)5);
        controlSEC.setProperty(opVolt);
        Property unit = new Property("Unit");
        unit.setValueType(ValueType.String);
        unit.setKind(ModelingKind.INSTANCE);
        controlSEC.setProperty(unit);
        Property opTemp = new Property("OperatingTemperature");
        opTemp.setValueType(ValueType.Integer);
        opTemp.setDynamic(true);
        opTemp.setEndpoint(assetEndpoint1);
        opTemp.setNameSpaceIndex(2);
        opTemp.setIdentifier(5L);
        controlSubModel.setProperty(opTemp);
        controlSubModel.setSubModelElementCollection(controlSEC);
        OperationVariable manuNameInp = new OperationVariable("ManufacturerName", ValueType.String);
        Operation changeManuName = new Operation("changeManufacturerName");
        changeManuName.setInputVariable((IOperationVariable)manuNameInp);
        controlSubModel.setOperation(changeManuName);
        OperationVariable statusOut = new OperationVariable("Status", ValueType.Boolean);
        Operation statusCheck = new Operation("checkStatus");
        statusCheck.setOutputVariable((IOperationVariable)statusOut);
        controlSubModel.setOperation(statusCheck);
        OperationVariable operand1 = new OperationVariable("Operand1", ValueType.Integer);
        OperationVariable operand2 = new OperationVariable("Operand2", ValueType.Integer);
        OperationVariable result = new OperationVariable("Result", ValueType.Integer);
        Operation errorReset = new Operation("errorReset");
        OperationVariable errorToReset = new OperationVariable("ErrorToReset", ValueType.Int64);
        OperationVariable done = new OperationVariable("Done", ValueType.Boolean);
        errorReset.setInputVariable((IOperationVariable)errorToReset);
        errorReset.setOutputVariable((IOperationVariable)done);
        calculationSubModel.setOperation(errorReset);
        Operation add = new Operation("Add");
        add.setKind(ModelingKind.INSTANCE);
        add.setInputVariables(new IOperationVariable[]{operand1, operand2});
        add.setOutputVariable((IOperationVariable)result);
        calculationSubModel.setOperation(add);
        Operation sub = new Operation("Subtract");
        sub.setKind(ModelingKind.INSTANCE);
        sub.setInputVariables(new IOperationVariable[]{operand1, operand2});
        sub.setOutputVariable((IOperationVariable)result);
        calculationSubModel.setOperation(sub);
        Operation multiply = new Operation("Multiply");
        multiply.setKind(ModelingKind.INSTANCE);
        multiply.setInputVariables(new IOperationVariable[]{operand1, operand2});
        multiply.setOutputVariable((IOperationVariable)result);
        calculationSubModel.setOperation(multiply);
        Operation divide = new Operation("Divide");
        divide.setKind(ModelingKind.INSTANCE);
        divide.setInputVariables(new IOperationVariable[]{operand1, operand2});
        divide.setOutputVariable((IOperationVariable)result);
        calculationSubModel.setOperation(divide);
        SubModelElementCollection calSEC = new SubModelElementCollection("CalculationCollection");
        calSEC.setAllowDuplicates(false);
        calSEC.setOrdered(true);
        calSEC.setDynamic(true);
        calSEC.setKind(ModelingKind.INSTANCE);
        calculationSubModel.setSubModelElementCollection(calSEC);
        SubModelElementCollection trialSEC = new SubModelElementCollection("DETrialCollection");
        trialSEC.setAllowDuplicates(false);
        trialSEC.setOrdered(true);
        trialSEC.setDynamic(true);
        trialSEC.setKind(ModelingKind.INSTANCE);
        calSEC.setSubModelElementCollection(trialSEC);
        SubModelElementCollection trialSEC1 = new SubModelElementCollection("DETrial1Collection");
        trialSEC1.setAllowDuplicates(false);
        trialSEC1.setOrdered(true);
        trialSEC1.setDynamic(true);
        trialSEC1.setKind(ModelingKind.INSTANCE);
        trialSEC.setSubModelElementCollection(trialSEC1);
        Asset calculatorAsset = new Asset("Calculator", AssetKind.INSTANCE);
        calculatorAsset.setEndpoints(new Endpoint[]{assetEndpoint1, assetEndpoint2});
        DefaultIdentifier idAsset = new DefaultIdentifier();
        idAsset.setIdType(IdentifierType.IRI);
        idAsset.setIdentifier("https://www.dfki.de/ids/assets/15c9c860-34f3-4fc3-a292-66fd0442c1f9");
        calculatorAsset.setIdentification((Identifier)idAsset);
        AASEndpoint aasEndpoint = new AASEndpoint("localhost", 2000);
        AssetAdministrationShell Papyrus4Manufacturing = new AssetAdministrationShell("Papyrus4Manufacturing", aasEndpoint);
        Papyrus4Manufacturing.setSubModels(new SubModel[]{documentation, controlSubModel, calculationSubModel});
        DefaultIdentifier idAAS = new DefaultIdentifier();
        idAAS.setIdType(IdentifierType.IRI);
        idAAS.setIdentifier("https://www.dfki.de/Papyrus4Manufacturingworkshop/ids/aas/23012dfa-0c1c-4408-bd06-dc3d9dcfcf4f");
        Papyrus4Manufacturing.setIdentification((Identifier)idAAS);
        Papyrus4Manufacturing.setAsset(calculatorAsset);
        Project testAAS = new Project(Papyrus4Manufacturing);
        testAAS.setProjectName("firstTrial");
        testAAS.setNamespaceFromProjectName();
        testAAS.setProjectFolder("/home/tapanta/Documents/tuleap-eclipse-workspace/Second_Trial/");
        testAAS.createProject();
    }

    public static void test2() {
        Endpoint assetEndpoint1 = new Endpoint("CalculatorServer", ProtocolKind.OPCUA, "opc.tcp://127.0.0.1:4840/");
        Endpoint assetEndpoint2 = new Endpoint("MinimalServer", ProtocolKind.OPCUA, "opc.tcp://127.0.0.1:4841/");
        SubModel documentation = new SubModel("Documentation");
        SubModel controlSubModel = new SubModel("Control");
        SubModel calculationSubModel = new SubModel("Calculation");
        DefaultIdentifier idDoc = new DefaultIdentifier();
        idDoc.setIdType(IdentifierType.IRI);
        idDoc.setIdentifier("https://www.dfki.de/ids/sm/8c47c091-195e-43c5-bfb2-7248b6a31bf1");
        documentation.setIdentification((Identifier)idDoc);
        DefaultIdentifier idControl = new DefaultIdentifier();
        idControl.setIdType(IdentifierType.IRI);
        idControl.setIdentifier("https://www.dfki.de/ids/sm/9a1bdba6-eb24-418a-a56e-f9d0ae621941");
        controlSubModel.setIdentification((Identifier)idControl);
        DefaultIdentifier idCalculation = new DefaultIdentifier();
        idCalculation.setIdType(IdentifierType.IRI);
        idCalculation.setIdentifier("https://www.dfki.de/ids/sm/79c44263-30ad-4296-a51e-2df3a4aed4ae");
        calculationSubModel.setIdentification((Identifier)idCalculation);
        documentation.setKind(ModelingKind.INSTANCE);
        controlSubModel.setKind(ModelingKind.INSTANCE);
        calculationSubModel.setKind(ModelingKind.INSTANCE);
        Key docKey = new Key(KeyElements.CONCEPT_DESCRIPTION, true, "0112/2///61360_4#AAF891#001", KeyType.IRDI);
        Reference docRef = new Reference(docKey);
        documentation.setSemanticIdentifier((IReference)docRef);
        Key controlKey = new Key(KeyElements.CONCEPT_DESCRIPTION, true, "0112/2///61360_4#AAF891#002", KeyType.IRDI);
        Reference controlRef = new Reference(controlKey);
        controlSubModel.setSemanticIdentifier((IReference)controlRef);
        Key calculationKey = new Key(KeyElements.CONCEPT_DESCRIPTION, true, "0112/2///61360_4#AAF891#002", KeyType.IRDI);
        Reference calculationRef = new Reference(calculationKey);
        calculationSubModel.setSemanticIdentifier((IReference)calculationRef);
        File exampleFile = new File();
        exampleFile.setIdShort("exampleFile");
        exampleFile.setKind(ModelingKind.INSTANCE);
        exampleFile.setMimeType("audio/aac");
        exampleFile.setValue("example.com/myexample");
        documentation.setFile(exampleFile);
        MultiLanguageProperty manufacName = new MultiLanguageProperty("ManufacturerName");
        manufacName.setKind(ModelingKind.INSTANCE);
        manufacName.setValue("en", "Smartfactory KL");
        Key manufacKey = new Key(KeyElements.GLOBAL_REFERENCE, false, "0112/2///61360_4#MYNAME891#005", KeyType.IRDI);
        Reference manufNameRef = new Reference(manufacKey);
        manufacName.setSemanticIdentifier((IReference)manufNameRef);
        documentation.setMultiLanguageProperty(manufacName);
        MultiLanguageProperty prodName = new MultiLanguageProperty("ManufacturerProductDesignation");
        prodName.setKind(ModelingKind.INSTANCE);
        prodName.setValue("de", "Rechner");
        prodName.setValue("en", "Calculator");
        prodName.setValue("fr", "Calculatrice");
        documentation.setMultiLanguageProperty(prodName);
        SubModelElementCollection addressSEC = new SubModelElementCollection("Address");
        documentation.setSubModelElementCollection(addressSEC);
        SubModelElementCollection phoneSEC = new SubModelElementCollection("Phone");
        addressSEC.setSubModelElementCollection(phoneSEC);
        MultiLanguageProperty telephoneNumer = new MultiLanguageProperty("TelephoneNumber");
        phoneSEC.setMultiLanguageProperty(telephoneNumer);
        Property typeTel = new Property("TypeOfTelephone");
        phoneSEC.setProperty(typeTel);
        SubModelElementCollection controlSEC = new SubModelElementCollection("ControlParameters");
        controlSEC.setAllowDuplicates(false);
        controlSEC.setOrdered(true);
        controlSEC.setKind(ModelingKind.INSTANCE);
        SubModelElementCollection exampleSEC = new SubModelElementCollection("Example");
        exampleSEC.setAllowDuplicates(false);
        exampleSEC.setOrdered(true);
        exampleSEC.setKind(ModelingKind.INSTANCE);
        controlSEC.setSubModelElementCollection(exampleSEC);
        System.out.println("Parent of Example: " + exampleSEC.getParentSEC().getIdShort());
        File anotherFile = new File();
        anotherFile.setIdShort("anotherFile");
        anotherFile.setKind(ModelingKind.INSTANCE);
        anotherFile.setMimeType("audio/aac");
        anotherFile.setValue("another.com/myanotherexample");
        anotherFile.setDynamic(true);
        exampleSEC.setFile(anotherFile);
        Property opVolt = new Property("OperatingVoltage");
        opVolt.setValueType(ValueType.Integer);
        opVolt.setDynamic(true);
        opVolt.setValue((Object)5);
        controlSEC.setProperty(opVolt);
        Property unit = new Property("Unit");
        unit.setValueType(ValueType.String);
        unit.setKind(ModelingKind.INSTANCE);
        unit.setValue("Volts");
        controlSEC.setProperty(unit);
        Property opTemp = new Property("OperatingTemperature");
        opTemp.setValueType(ValueType.Integer);
        opTemp.setDynamic(true);
        opTemp.setEndpoint(assetEndpoint1);
        opTemp.setNameSpaceIndex(2);
        opTemp.setIdentifier(5L);
        controlSubModel.setProperty(opTemp);
        controlSubModel.setSubModelElementCollection(controlSEC);
        OperationVariable manuNameInp = new OperationVariable("ManufacturerName", ValueType.String);
        Operation changeManuName = new Operation("changeManufacturerName");
        changeManuName.setInputVariable((IOperationVariable)manuNameInp);
        controlSubModel.setOperation(changeManuName);
        OperationVariable statusOut = new OperationVariable("Status", ValueType.Boolean);
        Operation statusCheck = new Operation("checkStatus");
        statusCheck.setOutputVariable((IOperationVariable)statusOut);
        controlSubModel.setOperation(statusCheck);
        OperationVariable operand1 = new OperationVariable("Operand1", ValueType.Integer);
        OperationVariable operand2 = new OperationVariable("Operand2", ValueType.Integer);
        OperationVariable result = new OperationVariable("Result", ValueType.Integer);
        Operation add = new Operation("Add");
        add.setKind(ModelingKind.INSTANCE);
        add.setInputVariables(new IOperationVariable[]{operand1, operand2});
        add.setOutputVariable((IOperationVariable)result);
        calculationSubModel.setOperation(add);
        Operation sub = new Operation("Subtract");
        sub.setKind(ModelingKind.INSTANCE);
        sub.setInputVariables(new IOperationVariable[]{operand1, operand2});
        sub.setOutputVariable((IOperationVariable)result);
        calculationSubModel.setOperation(sub);
        Operation multiply = new Operation("Multiply");
        multiply.setKind(ModelingKind.INSTANCE);
        multiply.setInputVariables(new IOperationVariable[]{operand1, operand2});
        multiply.setOutputVariable((IOperationVariable)result);
        calculationSubModel.setOperation(multiply);
        Operation divide = new Operation("Divide");
        divide.setKind(ModelingKind.INSTANCE);
        divide.setInputVariables(new IOperationVariable[]{operand1, operand2});
        divide.setOutputVariable((IOperationVariable)result);
        calculationSubModel.setOperation(divide);
        SubModelElementCollection calSEC = new SubModelElementCollection("CalculationCollection");
        calSEC.setAllowDuplicates(false);
        calSEC.setOrdered(true);
        calSEC.setDynamic(true);
        calSEC.setKind(ModelingKind.INSTANCE);
        calculationSubModel.setSubModelElementCollection(calSEC);
        SubModelElementCollection trialSEC = new SubModelElementCollection("DETrialCollection");
        trialSEC.setAllowDuplicates(false);
        trialSEC.setOrdered(true);
        trialSEC.setDynamic(true);
        trialSEC.setKind(ModelingKind.INSTANCE);
        calSEC.setSubModelElementCollection(trialSEC);
        SubModelElementCollection trialSEC1 = new SubModelElementCollection("DETrial1Collection");
        trialSEC1.setAllowDuplicates(false);
        trialSEC1.setOrdered(true);
        trialSEC1.setDynamic(true);
        trialSEC1.setKind(ModelingKind.INSTANCE);
        trialSEC.setSubModelElementCollection(trialSEC1);
        Asset calculatorAsset = new Asset("Calculator", AssetKind.INSTANCE);
        calculatorAsset.setEndpoints(new Endpoint[]{assetEndpoint1, assetEndpoint2});
        DefaultIdentifier idAsset = new DefaultIdentifier();
        idAsset.setIdType(IdentifierType.IRI);
        idAsset.setIdentifier("https://www.dfki.de/ids/assets/15c9c860-34f3-4fc3-a292-66fd0442c1f9");
        calculatorAsset.setIdentification((Identifier)idAsset);
        AASEndpoint aasEndpoint = new AASEndpoint("localhost", 2000);
        AssetAdministrationShell Papyrus4Manufacturing = new AssetAdministrationShell("Papyrus4Manufacturing", aasEndpoint);
        Papyrus4Manufacturing.setSubModels(new SubModel[]{documentation, controlSubModel, calculationSubModel});
        DefaultIdentifier idAAS = new DefaultIdentifier();
        idAAS.setIdType(IdentifierType.IRI);
        idAAS.setIdentifier("https://www.dfki.de/Papyrus4Manufacturingworkshop/ids/aas/23012dfa-0c1c-4408-bd06-dc3d9dcfcf4f");
        Papyrus4Manufacturing.setIdentification((Identifier)idAAS);
        Papyrus4Manufacturing.setAsset(calculatorAsset);
        Project testAAS = new Project(Papyrus4Manufacturing);
        testAAS.setProjectName("secondTrial");
        testAAS.setNamespaceFromProjectName();
        testAAS.setProjectFolder("/home/tapanta/Documents/tuleap-eclipse-workspace/Second_Trial/");
        testAAS.createProject();
    }

    public static void test3() {
        Endpoint assetEndpoint1 = new Endpoint("CalculatorServer", ProtocolKind.OPCUA, "opc.tcp://127.0.0.1:4840/");
        Endpoint assetEndpoint2 = new Endpoint("MinimalServer", ProtocolKind.OPCUA, "opc.tcp://127.0.0.1:4841/");
        ConceptDictionary conceptDict = new ConceptDictionary();
        DefaultIdentifier idDocumentation = new DefaultIdentifier();
        idDocumentation.setIdType(IdentifierType.IRI);
        idDocumentation.setIdentifier("https://www.dfki.de/ids/documentation/79c44263-30ad-4296-a51e-2df3a4aed4ae");
        ConceptDescription documentationConcept = new ConceptDescription("Documentation", (Identifier)idDocumentation);
        conceptDict.setConceptDescription(documentationConcept);
        DefaultIdentifier idAdd = new DefaultIdentifier();
        idAdd.setIdType(IdentifierType.IRI);
        idAdd.setIdentifier("https://www.dfki.de/ids/add/79c44263-30ad-4296-a51e-2df3a4tbc4ae");
        ConceptDescription addConcept = new ConceptDescription("Add", (Identifier)idAdd);
        addConcept.setCategory(Category.FUNCTION);
        conceptDict.setConceptDescription(addConcept);
        DefaultIdentifier idSub = new DefaultIdentifier();
        idSub.setIdType(IdentifierType.IRI);
        idSub.setIdentifier("https://www.dfki.de/ids/sub/79c44263-30ad-4296-a51e-2df3a4tbc4ae");
        ConceptDescription subtractConcept = new ConceptDescription("Subtract", (Identifier)idSub);
        subtractConcept.setCategory(Category.FUNCTION);
        conceptDict.setConceptDescription(subtractConcept);
        DefaultIdentifier idMul = new DefaultIdentifier();
        idMul.setIdType(IdentifierType.IRI);
        idMul.setIdentifier("https://www.dfki.de/ids/multiply/79c44263-30ad-4296-a51e-2df3a4tbc4ae");
        ConceptDescription multiplyConcept = new ConceptDescription("Multiply", (Identifier)idMul);
        multiplyConcept.setCategory(Category.FUNCTION);
        conceptDict.setConceptDescription(multiplyConcept);
        DefaultIdentifier idDivide = new DefaultIdentifier();
        idDivide.setIdType(IdentifierType.IRI);
        idDivide.setIdentifier("https://www.dfki.de/ids/divide/79c44263-30ad-4296-a51e-2df3a4tbc4ae");
        ConceptDescription divideConcept = new ConceptDescription("Divide", (Identifier)idDivide);
        divideConcept.setCategory(Category.FUNCTION);
        conceptDict.setConceptDescription(divideConcept);
        SubModel documentation = new SubModel("Documentation");
        SubModel controlSubModel = new SubModel("Control");
        SubModel calculationSubModel = new SubModel("Calculation");
        DefaultIdentifier idDoc = new DefaultIdentifier();
        idDoc.setIdType(IdentifierType.IRI);
        idDoc.setIdentifier("https://www.dfki.de/ids/sm/8c47c091-195e-43c5-bfb2-7248b6a31bf1");
        documentation.setIdentification((Identifier)idDoc);
        DefaultIdentifier idControl = new DefaultIdentifier();
        idControl.setIdType(IdentifierType.IRI);
        idControl.setIdentifier("https://www.dfki.de/ids/sm/9a1bdba6-eb24-418a-a56e-f9d0ae621941");
        controlSubModel.setIdentification((Identifier)idControl);
        DefaultIdentifier idCalculation = new DefaultIdentifier();
        idCalculation.setIdType(IdentifierType.IRI);
        idCalculation.setIdentifier("https://www.dfki.de/ids/sm/79c44263-30ad-4296-a51e-2df3a4aed4ae");
        calculationSubModel.setIdentification((Identifier)idCalculation);
        documentation.setKind(ModelingKind.INSTANCE);
        controlSubModel.setKind(ModelingKind.INSTANCE);
        calculationSubModel.setKind(ModelingKind.INSTANCE);
        Key docKey = new Key(KeyElements.CONCEPT_DESCRIPTION, true, "0112/2///61360_4#AAF891#001", KeyType.IRDI);
        Reference docRef = new Reference(docKey);
        documentation.setSemanticIdentifier((IReference)docRef);
        Key controlKey = new Key(KeyElements.CONCEPT_DESCRIPTION, true, "0112/2///61360_4#AAF891#002", KeyType.IRDI);
        Reference controlRef = new Reference(controlKey);
        controlSubModel.setSemanticIdentifier((IReference)controlRef);
        Key calculationKey = new Key(KeyElements.CONCEPT_DESCRIPTION, true, "0112/2///61360_4#AAF891#002", KeyType.IRDI);
        Reference calculationRef = new Reference(calculationKey);
        calculationSubModel.setSemanticIdentifier((IReference)calculationRef);
        File exampleFile = new File();
        exampleFile.setIdShort("exampleFile");
        exampleFile.setKind(ModelingKind.INSTANCE);
        exampleFile.setMimeType("audio/aac");
        exampleFile.setValue("example.com/myexample");
        documentation.setFile(exampleFile);
        MultiLanguageProperty manufacName = new MultiLanguageProperty("ManufacturerName");
        manufacName.setKind(ModelingKind.INSTANCE);
        manufacName.setValue("en", "Smartfactory KL");
        Key manufacKey = new Key(KeyElements.GLOBAL_REFERENCE, false, "0112/2///61360_4#MYNAME891#005", KeyType.IRDI);
        Reference manufNameRef = new Reference(manufacKey);
        manufacName.setSemanticIdentifier((IReference)manufNameRef);
        documentation.setMultiLanguageProperty(manufacName);
        MultiLanguageProperty prodName = new MultiLanguageProperty("ManufacturerProductDesignation");
        prodName.setKind(ModelingKind.INSTANCE);
        prodName.setValue("de", "Rechner");
        prodName.setValue("en", "Calculator");
        prodName.setValue("fr", "Calculatrice");
        documentation.setMultiLanguageProperty(prodName);
        SubModelElementCollection addressSEC = new SubModelElementCollection("Address");
        documentation.setSubModelElementCollection(addressSEC);
        SubModelElementCollection phoneSEC = new SubModelElementCollection("Phone");
        addressSEC.setSubModelElementCollection(phoneSEC);
        MultiLanguageProperty telephoneNumer = new MultiLanguageProperty("TelephoneNumber");
        phoneSEC.setMultiLanguageProperty(telephoneNumer);
        Property typeTel = new Property("TypeOfTelephone");
        phoneSEC.setProperty(typeTel);
        SubModelElementCollection controlSEC = new SubModelElementCollection("ControlParameters");
        controlSEC.setAllowDuplicates(false);
        controlSEC.setOrdered(true);
        controlSEC.setKind(ModelingKind.INSTANCE);
        SubModelElementCollection exampleSEC = new SubModelElementCollection("Example");
        exampleSEC.setAllowDuplicates(false);
        exampleSEC.setOrdered(true);
        exampleSEC.setKind(ModelingKind.INSTANCE);
        controlSEC.setSubModelElementCollection(exampleSEC);
        System.out.println("Parent of Example: " + exampleSEC.getParentSEC().getIdShort());
        File anotherFile = new File();
        anotherFile.setIdShort("anotherFile");
        anotherFile.setKind(ModelingKind.INSTANCE);
        anotherFile.setMimeType("audio/aac");
        anotherFile.setValue("another.com/myanotherexample");
        anotherFile.setDynamic(true);
        exampleSEC.setFile(anotherFile);
        Property opVolt = new Property("OperatingVoltage");
        opVolt.setValueType(ValueType.Integer);
        opVolt.setDynamic(true);
        opVolt.setValue((Object)5);
        controlSEC.setProperty(opVolt);
        Property unit = new Property("Unit");
        unit.setValueType(ValueType.String);
        unit.setKind(ModelingKind.INSTANCE);
        unit.setValue("Volts");
        controlSEC.setProperty(unit);
        Property opTemp = new Property("OperatingTemperature");
        opTemp.setValueType(ValueType.Integer);
        opTemp.setDynamic(true);
        opTemp.setEndpoint(assetEndpoint1);
        opTemp.setNameSpaceIndex(2);
        opTemp.setIdentifier(5L);
        controlSubModel.setProperty(opTemp);
        controlSubModel.setSubModelElementCollection(controlSEC);
        OperationVariable manuNameInp = new OperationVariable("ManufacturerName", ValueType.String);
        Operation changeManuName = new Operation("changeManufacturerName");
        changeManuName.setInputVariable((IOperationVariable)manuNameInp);
        controlSubModel.setOperation(changeManuName);
        OperationVariable statusOut = new OperationVariable("Status", ValueType.Boolean);
        Operation statusCheck = new Operation("checkStatus");
        statusCheck.setOutputVariable((IOperationVariable)statusOut);
        controlSubModel.setOperation(statusCheck);
        OperationVariable operand1 = new OperationVariable("Operand1", ValueType.Integer);
        OperationVariable operand2 = new OperationVariable("Operand2", ValueType.Integer);
        OperationVariable result = new OperationVariable("Result", ValueType.Integer);
        Operation add = new Operation("Add");
        add.setSemanticDescription(addConcept);
        add.setKind(ModelingKind.INSTANCE);
        add.setInputVariables(new IOperationVariable[]{operand1, operand2});
        add.setOutputVariable((IOperationVariable)result);
        calculationSubModel.setOperation(add);
        Operation sub = new Operation("Subtract");
        sub.setSemanticDescription(subtractConcept);
        sub.setKind(ModelingKind.INSTANCE);
        sub.setInputVariables(new IOperationVariable[]{operand1, operand2});
        sub.setOutputVariable((IOperationVariable)result);
        calculationSubModel.setOperation(sub);
        Operation multiply = new Operation("Multiply");
        multiply.setSemanticDescription(multiplyConcept);
        multiply.setKind(ModelingKind.INSTANCE);
        multiply.setInputVariables(new IOperationVariable[]{operand1, operand2});
        multiply.setOutputVariable((IOperationVariable)result);
        calculationSubModel.setOperation(multiply);
        Operation divide = new Operation("Divide");
        divide.setSemanticDescription(divideConcept);
        divide.setKind(ModelingKind.INSTANCE);
        divide.setInputVariables(new IOperationVariable[]{operand1, operand2});
        divide.setOutputVariable((IOperationVariable)result);
        calculationSubModel.setOperation(divide);
        SubModelElementCollection calSEC = new SubModelElementCollection("CalculationCollection");
        calSEC.setAllowDuplicates(false);
        calSEC.setOrdered(true);
        calSEC.setDynamic(true);
        calSEC.setKind(ModelingKind.INSTANCE);
        calculationSubModel.setSubModelElementCollection(calSEC);
        SubModelElementCollection trialSEC = new SubModelElementCollection("DETrialCollection");
        trialSEC.setAllowDuplicates(false);
        trialSEC.setOrdered(true);
        trialSEC.setDynamic(true);
        trialSEC.setKind(ModelingKind.INSTANCE);
        calSEC.setSubModelElementCollection(trialSEC);
        SubModelElementCollection trialSEC1 = new SubModelElementCollection("DETrial1Collection");
        trialSEC1.setAllowDuplicates(false);
        trialSEC1.setOrdered(true);
        trialSEC1.setDynamic(true);
        trialSEC1.setKind(ModelingKind.INSTANCE);
        trialSEC.setSubModelElementCollection(trialSEC1);
        Asset calculatorAsset = new Asset("Calculator", AssetKind.INSTANCE);
        calculatorAsset.setEndpoints(new Endpoint[]{assetEndpoint1, assetEndpoint2});
        DefaultIdentifier idAsset = new DefaultIdentifier();
        idAsset.setIdType(IdentifierType.IRI);
        idAsset.setIdentifier("https://www.dfki.de/ids/assets/15c9c860-34f3-4fc3-a292-66fd0442c1f9");
        calculatorAsset.setIdentification((Identifier)idAsset);
        AASEndpoint aasEndpoint = new AASEndpoint("localhost", 2000);
        AssetAdministrationShell Papyrus4Manufacturing = new AssetAdministrationShell("Papyrus4Manufacturing", aasEndpoint);
        Papyrus4Manufacturing.setSubModels(new SubModel[]{documentation, controlSubModel, calculationSubModel});
        Papyrus4Manufacturing.setConceptDictionary(conceptDict);
        DefaultIdentifier idAAS = new DefaultIdentifier();
        idAAS.setIdType(IdentifierType.IRI);
        idAAS.setIdentifier("https://www.dfki.de/Papyrus4Manufacturingworkshop/ids/aas/23012dfa-0c1c-4408-bd06-dc3d9dcfcf4f");
        Papyrus4Manufacturing.setIdentification((Identifier)idAAS);
        Papyrus4Manufacturing.setAsset(calculatorAsset);
        Project testAAS = new Project(Papyrus4Manufacturing);
        testAAS.setProjectName("firstTrial");
        testAAS.setNamespaceFromProjectName();
        testAAS.setProjectFolder("/home/tapanta/Documents/tuleap-eclipse-workspace/Third_Trial/");
        testAAS.createProject();
    }

    public static void test4() {
        Endpoint assetEndpoint1 = new Endpoint("CalculatorServer", ProtocolKind.OPCUA, "opc.tcp://127.0.0.1:4840/");
        Endpoint assetEndpoint2 = new Endpoint("MinimalServer", ProtocolKind.OPCUA, "opc.tcp://127.0.0.1:4841/");
        ConceptDictionary conceptDict = new ConceptDictionary();
        DefaultIdentifier idDocumentation = new DefaultIdentifier();
        idDocumentation.setIdType(IdentifierType.IRI);
        idDocumentation.setIdentifier("https://www.dfki.de/ids/documentation/79c44263-30ad-4296-a51e-2df3a4aed4ae");
        ConceptDescription documentationConcept = new ConceptDescription("Documentation", (Identifier)idDocumentation);
        conceptDict.setConceptDescription(documentationConcept);
        DefaultIdentifier idAdd = new DefaultIdentifier();
        idAdd.setIdType(IdentifierType.IRI);
        idAdd.setIdentifier("https://www.dfki.de/ids/add/79c44263-30ad-4296-a51e-2df3a4tbc4ae");
        ConceptDescription addConcept = new ConceptDescription("Add", (Identifier)idAdd);
        addConcept.setCategory(Category.FUNCTION);
        conceptDict.setConceptDescription(addConcept);
        DefaultIdentifier idSub = new DefaultIdentifier();
        idSub.setIdType(IdentifierType.IRI);
        idSub.setIdentifier("https://www.dfki.de/ids/sub/79c44263-30ad-4296-a51e-2df3a4tbc4ae");
        ConceptDescription subtractConcept = new ConceptDescription("Subtract", (Identifier)idSub);
        subtractConcept.setCategory(Category.FUNCTION);
        conceptDict.setConceptDescription(subtractConcept);
        DefaultIdentifier idMul = new DefaultIdentifier();
        idMul.setIdType(IdentifierType.IRI);
        idMul.setIdentifier("https://www.dfki.de/ids/multiply/79c44263-30ad-4296-a51e-2df3a4tbc4ae");
        ConceptDescription multiplyConcept = new ConceptDescription("Multiply", (Identifier)idMul);
        multiplyConcept.setCategory(Category.FUNCTION);
        conceptDict.setConceptDescription(multiplyConcept);
        DefaultIdentifier idDivide = new DefaultIdentifier();
        idDivide.setIdType(IdentifierType.IRI);
        idDivide.setIdentifier("https://www.dfki.de/ids/divide/79c44263-30ad-4296-a51e-2df3a4tbc4ae");
        ConceptDescription divideConcept = new ConceptDescription("Divide", (Identifier)idDivide);
        divideConcept.setCategory(Category.FUNCTION);
        conceptDict.setConceptDescription(divideConcept);
        DefaultIdentifier idTrial = new DefaultIdentifier();
        idTrial.setIdType(IdentifierType.IRDI);
        idTrial.setIdentifier("565#//256641//45//pa8");
        ConceptDescription trialConcept = new ConceptDescription("Trial", (Identifier)idTrial);
        Key trialKey = new Key(KeyElements.PROPERTY, true, "0112/2///61360_4#AAF891#001", KeyType.IRDI);
        Reference trialRef = new Reference(trialKey);
        trialConcept.setIsCaseOf((IReference)trialRef);
        conceptDict.setConceptDescription(trialConcept);
        SubModel documentation = new SubModel("Documentation");
        SubModel controlSubModel = new SubModel("Control");
        SubModel calculationSubModel = new SubModel("Calculation");
        DefaultIdentifier idDoc = new DefaultIdentifier();
        idDoc.setIdType(IdentifierType.IRI);
        idDoc.setIdentifier("https://www.dfki.de/ids/sm/8c47c091-195e-43c5-bfb2-7248b6a31bf1");
        documentation.setIdentification((Identifier)idDoc);
        DefaultIdentifier idControl = new DefaultIdentifier();
        idControl.setIdType(IdentifierType.IRI);
        idControl.setIdentifier("https://www.dfki.de/ids/sm/9a1bdba6-eb24-418a-a56e-f9d0ae621941");
        controlSubModel.setIdentification((Identifier)idControl);
        DefaultIdentifier idCalculation = new DefaultIdentifier();
        idCalculation.setIdType(IdentifierType.IRI);
        idCalculation.setIdentifier("https://www.dfki.de/ids/sm/79c44263-30ad-4296-a51e-2df3a4aed4ae");
        calculationSubModel.setIdentification((Identifier)idCalculation);
        documentation.setKind(ModelingKind.INSTANCE);
        controlSubModel.setKind(ModelingKind.INSTANCE);
        calculationSubModel.setKind(ModelingKind.INSTANCE);
        Key docKey = new Key(KeyElements.CONCEPT_DESCRIPTION, true, "0112/2///61360_4#AAF891#001", KeyType.IRDI);
        Reference docRef = new Reference(docKey);
        documentation.setSemanticIdentifier((IReference)docRef);
        Key controlKey = new Key(KeyElements.CONCEPT_DESCRIPTION, true, "0112/2///61360_4#AAF891#002", KeyType.IRDI);
        Reference controlRef = new Reference(controlKey);
        controlSubModel.setSemanticIdentifier((IReference)controlRef);
        Key calculationKey = new Key(KeyElements.CONCEPT_DESCRIPTION, true, "0112/2///61360_4#AAF891#002", KeyType.IRDI);
        Reference calculationRef = new Reference(calculationKey);
        calculationSubModel.setSemanticIdentifier((IReference)calculationRef);
        File exampleFile = new File();
        exampleFile.setIdShort("exampleFile");
        exampleFile.setKind(ModelingKind.INSTANCE);
        exampleFile.setMimeType("audio/aac");
        exampleFile.setValue("example.com/myexample");
        documentation.setFile(exampleFile);
        MultiLanguageProperty manufacName = new MultiLanguageProperty("ManufacturerName");
        manufacName.setKind(ModelingKind.INSTANCE);
        manufacName.setValue("en", "Smartfactory KL");
        Key manufacKey = new Key(KeyElements.GLOBAL_REFERENCE, false, "0112/2///61360_4#MYNAME891#005", KeyType.IRDI);
        Reference manufNameRef = new Reference(manufacKey);
        manufacName.setSemanticIdentifier((IReference)manufNameRef);
        documentation.setMultiLanguageProperty(manufacName);
        MultiLanguageProperty prodName = new MultiLanguageProperty("ManufacturerProductDesignation");
        prodName.setKind(ModelingKind.INSTANCE);
        prodName.setValue("de", "Rechner");
        prodName.setValue("en", "Calculator");
        prodName.setValue("fr", "Calculatrice");
        documentation.setMultiLanguageProperty(prodName);
        SubModelElementCollection addressSEC = new SubModelElementCollection("Address");
        documentation.setSubModelElementCollection(addressSEC);
        SubModelElementCollection phoneSEC = new SubModelElementCollection("Phone");
        addressSEC.setSubModelElementCollection(phoneSEC);
        MultiLanguageProperty telephoneNumer = new MultiLanguageProperty("TelephoneNumber");
        phoneSEC.setMultiLanguageProperty(telephoneNumer);
        Property typeTel = new Property("TypeOfTelephone");
        phoneSEC.setProperty(typeTel);
        SubModelElementCollection controlSEC = new SubModelElementCollection("ControlParameters");
        controlSEC.setAllowDuplicates(false);
        controlSEC.setOrdered(true);
        controlSEC.setKind(ModelingKind.INSTANCE);
        SubModelElementCollection exampleSEC = new SubModelElementCollection("Example");
        exampleSEC.setAllowDuplicates(false);
        exampleSEC.setOrdered(true);
        exampleSEC.setKind(ModelingKind.INSTANCE);
        controlSEC.setSubModelElementCollection(exampleSEC);
        System.out.println("Parent of Example: " + exampleSEC.getParentSEC().getIdShort());
        File anotherFile = new File();
        anotherFile.setIdShort("anotherFile");
        anotherFile.setKind(ModelingKind.INSTANCE);
        anotherFile.setMimeType("audio/aac");
        anotherFile.setValue("another.com/myanotherexample");
        anotherFile.setDynamic(true);
        exampleSEC.setFile(anotherFile);
        Property opVolt = new Property("OperatingVoltage");
        opVolt.setValueType(ValueType.Integer);
        opVolt.setDynamic(true);
        opVolt.setValue((Object)5);
        controlSEC.setProperty(opVolt);
        Property unit = new Property("Unit");
        unit.setValueType(ValueType.String);
        unit.setKind(ModelingKind.INSTANCE);
        unit.setValue("Volts");
        controlSEC.setProperty(unit);
        Property opTemp = new Property("OperatingTemperature");
        opTemp.setValueType(ValueType.Integer);
        opTemp.setDynamic(true);
        opTemp.setEndpoint(assetEndpoint1);
        opTemp.setNameSpaceIndex(2);
        opTemp.setIdentifier(5L);
        controlSubModel.setProperty(opTemp);
        controlSubModel.setSubModelElementCollection(controlSEC);
        OperationVariable manuNameInp = new OperationVariable("ManufacturerName", ValueType.String);
        Operation changeManuName = new Operation("changeManufacturerName");
        changeManuName.setInputVariable((IOperationVariable)manuNameInp);
        controlSubModel.setOperation(changeManuName);
        OperationVariable statusOut = new OperationVariable("Status", ValueType.Boolean);
        Operation statusCheck = new Operation("checkStatus");
        statusCheck.setOutputVariable((IOperationVariable)statusOut);
        controlSubModel.setOperation(statusCheck);
        OperationVariable operand1 = new OperationVariable("Operand1", ValueType.Integer);
        OperationVariable operand2 = new OperationVariable("Operand2", ValueType.Integer);
        OperationVariable result = new OperationVariable("Result", ValueType.Integer);
        Operation add = new Operation("Add");
        add.setSemanticDescription(addConcept);
        add.setKind(ModelingKind.INSTANCE);
        add.setInputVariables(new IOperationVariable[]{operand1, operand2});
        add.setOutputVariable((IOperationVariable)result);
        calculationSubModel.setOperation(add);
        Operation sub = new Operation("Subtract");
        sub.setSemanticDescription(subtractConcept);
        sub.setKind(ModelingKind.INSTANCE);
        sub.setInputVariables(new IOperationVariable[]{operand1, operand2});
        sub.setOutputVariable((IOperationVariable)result);
        calculationSubModel.setOperation(sub);
        Operation multiply = new Operation("Multiply");
        multiply.setSemanticDescription(multiplyConcept);
        multiply.setKind(ModelingKind.INSTANCE);
        multiply.setInputVariables(new IOperationVariable[]{operand1, operand2});
        multiply.setOutputVariable((IOperationVariable)result);
        calculationSubModel.setOperation(multiply);
        Operation divide = new Operation("Divide");
        divide.setSemanticDescription(divideConcept);
        divide.setKind(ModelingKind.INSTANCE);
        divide.setInputVariables(new IOperationVariable[]{operand1, operand2});
        divide.setOutputVariable((IOperationVariable)result);
        calculationSubModel.setOperation(divide);
        SubModelElementCollection calSEC = new SubModelElementCollection("CalculationCollection");
        calSEC.setAllowDuplicates(false);
        calSEC.setOrdered(true);
        calSEC.setDynamic(true);
        calSEC.setKind(ModelingKind.INSTANCE);
        calculationSubModel.setSubModelElementCollection(calSEC);
        SubModelElementCollection trialSEC = new SubModelElementCollection("DETrialCollection");
        trialSEC.setAllowDuplicates(false);
        trialSEC.setOrdered(true);
        trialSEC.setDynamic(true);
        trialSEC.setKind(ModelingKind.INSTANCE);
        calSEC.setSubModelElementCollection(trialSEC);
        SubModelElementCollection trialSEC1 = new SubModelElementCollection("DETrial1Collection");
        trialSEC1.setAllowDuplicates(false);
        trialSEC1.setOrdered(true);
        trialSEC1.setDynamic(true);
        trialSEC1.setKind(ModelingKind.INSTANCE);
        trialSEC.setSubModelElementCollection(trialSEC1);
        Asset calculatorAsset = new Asset("Calculator", AssetKind.INSTANCE);
        calculatorAsset.setEndpoints(new Endpoint[]{assetEndpoint1, assetEndpoint2});
        DefaultIdentifier idAsset = new DefaultIdentifier();
        idAsset.setIdType(IdentifierType.IRI);
        idAsset.setIdentifier("https://www.dfki.de/ids/assets/15c9c860-34f3-4fc3-a292-66fd0442c1f9");
        calculatorAsset.setIdentification((Identifier)idAsset);
        AASEndpoint aasEndpoint = new AASEndpoint("localhost", 2000);
        AssetAdministrationShell Papyrus4Manufacturing = new AssetAdministrationShell("Papyrus4Manufacturing", aasEndpoint);
        Papyrus4Manufacturing.setSubModels(new SubModel[]{documentation, controlSubModel, calculationSubModel});
        Papyrus4Manufacturing.setConceptDictionary(conceptDict);
        DefaultIdentifier idAAS = new DefaultIdentifier();
        idAAS.setIdType(IdentifierType.IRI);
        idAAS.setIdentifier("https://www.dfki.de/Papyrus4Manufacturingworkshop/ids/aas/23012dfa-0c1c-4408-bd06-dc3d9dcfcf4f");
        Papyrus4Manufacturing.setIdentification((Identifier)idAAS);
        Papyrus4Manufacturing.setAsset(calculatorAsset);
        Project testAAS = new Project(Papyrus4Manufacturing);
        testAAS.setProjectName("firstTrial");
        testAAS.setNamespaceFromProjectName();
        testAAS.setProjectFolder("/home/tapanta/Documents/tuleap-eclipse-workspace/Fourth_Trial/");
        testAAS.createProject();
    }

    public static void test5() {
        Endpoint assetEndpoint1 = new Endpoint("CalculatorServer", ProtocolKind.OPCUA, "opc.tcp://127.0.0.1:4840/");
        Endpoint assetEndpoint2 = new Endpoint("MinimalServer", ProtocolKind.OPCUA, "opc.tcp://127.0.0.1:4841/");
        ConceptDictionary conceptDict = new ConceptDictionary();
        DefaultIdentifier idDocumentation = new DefaultIdentifier();
        idDocumentation.setIdType(IdentifierType.IRI);
        idDocumentation.setIdentifier("https://www.dfki.de/ids/documentation/79c44263-30ad-4296-a51e-2df3a4aed4ae");
        ConceptDescription documentationConcept = new ConceptDescription("Documentation", (Identifier)idDocumentation);
        conceptDict.setConceptDescription(documentationConcept);
        DefaultIdentifier idAdd = new DefaultIdentifier();
        idAdd.setIdType(IdentifierType.IRI);
        idAdd.setIdentifier("https://www.dfki.de/ids/add/79c44263-30ad-4296-a51e-2df3a4tbc4ae");
        ConceptDescription addConcept = new ConceptDescription("Add", (Identifier)idAdd);
        addConcept.setCategory(Category.FUNCTION);
        conceptDict.setConceptDescription(addConcept);
        DefaultIdentifier idSub = new DefaultIdentifier();
        idSub.setIdType(IdentifierType.IRI);
        idSub.setIdentifier("https://www.dfki.de/ids/sub/79c44263-30ad-4296-a51e-2df3a4tbc4ae");
        ConceptDescription subtractConcept = new ConceptDescription("Subtract", (Identifier)idSub);
        subtractConcept.setCategory(Category.FUNCTION);
        conceptDict.setConceptDescription(subtractConcept);
        DefaultIdentifier idMul = new DefaultIdentifier();
        idMul.setIdType(IdentifierType.IRI);
        idMul.setIdentifier("https://www.dfki.de/ids/multiply/79c44263-30ad-4296-a51e-2df3a4tbc4ae");
        ConceptDescription multiplyConcept = new ConceptDescription("Multiply", (Identifier)idMul);
        multiplyConcept.setCategory(Category.FUNCTION);
        conceptDict.setConceptDescription(multiplyConcept);
        DefaultIdentifier idDivide = new DefaultIdentifier();
        idDivide.setIdType(IdentifierType.IRI);
        idDivide.setIdentifier("https://www.dfki.de/ids/divide/79c44263-30ad-4296-a51e-2df3a4tbc4ae");
        ConceptDescription divideConcept = new ConceptDescription("Divide", (Identifier)idDivide);
        divideConcept.setCategory(Category.FUNCTION);
        conceptDict.setConceptDescription(divideConcept);
        DefaultIdentifier idTrial = new DefaultIdentifier();
        idTrial.setIdType(IdentifierType.IRDI);
        idTrial.setIdentifier("565#//256641//45//pa8");
        ConceptDescription trialConcept = new ConceptDescription("Trial", (Identifier)idTrial);
        Key trialKey = new Key(KeyElements.PROPERTY, true, "0112/2///61360_4#AAF891#001", KeyType.IRDI);
        Reference trialRef = new Reference(trialKey);
        trialConcept.setIsCaseOf((IReference)trialRef);
        conceptDict.setConceptDescription(trialConcept);
        SubModel documentation = new SubModel("Documentation");
        SubModel controlSubModel = new SubModel("Control");
        SubModel calculationSubModel = new SubModel("Calculation");
        DefaultIdentifier idDoc = new DefaultIdentifier();
        idDoc.setIdType(IdentifierType.IRDI);
        idDoc.setIdentifier("0112/2///61360_4#AAF891#002");
        documentation.setIdentification((Identifier)idDoc);
        DefaultIdentifier idControl = new DefaultIdentifier();
        idControl.setIdType(IdentifierType.IRDI);
        idControl.setIdentifier("0112/2///61360_4#AAF891#002");
        controlSubModel.setIdentification((Identifier)idControl);
        DefaultIdentifier idCalculation = new DefaultIdentifier();
        idCalculation.setIdType(IdentifierType.IRDI);
        idCalculation.setIdentifier("0112/2///61360_4#AAF891#002");
        calculationSubModel.setIdentification((Identifier)idCalculation);
        documentation.setKind(ModelingKind.TEMPLATE);
        controlSubModel.setKind(ModelingKind.TEMPLATE);
        calculationSubModel.setKind(ModelingKind.TEMPLATE);
        Key docKey = new Key(KeyElements.CONCEPT_DESCRIPTION, true, "0112/2///61360_4#AAF891#001", KeyType.IRDI);
        Reference docRef = new Reference(docKey);
        documentation.setSemanticIdentifier((IReference)docRef);
        Key controlKey = new Key(KeyElements.CONCEPT_DESCRIPTION, true, "0112/2///61360_4#AAF891#002", KeyType.IRDI);
        Reference controlRef = new Reference(controlKey);
        controlSubModel.setSemanticIdentifier((IReference)controlRef);
        Key calculationKey = new Key(KeyElements.CONCEPT_DESCRIPTION, true, "0112/2///61360_4#AAF891#002", KeyType.IRDI);
        Reference calculationRef = new Reference(calculationKey);
        calculationSubModel.setSemanticIdentifier((IReference)calculationRef);
        File exampleFile = new File();
        exampleFile.setIdShort("exampleFile");
        exampleFile.setKind(ModelingKind.INSTANCE);
        exampleFile.setMimeType("audio/aac");
        exampleFile.setValue("example.com/myexample");
        documentation.setFile(exampleFile);
        MultiLanguageProperty manufacName = new MultiLanguageProperty("ManufacturerName");
        manufacName.setKind(ModelingKind.INSTANCE);
        manufacName.setValue("en", "Smartfactory KL");
        Key manufacKey = new Key(KeyElements.GLOBAL_REFERENCE, false, "0112/2///61360_4#MYNAME891#005", KeyType.IRDI);
        Reference manufNameRef = new Reference(manufacKey);
        manufacName.setSemanticIdentifier((IReference)manufNameRef);
        documentation.setMultiLanguageProperty(manufacName);
        MultiLanguageProperty prodName = new MultiLanguageProperty("ManufacturerProductDesignation");
        prodName.setKind(ModelingKind.INSTANCE);
        prodName.setValue("de", "Rechner");
        prodName.setValue("en", "Calculator");
        prodName.setValue("fr", "Calculatrice");
        documentation.setMultiLanguageProperty(prodName);
        SubModelElementCollection addressSEC = new SubModelElementCollection("Address");
        documentation.setSubModelElementCollection(addressSEC);
        SubModelElementCollection phoneSEC = new SubModelElementCollection("Phone");
        addressSEC.setSubModelElementCollection(phoneSEC);
        MultiLanguageProperty telephoneNumer = new MultiLanguageProperty("TelephoneNumber");
        phoneSEC.setMultiLanguageProperty(telephoneNumer);
        Property typeTel = new Property("TypeOfTelephone");
        phoneSEC.setProperty(typeTel);
        SubModelElementCollection controlSEC = new SubModelElementCollection("ControlParameters");
        controlSEC.setAllowDuplicates(false);
        controlSEC.setOrdered(true);
        controlSEC.setKind(ModelingKind.INSTANCE);
        SubModelElementCollection exampleSEC = new SubModelElementCollection("Example");
        exampleSEC.setAllowDuplicates(false);
        exampleSEC.setOrdered(true);
        exampleSEC.setKind(ModelingKind.INSTANCE);
        controlSEC.setSubModelElementCollection(exampleSEC);
        System.out.println("Parent of Example: " + exampleSEC.getParentSEC().getIdShort());
        File anotherFile = new File();
        anotherFile.setIdShort("anotherFile");
        anotherFile.setKind(ModelingKind.INSTANCE);
        anotherFile.setMimeType("audio/aac");
        anotherFile.setValue("another.com/myanotherexample");
        anotherFile.setDynamic(true);
        exampleSEC.setFile(anotherFile);
        Property opVolt = new Property("OperatingVoltage");
        opVolt.setValueType(ValueType.Integer);
        opVolt.setDynamic(true);
        opVolt.setValue((Object)5);
        controlSEC.setProperty(opVolt);
        Property unit = new Property("Unit");
        unit.setValueType(ValueType.String);
        unit.setKind(ModelingKind.INSTANCE);
        unit.setValue("Volts");
        controlSEC.setProperty(unit);
        Property opTemp = new Property("OperatingTemperature");
        opTemp.setValueType(ValueType.Integer);
        opTemp.setDynamic(true);
        opTemp.setEndpoint(assetEndpoint1);
        opTemp.setNameSpaceIndex(2);
        opTemp.setIdentifier(5L);
        controlSubModel.setProperty(opTemp);
        controlSubModel.setSubModelElementCollection(controlSEC);
        OperationVariable manuNameInp = new OperationVariable("ManufacturerName", ValueType.String);
        Operation changeManuName = new Operation("changeManufacturerName");
        changeManuName.setInputVariable((IOperationVariable)manuNameInp);
        controlSubModel.setOperation(changeManuName);
        OperationVariable statusOut = new OperationVariable("Status", ValueType.Boolean);
        Operation statusCheck = new Operation("checkStatus");
        statusCheck.setOutputVariable((IOperationVariable)statusOut);
        controlSubModel.setOperation(statusCheck);
        OperationVariable operand1 = new OperationVariable("Operand1", ValueType.Integer);
        OperationVariable operand2 = new OperationVariable("Operand2", ValueType.Integer);
        OperationVariable result = new OperationVariable("Result", ValueType.Integer);
        Operation add = new Operation("Add");
        add.setSemanticDescription(addConcept);
        add.setKind(ModelingKind.INSTANCE);
        add.setInputVariables(new IOperationVariable[]{operand1, operand2});
        add.setOutputVariable((IOperationVariable)result);
        calculationSubModel.setOperation(add);
        Operation sub = new Operation("Subtract");
        sub.setSemanticDescription(subtractConcept);
        sub.setKind(ModelingKind.INSTANCE);
        sub.setInputVariables(new IOperationVariable[]{operand1, operand2});
        sub.setOutputVariable((IOperationVariable)result);
        calculationSubModel.setOperation(sub);
        Operation multiply = new Operation("Multiply");
        multiply.setSemanticDescription(multiplyConcept);
        multiply.setKind(ModelingKind.INSTANCE);
        multiply.setInputVariables(new IOperationVariable[]{operand1, operand2});
        multiply.setOutputVariable((IOperationVariable)result);
        calculationSubModel.setOperation(multiply);
        Operation divide = new Operation("Divide");
        divide.setSemanticDescription(divideConcept);
        divide.setKind(ModelingKind.INSTANCE);
        divide.setInputVariables(new IOperationVariable[]{operand1, operand2});
        divide.setOutputVariable((IOperationVariable)result);
        calculationSubModel.setOperation(divide);
        SubModelElementCollection calSEC = new SubModelElementCollection("CalculationCollection");
        calSEC.setAllowDuplicates(false);
        calSEC.setOrdered(true);
        calSEC.setDynamic(true);
        calSEC.setKind(ModelingKind.INSTANCE);
        calculationSubModel.setSubModelElementCollection(calSEC);
        SubModelElementCollection trialSEC = new SubModelElementCollection("DETrialCollection");
        trialSEC.setAllowDuplicates(false);
        trialSEC.setOrdered(true);
        trialSEC.setDynamic(true);
        trialSEC.setKind(ModelingKind.INSTANCE);
        calSEC.setSubModelElementCollection(trialSEC);
        SubModelElementCollection trialSEC1 = new SubModelElementCollection("DETrial1Collection");
        trialSEC1.setAllowDuplicates(false);
        trialSEC1.setOrdered(true);
        trialSEC1.setDynamic(true);
        trialSEC1.setKind(ModelingKind.INSTANCE);
        trialSEC.setSubModelElementCollection(trialSEC1);
        Asset calculatorAsset = new Asset("Calculator", AssetKind.INSTANCE);
        calculatorAsset.setEndpoints(new Endpoint[]{assetEndpoint1, assetEndpoint2});
        DefaultIdentifier idAsset = new DefaultIdentifier();
        idAsset.setIdType(IdentifierType.IRI);
        idAsset.setIdentifier("https://www.dfki.de/ids/assets/15c9c860-34f3-4fc3-a292-66fd0442c1f9");
        calculatorAsset.setIdentification((Identifier)idAsset);
        AASEndpoint aasEndpoint = new AASEndpoint("localhost", 2000);
        AssetAdministrationShell Papyrus4Manufacturing = new AssetAdministrationShell("Papyrus4Manufacturing", aasEndpoint);
        Papyrus4Manufacturing.setSubModels(new SubModel[]{documentation, controlSubModel, calculationSubModel});
        Papyrus4Manufacturing.setConceptDictionary(conceptDict);
        DefaultIdentifier idAAS = new DefaultIdentifier();
        idAAS.setIdType(IdentifierType.IRI);
        idAAS.setIdentifier("https://www.dfki.de/Papyrus4Manufacturingworkshop/ids/aas/23012dfa-0c1c-4408-bd06-dc3d9dcfcf4f");
        Papyrus4Manufacturing.setIdentification((Identifier)idAAS);
        Papyrus4Manufacturing.setAsset(calculatorAsset);
        Project testAAS = new Project(Papyrus4Manufacturing);
        testAAS.setProjectName("firstTrial");
        testAAS.setNamespaceFromProjectName();
        testAAS.setProjectFolder("/home/tapanta/Documents/tuleap-eclipse-workspace/Fifth_Trial/");
        testAAS.createProject();
    }

    public static void test6() {
        Endpoint assetEndpoint1 = new Endpoint("CalculatorServer", ProtocolKind.OPCUA, "opc.tcp://127.0.0.1:4840/");
        Endpoint assetEndpoint2 = new Endpoint("MinimalServer", ProtocolKind.OPCUA, "opc.tcp://127.0.0.1:4841/");
        ConceptDictionary conceptDict = new ConceptDictionary();
        DefaultIdentifier idDocumentation = new DefaultIdentifier();
        idDocumentation.setIdType(IdentifierType.IRI);
        idDocumentation.setIdentifier("https://www.dfki.de/ids/documentation/79c44263-30ad-4296-a51e-2df3a4aed4ae");
        ConceptDescription documentationConcept = new ConceptDescription("Documentation", (Identifier)idDocumentation);
        conceptDict.setConceptDescription(documentationConcept);
        DefaultIdentifier idAdd = new DefaultIdentifier();
        idAdd.setIdType(IdentifierType.IRI);
        idAdd.setIdentifier("https://www.dfki.de/ids/add/79c44263-30ad-4296-a51e-2df3a4tbc4ae");
        ConceptDescription addConcept = new ConceptDescription("Add", (Identifier)idAdd);
        addConcept.setCategory(Category.FUNCTION);
        conceptDict.setConceptDescription(addConcept);
        DefaultIdentifier idSub = new DefaultIdentifier();
        idSub.setIdType(IdentifierType.IRI);
        idSub.setIdentifier("https://www.dfki.de/ids/sub/79c44263-30ad-4296-a51e-2df3a4tbc4ae");
        ConceptDescription subtractConcept = new ConceptDescription("Subtract", (Identifier)idSub);
        subtractConcept.setCategory(Category.FUNCTION);
        conceptDict.setConceptDescription(subtractConcept);
        DefaultIdentifier idMul = new DefaultIdentifier();
        idMul.setIdType(IdentifierType.IRI);
        idMul.setIdentifier("https://www.dfki.de/ids/multiply/79c44263-30ad-4296-a51e-2df3a4tbc4ae");
        ConceptDescription multiplyConcept = new ConceptDescription("Multiply", (Identifier)idMul);
        multiplyConcept.setCategory(Category.FUNCTION);
        conceptDict.setConceptDescription(multiplyConcept);
        DefaultIdentifier idDivide = new DefaultIdentifier();
        idDivide.setIdType(IdentifierType.IRI);
        idDivide.setIdentifier("https://www.dfki.de/ids/divide/79c44263-30ad-4296-a51e-2df3a4tbc4ae");
        ConceptDescription divideConcept = new ConceptDescription("Divide", (Identifier)idDivide);
        divideConcept.setCategory(Category.FUNCTION);
        conceptDict.setConceptDescription(divideConcept);
        DefaultIdentifier idTrial = new DefaultIdentifier();
        idTrial.setIdType(IdentifierType.IRDI);
        idTrial.setIdentifier("565#//256641//45//pa8");
        ConceptDescription trialConcept = new ConceptDescription("Trial", (Identifier)idTrial);
        Key trialKey = new Key(KeyElements.PROPERTY, true, "0112/2///61360_4#AAF891#001", KeyType.IRDI);
        Reference trialRef = new Reference(trialKey);
        trialConcept.setIsCaseOf((IReference)trialRef);
        conceptDict.setConceptDescription(trialConcept);
        SubModel documentation = new SubModel("Documentation");
        SubModel controlSubModel = new SubModel("Control");
        SubModel calculationSubModel = new SubModel("Calculation");
        DefaultIdentifier idDoc = new DefaultIdentifier();
        idDoc.setIdType(IdentifierType.IRDI);
        idDoc.setIdentifier("0112/2///61360_4#AAF891#002");
        documentation.setIdentification((Identifier)idDoc);
        DefaultIdentifier idControl = new DefaultIdentifier();
        idControl.setIdType(IdentifierType.IRDI);
        idControl.setIdentifier("0112/2///61360_4#AAF891#002");
        controlSubModel.setIdentification((Identifier)idControl);
        DefaultIdentifier idCalculation = new DefaultIdentifier();
        idCalculation.setIdType(IdentifierType.IRDI);
        idCalculation.setIdentifier("0112/2///61360_4#AAF891#002");
        calculationSubModel.setIdentification((Identifier)idCalculation);
        documentation.setKind(ModelingKind.TEMPLATE);
        controlSubModel.setKind(ModelingKind.TEMPLATE);
        calculationSubModel.setKind(ModelingKind.TEMPLATE);
        Key docKey = new Key(KeyElements.CONCEPT_DESCRIPTION, true, "0112/2///61360_4#AAF891#001", KeyType.IRDI);
        Reference docRef = new Reference(docKey);
        documentation.setSemanticIdentifier((IReference)docRef);
        Key controlKey = new Key(KeyElements.CONCEPT_DESCRIPTION, true, "0112/2///61360_4#AAF891#002", KeyType.IRDI);
        Reference controlRef = new Reference(controlKey);
        controlSubModel.setSemanticIdentifier((IReference)controlRef);
        Key calculationKey = new Key(KeyElements.CONCEPT_DESCRIPTION, true, "0112/2///61360_4#AAF891#002", KeyType.IRDI);
        Reference calculationRef = new Reference(calculationKey);
        calculationSubModel.setSemanticIdentifier((IReference)calculationRef);
        File exampleFile = new File();
        exampleFile.setIdShort("exampleFile");
        exampleFile.setKind(ModelingKind.INSTANCE);
        exampleFile.setMimeType("audio/aac");
        exampleFile.setValue("example.com/myexample");
        documentation.setFile(exampleFile);
        MultiLanguageProperty manufacName = new MultiLanguageProperty("ManufacturerName");
        manufacName.setKind(ModelingKind.INSTANCE);
        manufacName.setValue("en", "Smartfactory KL");
        Key manufacKey = new Key(KeyElements.GLOBAL_REFERENCE, false, "0112/2///61360_4#MYNAME891#005", KeyType.IRDI);
        Reference manufNameRef = new Reference(manufacKey);
        manufacName.setSemanticIdentifier((IReference)manufNameRef);
        documentation.setMultiLanguageProperty(manufacName);
        MultiLanguageProperty prodName = new MultiLanguageProperty("ManufacturerProductDesignation");
        prodName.setKind(ModelingKind.INSTANCE);
        prodName.setValue("de", "Rechner");
        prodName.setValue("en", "Calculator");
        prodName.setValue("fr", "Calculatrice");
        documentation.setMultiLanguageProperty(prodName);
        SubModelElementCollection addressSEC = new SubModelElementCollection("Address");
        documentation.setSubModelElementCollection(addressSEC);
        SubModelElementCollection phoneSEC = new SubModelElementCollection("Phone");
        addressSEC.setSubModelElementCollection(phoneSEC);
        MultiLanguageProperty telephoneNumer = new MultiLanguageProperty("TelephoneNumber");
        phoneSEC.setMultiLanguageProperty(telephoneNumer);
        Property typeTel = new Property("TypeOfTelephone");
        phoneSEC.setProperty(typeTel);
        SubModelElementCollection controlSEC = new SubModelElementCollection("ControlParameters");
        controlSEC.setAllowDuplicates(false);
        controlSEC.setOrdered(true);
        controlSEC.setKind(ModelingKind.INSTANCE);
        SubModelElementCollection exampleSEC = new SubModelElementCollection("Example");
        exampleSEC.setAllowDuplicates(false);
        exampleSEC.setOrdered(true);
        exampleSEC.setKind(ModelingKind.INSTANCE);
        controlSEC.setSubModelElementCollection(exampleSEC);
        System.out.println("Parent of Example: " + exampleSEC.getParentSEC().getIdShort());
        File anotherFile = new File();
        anotherFile.setIdShort("anotherFile");
        anotherFile.setKind(ModelingKind.INSTANCE);
        anotherFile.setMimeType("audio/aac");
        anotherFile.setValue("another.com/myanotherexample");
        anotherFile.setDynamic(true);
        exampleSEC.setFile(anotherFile);
        Property opVolt = new Property("OperatingVoltage");
        opVolt.setValueType(ValueType.Integer);
        opVolt.setDynamic(true);
        opVolt.setValue((Object)5);
        controlSEC.setProperty(opVolt);
        Property unit = new Property("Unit");
        unit.setValueType(ValueType.String);
        unit.setKind(ModelingKind.INSTANCE);
        unit.setValue("Volts");
        controlSEC.setProperty(unit);
        Property opTemp = new Property("OperatingTemperature");
        opTemp.setValueType(ValueType.Integer);
        opTemp.setDynamic(true);
        opTemp.setEndpoint(assetEndpoint1);
        opTemp.setNameSpaceIndex(2);
        opTemp.setIdentifier(5L);
        controlSubModel.setProperty(opTemp);
        controlSubModel.setSubModelElementCollection(controlSEC);
        OperationVariable manuNameInp = new OperationVariable("ManufacturerName", ValueType.String);
        Operation changeManuName = new Operation("changeManufacturerName");
        changeManuName.setInputVariable((IOperationVariable)manuNameInp);
        exampleSEC.setOperation(changeManuName);
        OperationVariable statusOut = new OperationVariable("Status", ValueType.Boolean);
        Operation statusCheck = new Operation("checkStatus");
        statusCheck.setOutputVariable((IOperationVariable)statusOut);
        controlSEC.setOperation(statusCheck);
        OperationVariable test1Input1 = new OperationVariable("Test1Input1", ValueType.Int8);
        OperationVariable test1Input2 = new OperationVariable("Test1Input2", ValueType.Int16);
        OperationVariable resultTest1 = new OperationVariable("ResultTest1", ValueType.UInt8);
        Operation test1Check1 = new Operation("Test1Check");
        test1Check1.setInputVariable((IOperationVariable)test1Input1);
        test1Check1.setInputVariable((IOperationVariable)test1Input2);
        test1Check1.setOutputVariable((IOperationVariable)resultTest1);
        controlSubModel.setOperation(test1Check1);
        OperationVariable test2Input1 = new OperationVariable("Test2Input1", ValueType.NonNegativeInteger);
        OperationVariable test2Input2 = new OperationVariable("TestInput2", ValueType.NonPositiveInteger);
        OperationVariable resultTest2 = new OperationVariable("ResultTest", ValueType.PositiveInteger);
        Operation test2Check1 = new Operation("Test2Check");
        test2Check1.setInputVariable((IOperationVariable)test2Input1);
        test2Check1.setInputVariable((IOperationVariable)test2Input2);
        test2Check1.setOutputVariable((IOperationVariable)resultTest2);
        controlSubModel.setOperation(test2Check1);
        OperationVariable operand1 = new OperationVariable("Operand1", ValueType.Integer);
        OperationVariable operand2 = new OperationVariable("Operand2", ValueType.Integer);
        OperationVariable result = new OperationVariable("Result", ValueType.Integer);
        Operation add = new Operation("Add");
        add.setSemanticDescription(addConcept);
        add.setKind(ModelingKind.INSTANCE);
        add.setInputVariables(new IOperationVariable[]{operand1, operand2});
        add.setOutputVariable((IOperationVariable)result);
        calculationSubModel.setOperation(add);
        Operation sub = new Operation("Subtract");
        sub.setSemanticDescription(subtractConcept);
        sub.setKind(ModelingKind.INSTANCE);
        sub.setInputVariables(new IOperationVariable[]{operand1, operand2});
        sub.setOutputVariable((IOperationVariable)result);
        calculationSubModel.setOperation(sub);
        Operation multiply = new Operation("Multiply");
        multiply.setSemanticDescription(multiplyConcept);
        multiply.setKind(ModelingKind.INSTANCE);
        multiply.setInputVariables(new IOperationVariable[]{operand1, operand2});
        multiply.setOutputVariable((IOperationVariable)result);
        calculationSubModel.setOperation(multiply);
        Operation divide = new Operation("Divide");
        divide.setSemanticDescription(divideConcept);
        divide.setKind(ModelingKind.INSTANCE);
        divide.setInputVariables(new IOperationVariable[]{operand1, operand2});
        divide.setOutputVariable((IOperationVariable)result);
        calculationSubModel.setOperation(divide);
        SubModelElementCollection calSEC = new SubModelElementCollection("CalculationCollection");
        calSEC.setAllowDuplicates(false);
        calSEC.setOrdered(true);
        calSEC.setDynamic(true);
        calSEC.setKind(ModelingKind.INSTANCE);
        calculationSubModel.setSubModelElementCollection(calSEC);
        SubModelElementCollection trialSEC = new SubModelElementCollection("DETrialCollection");
        trialSEC.setAllowDuplicates(false);
        trialSEC.setOrdered(true);
        trialSEC.setDynamic(false);
        trialSEC.setKind(ModelingKind.INSTANCE);
        calSEC.setSubModelElementCollection(trialSEC);
        SubModelElementCollection trialSEC1 = new SubModelElementCollection("DETrial1Collection");
        trialSEC1.setAllowDuplicates(false);
        trialSEC1.setOrdered(true);
        trialSEC1.setDynamic(false);
        trialSEC1.setKind(ModelingKind.INSTANCE);
        trialSEC.setSubModelElementCollection(trialSEC1);
        Asset calculatorAsset = new Asset("Calculator", AssetKind.INSTANCE);
        calculatorAsset.setEndpoints(new Endpoint[]{assetEndpoint1, assetEndpoint2});
        DefaultIdentifier idAsset = new DefaultIdentifier();
        idAsset.setIdType(IdentifierType.IRI);
        idAsset.setIdentifier("https://www.dfki.de/ids/assets/15c9c860-34f3-4fc3-a292-66fd0442c1f9");
        calculatorAsset.setIdentification((Identifier)idAsset);
        AASEndpoint aasEndpoint = new AASEndpoint("localhost", 2000);
        AssetAdministrationShell Papyrus4Manufacturing = new AssetAdministrationShell("Papyrus4Manufacturing", aasEndpoint);
        Papyrus4Manufacturing.setSubModels(new SubModel[]{documentation, controlSubModel, calculationSubModel});
        Papyrus4Manufacturing.setConceptDictionary(conceptDict);
        DefaultIdentifier idAAS = new DefaultIdentifier();
        idAAS.setIdType(IdentifierType.IRI);
        idAAS.setIdentifier("https://www.dfki.de/Papyrus4Manufacturingworkshop/ids/aas/23012dfa-0c1c-4408-bd06-dc3d9dcfcf4f");
        Papyrus4Manufacturing.setIdentification((Identifier)idAAS);
        Papyrus4Manufacturing.setAsset(calculatorAsset);
        Project testAAS = new Project(Papyrus4Manufacturing);
        testAAS.setProjectName("AnotherQualifiedTrial");
        testAAS.setNamespaceFromProjectName();
        testAAS.setProjectFolder("/home/tapanta/Documents/tuleap-eclipse-workspace/AnotherQualified_Trial/");
        testAAS.createProject();
    }

    public static void test7() {
        Endpoint assetEndpoint1 = new Endpoint("CalculatorServer", ProtocolKind.OPCUA, "opc.tcp://127.0.0.1:4840/");
        Endpoint assetEndpoint2 = new Endpoint("MinimalServer", ProtocolKind.OPCUA, "opc.tcp://127.0.0.1:4841/");
        ConceptDictionary conceptDict = new ConceptDictionary();
        DefaultIdentifier idDocumentation = new DefaultIdentifier();
        idDocumentation.setIdType(IdentifierType.IRI);
        idDocumentation.setIdentifier("https://www.dfki.de/ids/documentation/79c44263-30ad-4296-a51e-2df3a4aed4ae");
        ConceptDescription documentationConcept = new ConceptDescription("Documentation", (Identifier)idDocumentation);
        conceptDict.setConceptDescription(documentationConcept);
        DefaultIdentifier idAdd = new DefaultIdentifier();
        idAdd.setIdType(IdentifierType.IRI);
        idAdd.setIdentifier("https://www.dfki.de/ids/add/79c44263-30ad-4296-a51e-2df3a4tbc4ae");
        ConceptDescription addConcept = new ConceptDescription("Add", (Identifier)idAdd);
        addConcept.setCategory(Category.FUNCTION);
        conceptDict.setConceptDescription(addConcept);
        DefaultIdentifier idSub = new DefaultIdentifier();
        idSub.setIdType(IdentifierType.IRI);
        idSub.setIdentifier("https://www.dfki.de/ids/sub/79c44263-30ad-4296-a51e-2df3a4tbc4ae");
        ConceptDescription subtractConcept = new ConceptDescription("Subtract", (Identifier)idSub);
        subtractConcept.setCategory(Category.FUNCTION);
        conceptDict.setConceptDescription(subtractConcept);
        DefaultIdentifier idMul = new DefaultIdentifier();
        idMul.setIdType(IdentifierType.IRI);
        idMul.setIdentifier("https://www.dfki.de/ids/multiply/79c44263-30ad-4296-a51e-2df3a4tbc4ae");
        ConceptDescription multiplyConcept = new ConceptDescription("Multiply", (Identifier)idMul);
        multiplyConcept.setCategory(Category.FUNCTION);
        conceptDict.setConceptDescription(multiplyConcept);
        DefaultIdentifier idDivide = new DefaultIdentifier();
        idDivide.setIdType(IdentifierType.IRI);
        idDivide.setIdentifier("https://www.dfki.de/ids/divide/79c44263-30ad-4296-a51e-2df3a4tbc4ae");
        ConceptDescription divideConcept = new ConceptDescription("Divide", (Identifier)idDivide);
        divideConcept.setCategory(Category.FUNCTION);
        conceptDict.setConceptDescription(divideConcept);
        DefaultIdentifier idTrial = new DefaultIdentifier();
        idTrial.setIdType(IdentifierType.IRDI);
        idTrial.setIdentifier("565#//256641//45//pa8");
        ConceptDescription trialConcept = new ConceptDescription("Trial", (Identifier)idTrial);
        Key trialKey = new Key(KeyElements.PROPERTY, true, "0112/2///61360_4#AAF891#001", KeyType.IRDI);
        Reference trialRef = new Reference(trialKey);
        trialConcept.setIsCaseOf((IReference)trialRef);
        conceptDict.setConceptDescription(trialConcept);
        SubModel documentation = new SubModel("Documentation");
        SubModel controlSubModel = new SubModel("Control");
        SubModel calculationSubModel = new SubModel("Calculation");
        DefaultIdentifier idDoc = new DefaultIdentifier();
        idDoc.setIdType(IdentifierType.IRDI);
        idDoc.setIdentifier("0112/2///61360_4#AAF891#002");
        documentation.setIdentification((Identifier)idDoc);
        DefaultIdentifier idControl = new DefaultIdentifier();
        idControl.setIdType(IdentifierType.IRDI);
        idControl.setIdentifier("0112/2///61360_4#AAF891#002");
        controlSubModel.setIdentification((Identifier)idControl);
        DefaultIdentifier idCalculation = new DefaultIdentifier();
        idCalculation.setIdType(IdentifierType.IRDI);
        idCalculation.setIdentifier("0112/2///61360_4#AAF891#002");
        calculationSubModel.setIdentification((Identifier)idCalculation);
        documentation.setKind(ModelingKind.TEMPLATE);
        controlSubModel.setKind(ModelingKind.TEMPLATE);
        calculationSubModel.setKind(ModelingKind.TEMPLATE);
        Key docKey = new Key(KeyElements.CONCEPT_DESCRIPTION, true, "0112/2///61360_4#AAF891#001", KeyType.IRDI);
        Reference docRef = new Reference(docKey);
        documentation.setSemanticIdentifier((IReference)docRef);
        Key controlKey = new Key(KeyElements.CONCEPT_DESCRIPTION, true, "0112/2///61360_4#AAF891#002", KeyType.IRDI);
        Reference controlRef = new Reference(controlKey);
        controlSubModel.setSemanticIdentifier((IReference)controlRef);
        Key calculationKey = new Key(KeyElements.CONCEPT_DESCRIPTION, true, "0112/2///61360_4#AAF891#002", KeyType.IRDI);
        Reference calculationRef = new Reference(calculationKey);
        calculationSubModel.setSemanticIdentifier((IReference)calculationRef);
        File exampleFile = new File();
        exampleFile.setIdShort("exampleFile");
        exampleFile.setKind(ModelingKind.INSTANCE);
        exampleFile.setMimeType("audio/aac");
        exampleFile.setValue("example.com/myexample");
        documentation.setFile(exampleFile);
        MultiLanguageProperty manufacName = new MultiLanguageProperty("ManufacturerName");
        manufacName.setKind(ModelingKind.INSTANCE);
        manufacName.setValue("en", "Smartfactory KL");
        Key manufacKey = new Key(KeyElements.GLOBAL_REFERENCE, false, "0112/2///61360_4#MYNAME891#005", KeyType.IRDI);
        Reference manufNameRef = new Reference(manufacKey);
        manufacName.setSemanticIdentifier((IReference)manufNameRef);
        documentation.setMultiLanguageProperty(manufacName);
        MultiLanguageProperty prodName = new MultiLanguageProperty("ManufacturerProductDesignation");
        prodName.setKind(ModelingKind.INSTANCE);
        prodName.setValue("de", "Rechner");
        prodName.setValue("en", "Calculator");
        prodName.setValue("fr", "Calculatrice");
        prodName.setValue("ch", "\u7535\u8111");
        prodName.setValue("ben", "\u0995\u09ae\u09cd\u09aa\u09bf\u0989\u099f\u09be\u09b0");
        documentation.setMultiLanguageProperty(prodName);
        SubModelElementCollection addressSEC = new SubModelElementCollection("Address");
        documentation.setSubModelElementCollection(addressSEC);
        SubModelElementCollection phoneSEC = new SubModelElementCollection("Phone");
        addressSEC.setSubModelElementCollection(phoneSEC);
        MultiLanguageProperty telephoneNumer = new MultiLanguageProperty("TelephoneNumber");
        phoneSEC.setMultiLanguageProperty(telephoneNumer);
        Property typeTel = new Property("TypeOfTelephone");
        phoneSEC.setProperty(typeTel);
        SubModelElementCollection controlSEC = new SubModelElementCollection("ControlParameters");
        controlSEC.setAllowDuplicates(false);
        controlSEC.setOrdered(true);
        controlSEC.setKind(ModelingKind.INSTANCE);
        SubModelElementCollection exampleSEC = new SubModelElementCollection("Example");
        exampleSEC.setAllowDuplicates(false);
        exampleSEC.setOrdered(true);
        exampleSEC.setKind(ModelingKind.INSTANCE);
        controlSEC.setSubModelElementCollection(exampleSEC);
        System.out.println("Parent of Example: " + exampleSEC.getParentSEC().getIdShort());
        File anotherFile = new File();
        anotherFile.setIdShort("anotherFile");
        anotherFile.setKind(ModelingKind.INSTANCE);
        anotherFile.setMimeType("audio/aac");
        anotherFile.setValue("another.com/myanotherexample");
        anotherFile.setDynamic(true);
        exampleSEC.setFile(anotherFile);
        Property opVolt = new Property("OperatingVoltage");
        opVolt.setValueType(ValueType.Integer);
        opVolt.setDynamic(true);
        opVolt.setValue((Object)5);
        controlSEC.setProperty(opVolt);
        Property unit = new Property("Unit");
        unit.setValueType(ValueType.String);
        unit.setKind(ModelingKind.INSTANCE);
        unit.setValue("Volts");
        controlSEC.setProperty(unit);
        Property opTemp = new Property("OperatingTemperature");
        opTemp.setValueType(ValueType.Integer);
        opTemp.setDynamic(true);
        opTemp.setEndpoint(assetEndpoint1);
        opTemp.setNameSpaceIndex(2);
        opTemp.setIdentifier(5L);
        controlSubModel.setProperty(opTemp);
        controlSubModel.setSubModelElementCollection(controlSEC);
        OperationVariable manuNameInp = new OperationVariable("ManufacturerName", ValueType.String);
        Operation changeManuName = new Operation("changeManufacturerName");
        changeManuName.setInputVariable((IOperationVariable)manuNameInp);
        exampleSEC.setOperation(changeManuName);
        OperationVariable statusOut = new OperationVariable("Status", ValueType.Boolean);
        Operation statusCheck = new Operation("checkStatus");
        statusCheck.setOutputVariable((IOperationVariable)statusOut);
        controlSEC.setOperation(statusCheck);
        OperationVariable test1Input1 = new OperationVariable("Test1Input1", ValueType.Int8);
        OperationVariable test1Input2 = new OperationVariable("Test1Input2", ValueType.Int16);
        OperationVariable resultTest1 = new OperationVariable("ResultTest1", ValueType.UInt8);
        Operation test1Check1 = new Operation("Test1Check");
        test1Check1.setInputVariable((IOperationVariable)test1Input1);
        test1Check1.setInputVariable((IOperationVariable)test1Input2);
        test1Check1.setOutputVariable((IOperationVariable)resultTest1);
        controlSubModel.setOperation(test1Check1);
        OperationVariable test2Input1 = new OperationVariable("Test2Input1", ValueType.NonNegativeInteger);
        OperationVariable test2Input2 = new OperationVariable("TestInput2", ValueType.NonPositiveInteger);
        OperationVariable resultTest2 = new OperationVariable("ResultTest", ValueType.PositiveInteger);
        Operation test2Check1 = new Operation("Test2Check");
        test2Check1.setInputVariable((IOperationVariable)test2Input1);
        test2Check1.setInputVariable((IOperationVariable)test2Input2);
        test2Check1.setOutputVariable((IOperationVariable)resultTest2);
        controlSubModel.setOperation(test2Check1);
        OperationVariable operand1 = new OperationVariable("Operand1", ValueType.Integer);
        OperationVariable operand2 = new OperationVariable("Operand2", ValueType.Integer);
        OperationVariable result = new OperationVariable("Result", ValueType.Integer);
        Operation add = new Operation("Add");
        add.setSemanticDescription(addConcept);
        add.setKind(ModelingKind.INSTANCE);
        add.setInputVariables(new IOperationVariable[]{operand1, operand2});
        add.setOutputVariable((IOperationVariable)result);
        calculationSubModel.setOperation(add);
        Operation sub = new Operation("S\u00fc\u00fc\u00fc\u00fc\u00fcbtract");
        sub.setSemanticDescription(subtractConcept);
        sub.setKind(ModelingKind.INSTANCE);
        sub.setInputVariables(new IOperationVariable[]{operand1, operand2});
        sub.setOutputVariable((IOperationVariable)result);
        calculationSubModel.setOperation(sub);
        Operation multiply = new Operation("Multiply");
        multiply.setSemanticDescription(multiplyConcept);
        multiply.setKind(ModelingKind.INSTANCE);
        multiply.setInputVariables(new IOperationVariable[]{operand1, operand2});
        multiply.setOutputVariable((IOperationVariable)result);
        calculationSubModel.setOperation(multiply);
        Operation divide = new Operation("Di\u015bide");
        divide.setSemanticDescription(divideConcept);
        divide.setKind(ModelingKind.INSTANCE);
        divide.setInputVariables(new IOperationVariable[]{operand1, operand2});
        divide.setOutputVariable((IOperationVariable)result);
        calculationSubModel.setOperation(divide);
        Property testProp1 = new Property("TestPropertyQualified");
        testProp1.setValueType(ValueType.String);
        testProp1.setDynamic(true);
        testProp1.setEndpoint(assetEndpoint1);
        testProp1.setNameSpaceIndex(2);
        testProp1.setIdentifier(23L);
        calculationSubModel.setProperty(testProp1);
        SubModelElementCollection calSEC = new SubModelElementCollection("CalculationCollection");
        calSEC.setAllowDuplicates(false);
        calSEC.setOrdered(true);
        calSEC.setDynamic(false);
        calSEC.setKind(ModelingKind.INSTANCE);
        calculationSubModel.setSubModelElementCollection(calSEC);
        Property calcProp1 = new Property("CalculationProperty1");
        calcProp1.setValueType(ValueType.String);
        calcProp1.setDynamic(true);
        calSEC.setProperty(calcProp1);
        SubModelElementCollection trialSEC = new SubModelElementCollection("NestedSEC1");
        trialSEC.setAllowDuplicates(false);
        trialSEC.setOrdered(true);
        trialSEC.setDynamic(false);
        trialSEC.setKind(ModelingKind.INSTANCE);
        calSEC.setSubModelElementCollection(trialSEC);
        Property calcProp2 = new Property("CalculationProperty2");
        calcProp2.setValueType(ValueType.String);
        calcProp2.setDynamic(false);
        trialSEC.setProperty(calcProp2);
        SubModelElementCollection trialSEC1 = new SubModelElementCollection("NestedSEC2");
        trialSEC1.setAllowDuplicates(false);
        trialSEC1.setOrdered(true);
        trialSEC1.setDynamic(false);
        trialSEC1.setKind(ModelingKind.INSTANCE);
        trialSEC.setSubModelElementCollection(trialSEC1);
        Property calcProp3 = new Property("CalculationProperty3");
        calcProp3.setValueType(ValueType.String);
        calcProp3.setDynamic(true);
        calcProp3.setEndpoint(assetEndpoint1);
        calcProp3.setNameSpaceIndex(2);
        calcProp3.setIdentifier(24L);
        trialSEC1.setProperty(calcProp3);
        SubModelElementCollection trialSEC2 = new SubModelElementCollection("NestedSEC3");
        trialSEC2.setAllowDuplicates(false);
        trialSEC2.setOrdered(true);
        trialSEC2.setDynamic(false);
        trialSEC2.setKind(ModelingKind.INSTANCE);
        trialSEC1.setSubModelElementCollection(trialSEC2);
        Asset calculatorAsset = new Asset("Calculator", AssetKind.INSTANCE);
        calculatorAsset.setEndpoints(new Endpoint[]{assetEndpoint1, assetEndpoint2});
        DefaultIdentifier idAsset = new DefaultIdentifier();
        idAsset.setIdType(IdentifierType.IRI);
        idAsset.setIdentifier("https://www.dfki.de/ids/assets/15c9c860-34f3-4fc3-a292-66fd0442c1f9");
        calculatorAsset.setIdentification((Identifier)idAsset);
        AASEndpoint aasEndpoint = new AASEndpoint("localhost", 2000);
        AssetAdministrationShell canvaas = new AssetAdministrationShell("CanvAAS", aasEndpoint);
        canvaas.setSubModels(new SubModel[]{documentation, controlSubModel, calculationSubModel});
        canvaas.setConceptDictionary(conceptDict);
        DefaultIdentifier idAAS = new DefaultIdentifier();
        idAAS.setIdType(IdentifierType.IRI);
        idAAS.setIdentifier("https://www.dfki.de/canvaasworkshop/ids/aas/23012dfa-0c1c-4408-bd06-dc3d9dcfcf4f");
        canvaas.setIdentification((Identifier)idAAS);
        canvaas.setAsset(calculatorAsset);
        Project testAAS = new Project(canvaas);
        testAAS.setProjectName("Test1_Bug579656");
        testAAS.setNamespaceFromProjectName();
        testAAS.setProjectFolder("/home/tapanta/Documents/eclipse-workspace/Test1_Bug579656/");
        testAAS.createProject();
    }
}

