/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aas.api.submodel.submodelelement;

import io.adminshell.aas.v3.model.ModelingKind;
import io.adminshell.aas.v3.model.Reference;
import io.adminshell.aas.v3.model.SubmodelElement;
import io.adminshell.aas.v3.model.impl.DefaultSubmodelElementCollection;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.aas.api.communications.Endpoint;
import org.eclipse.aas.api.reference.IReference;
import org.eclipse.aas.api.submodel.SubModel;
import org.eclipse.aas.api.submodel.parts.ConceptDescription;
import org.eclipse.aas.api.submodel.submodelelement.Operation;
import org.eclipse.aas.api.submodel.submodelelement.dataelement.File;
import org.eclipse.aas.api.submodel.submodelelement.dataelement.MultiLanguageProperty;
import org.eclipse.aas.api.submodel.submodelelement.dataelement.Property;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubModelElementCollection
extends DefaultSubmodelElementCollection {
    private static final Logger logger = LoggerFactory.getLogger(SubModelElementCollection.class);
    private IReference semanticId;
    private ConceptDescription conceptDesc;
    private List<Property> properties = new ArrayList<Property>();
    private List<File> files = new ArrayList<File>();
    private List<Operation> operations = new ArrayList<Operation>();
    private List<MultiLanguageProperty> multiLanguageProperties = new ArrayList<MultiLanguageProperty>();
    private List<SubModelElementCollection> subModelElementCollections = new ArrayList<SubModelElementCollection>();
    private SubModelElementCollection parentSEC;
    private SubModel parentSub;
    private boolean isDynamic = false;
    private Endpoint endpoint;

    public SubModelElementCollection() {
        this.kind = ModelingKind.INSTANCE;
        logger.info("SubmodelElementCollection Initialised with no IdShort");
    }

    public SubModelElementCollection(String idShort) {
        this.idShort = idShort;
        this.kind = ModelingKind.INSTANCE;
        logger.info("SubmodelElementCollection Initialised with IdShort: " + idShort);
    }

    @Deprecated
    public void setSemanticId(Reference ref) {
        super.setSemanticId(ref);
    }

    public void setSemanticIdentifier(IReference ref) {
        this.semanticId = ref;
    }

    public void setSemanticDescription(ConceptDescription concept) {
        this.conceptDesc = concept;
    }

    @Deprecated
    public Reference getSemanticId() {
        return super.getSemanticId();
    }

    public IReference getSemanticIdentifier() {
        return this.semanticId;
    }

    public ConceptDescription getSemanticDescription() {
        return this.conceptDesc;
    }

    public void setFile(File fileInstance) {
        fileInstance.setParent(this);
        this.files.add(fileInstance);
        logger.info("File " + fileInstance.getIdShort() + " set to " + "SubModelElementCollection: " + super.getIdShort());
        this.setSuperSubmodelElements((SubmodelElement)fileInstance);
    }

    public void setFiles(File ... fileInstances) {
        File[] fileArray = fileInstances;
        int n = fileInstances.length;
        int n2 = 0;
        while (n2 < n) {
            File fileInstance = fileArray[n2];
            fileInstance.setParent(this);
            this.files.add(fileInstance);
            logger.info("Files " + fileInstance.getIdShort() + " set to " + "SubModelElementCollection: " + super.getIdShort());
            this.setSuperSubmodelElements((SubmodelElement)fileInstance);
            ++n2;
        }
    }

    public void setFiles(List<File> files) {
        this.files = files;
        logger.info("A List of Files received and set to SubModelElementCollection: " + super.getIdShort());
        for (File file : files) {
            file.setParent(this);
            this.setSuperSubmodelElements((SubmodelElement)file);
        }
    }

    public List<File> getFiles() {
        return this.files;
    }

    public void setProperty(Property propInstance) {
        propInstance.setParent(this);
        this.properties.add(propInstance);
        logger.info("Property " + propInstance.getIdShort() + " set to " + "SubModelElementCollection: " + super.getIdShort());
        this.setSuperSubmodelElements(propInstance);
    }

    public void setProperties(Property ... propInstances) {
        Property[] propertyArray = propInstances;
        int n = propInstances.length;
        int n2 = 0;
        while (n2 < n) {
            Property propInstance = propertyArray[n2];
            propInstance.setParent(this);
            this.properties.add(propInstance);
            logger.info("Property " + propInstance.getIdShort() + " set to " + "SubModelElementCollection: " + super.getIdShort());
            this.setSuperSubmodelElements(propInstance);
            ++n2;
        }
    }

    public void setProperties(List<Property> properties) {
        this.properties = properties;
        logger.info("A List of Property received and set to SubModelElementCollection: " + super.getIdShort());
        for (Property property : properties) {
            property.setParent(this);
            this.setSuperSubmodelElements(property);
        }
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public void setOperation(Operation opInstance) {
        opInstance.setParent(this);
        this.operations.add(opInstance);
        logger.info("Operation " + opInstance.getIdShort() + " set to " + "SubModelElementCollection: " + super.getIdShort());
        this.setSuperSubmodelElements((SubmodelElement)opInstance);
    }

    public void setOperations(Operation ... opInstances) {
        Operation[] operationArray = opInstances;
        int n = opInstances.length;
        int n2 = 0;
        while (n2 < n) {
            Operation opInstance = operationArray[n2];
            opInstance.setParent(this);
            this.operations.add(opInstance);
            logger.info("Operation " + opInstance.getIdShort() + " set to " + "SubModelElementCollection: " + super.getIdShort());
            this.setSuperSubmodelElements((SubmodelElement)opInstance);
            ++n2;
        }
    }

    public void setOperations(List<Operation> operations) {
        this.operations = operations;
        logger.info("A List of Operations received and set to SubModelElementCollection: " + super.getIdShort());
        for (Operation operation : operations) {
            operation.setParent(this);
            this.setSuperSubmodelElements((SubmodelElement)operation);
        }
    }

    public List<Operation> getOperations() {
        return this.operations;
    }

    public void setMultiLanguageProperty(MultiLanguageProperty multiLangProp) {
        multiLangProp.setParent(this);
        this.multiLanguageProperties.add(multiLangProp);
        logger.info("MultiLanguageProperty " + multiLangProp.getIdShort() + " set to SubModelElementCollection: " + super.getIdShort());
        this.setSuperSubmodelElements((SubmodelElement)multiLangProp);
    }

    public void setMultiLanguageProperties(MultiLanguageProperty ... multiLangProps) {
        MultiLanguageProperty[] multiLanguagePropertyArray = multiLangProps;
        int n = multiLangProps.length;
        int n2 = 0;
        while (n2 < n) {
            MultiLanguageProperty multiLangProp = multiLanguagePropertyArray[n2];
            multiLangProp.setParent(this);
            this.multiLanguageProperties.add(multiLangProp);
            logger.info("MultiLanguageProperty " + multiLangProp.getIdShort() + " set to SubModelElementCollection: " + super.getIdShort());
            this.setSuperSubmodelElements((SubmodelElement)multiLangProp);
            ++n2;
        }
    }

    public void setMultiLanguageProperties(List<MultiLanguageProperty> multiLangProps) {
        this.multiLanguageProperties = multiLangProps;
        logger.info("A List of MultiLanguageProperties received and set to SubModelElementCollection: " + super.getIdShort());
        for (MultiLanguageProperty multiLangProp : multiLangProps) {
            multiLangProp.setParent(this);
            this.setSuperSubmodelElements((SubmodelElement)multiLangProp);
        }
    }

    public List<MultiLanguageProperty> getMultiLanguageProperties() {
        return this.multiLanguageProperties;
    }

    public void setSubModelElementCollection(SubModelElementCollection sec) {
        sec.setParent(this);
        this.subModelElementCollections.add(sec);
        logger.info("SubmodelElementCollection " + sec.getIdShort() + " set to SubModelElementCollection: " + super.getIdShort());
        this.setSuperSubmodelElements((SubmodelElement)sec);
    }

    public void setSubModelElementCollections(SubModelElementCollection ... secs) {
        SubModelElementCollection[] subModelElementCollectionArray = secs;
        int n = secs.length;
        int n2 = 0;
        while (n2 < n) {
            SubModelElementCollection sec = subModelElementCollectionArray[n2];
            sec.setParent(this);
            this.subModelElementCollections.add(sec);
            logger.info("SubmodelElementCollection " + sec.getIdShort() + " set to SubModelElementCollection: " + super.getIdShort());
            this.setSuperSubmodelElements((SubmodelElement)sec);
            ++n2;
        }
    }

    public void setSubModelElementCollections(List<SubModelElementCollection> secs) {
        this.subModelElementCollections = secs;
        logger.info("A List of SubmodelElementCollection received and set to SubModelElementCollection: " + super.getIdShort());
        for (SubModelElementCollection sec : secs) {
            sec.setParent(this);
            this.setSuperSubmodelElements((SubmodelElement)sec);
        }
    }

    public List<SubModelElementCollection> getSubModelElementCollections() {
        return this.subModelElementCollections;
    }

    public void setParent(SubModelElementCollection parent) {
        this.parentSEC = parent;
    }

    public void setParent(SubModel parent) {
        this.parentSub = parent;
    }

    public SubModelElementCollection getParentSEC() {
        return this.parentSEC;
    }

    public SubModel getParentSub() {
        return this.parentSub;
    }

    public boolean isDynamic() {
        return this.isDynamic;
    }

    public void setDynamic(boolean isDynamic) {
        this.isDynamic = isDynamic;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    private void setSuperSubmodelElements(SubmodelElement subElem) {
        super.getValues().add(subElem);
        logger.info("Internal call to parent class method successful.");
    }
}

