/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aas.basyx.codegen.generator;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.eclipse.aas.api.aas.AssetAdministrationShell;
import org.eclipse.aas.api.communications.AASEndpoint;
import org.eclipse.aas.api.submodel.SubModel;
import org.eclipse.aas.basyx.codegen.generator.FileUtils;
import org.eclipse.aas.basyx.codegen.generator.modulefiles.AASModuleCreator;
import org.eclipse.aas.basyx.codegen.generator.modulefiles.ConceptDescriptionCreator;
import org.eclipse.aas.basyx.codegen.generator.modulefiles.DataHandlerCreator;
import org.eclipse.aas.basyx.codegen.generator.submodel.DEWorkspaceCreator;
import org.eclipse.aas.basyx.codegen.generator.submodel.SubModelCreator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Project {
    private static final Logger logger = LoggerFactory.getLogger(Project.class);
    private AssetAdministrationShell aas;
    private SubModelCreator smc;
    private AASModuleCreator amc;
    private DataHandlerCreator dhc;
    private DEWorkspaceCreator dewc;
    private ConceptDescriptionCreator cdc;
    private Path currentWorkingDirectory = Paths.get(FileUtils.getCurrentWorkingDirectory(), new String[0]);
    private String namespace = "de.dfki.Papyrus4Manufacturing.default";
    private String projectName = "Papyrus4ManufacturingProject";
    private Path projectFolder = Paths.get(this.projectName, new String[0]);

    public Project(AssetAdministrationShell aas) {
        this.aas = aas;
        logger.info("Project Initialised for Asset Administration Shell: " + this.aas.getIdShort());
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectFolder(String projectFolder) {
        this.projectFolder = Paths.get(projectFolder, new String[0]);
    }

    public String getProjectFolder() {
        return this.projectFolder.toString();
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void setNamespaceFromProjectName() {
        this.namespace = this.projectName.toLowerCase().replace(" ", ".");
    }

    public String getSafeProjectName() {
        return this.projectName.toLowerCase().replace(" ", "");
    }

    public String getProjectNameWithoutSpace() {
        return this.projectName.replace(" ", "");
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getNamespace() {
        return this.namespace;
    }

    private void createFilePaths() {
        FileUtils.createDirectories(this.projectFolder.resolve(Paths.get("src", "main", "java", FileUtils.getFullPathFromNamespace(this.namespace), "connection")).toString());
        FileUtils.createDirectories(this.projectFolder.resolve(Paths.get("src", "main", "java", FileUtils.getFullPathFromNamespace(this.namespace), "module", "submodels")).toString());
        List subModels = this.aas.getSubModels();
        for (SubModel subModel : subModels) {
            FileUtils.createDirectories(this.projectFolder.resolve(Paths.get("src", "main", "java", FileUtils.getFullPathFromNamespace(this.namespace), "module", "submodels", subModel.getIdShort().toLowerCase())).toString());
        }
        FileUtils.createDirectories(this.projectFolder.resolve(Paths.get("src", "main", "resources")).toString());
        logger.info("Creating Filepaths successful!");
    }

    private void createConnectionFiles() {
        this.createFilePaths();
        this.dhc = new DataHandlerCreator(this.aas, this.aas.getAsset(), this.getNamespace());
        Path connectedDevicesPath = this.projectFolder.resolve(Paths.get("src", "main", "java", FileUtils.getFullPathFromNamespace(this.namespace), "connection", "ConnectedDevices.java"));
        FileUtils.writeData(connectedDevicesPath.toString(), this.dhc.createConnectedDevices());
        Path opcuaConnectorWrapperPath = this.projectFolder.resolve(Paths.get("src", "main", "java", FileUtils.getFullPathFromNamespace(this.namespace), "connection", "OPCUAConnectorWrapper.java"));
        FileUtils.writeData(opcuaConnectorWrapperPath.toString(), this.dhc.createOPCUAConnectorWrapper());
        Path httpConnectorWrapperPath = this.projectFolder.resolve(Paths.get("src", "main", "java", FileUtils.getFullPathFromNamespace(this.namespace), "connection", "HTTPConnectorWrapper.java"));
        FileUtils.writeData(httpConnectorWrapperPath.toString(), this.dhc.createHTTPConnectorWrapper());
        Path opcuaVariablePath = this.projectFolder.resolve(Paths.get("src", "main", "java", FileUtils.getFullPathFromNamespace(this.namespace), "connection", "OpcUaVariable.java"));
        FileUtils.writeData(opcuaVariablePath.toString(), this.dhc.createOPCUAVariable());
        logger.info("Creating Connection Files successful!");
    }

    private void createModuleFiles() {
        this.createFilePaths();
        this.amc = new AASModuleCreator(this.aas, this.aas.getAsset(), this.getNamespace());
        this.cdc = new ConceptDescriptionCreator(this.aas, this.getNamespace());
        Path aasServerPath = this.projectFolder.resolve(Paths.get("src", "main", "java", FileUtils.getFullPathFromNamespace(this.namespace), "module", "AASServer.java"));
        FileUtils.writeData(aasServerPath.toString(), this.amc.createAASServer());
        Path deviceContextPath = this.projectFolder.resolve(Paths.get("src", "main", "java", FileUtils.getFullPathFromNamespace(this.namespace), "module", "DeviceContext.java"));
        FileUtils.writeData(deviceContextPath.toString(), this.amc.createDeviceContext());
        Path aasModelsPath = this.projectFolder.resolve(Paths.get("src", "main", "java", FileUtils.getFullPathFromNamespace(this.namespace), "module", "AASModels.java"));
        FileUtils.writeData(aasModelsPath.toString(), this.amc.createAASModels());
        Path settingsPath = this.projectFolder.resolve(Paths.get("src", "main", "java", FileUtils.getFullPathFromNamespace(this.namespace), "module", "Settings.java"));
        FileUtils.writeData(settingsPath.toString(), this.amc.createSettings());
        Path conceptDescriptionPath = this.projectFolder.resolve(Paths.get("src", "main", "java", FileUtils.getFullPathFromNamespace(this.namespace), "module", "ConceptDescriptions.java"));
        FileUtils.writeData(conceptDescriptionPath.toString(), this.cdc.createConceptDescriptions());
        logger.info("Creating Module Files successful!");
    }

    private void createSubModelFiles() {
        List subModels = this.aas.getSubModels();
        for (SubModel subModel : subModels) {
            this.smc = new SubModelCreator(subModel, this.getNamespace());
            this.dewc = new DEWorkspaceCreator(subModel, this.getNamespace());
            FileUtils.writeData(this.projectFolder.resolve(Paths.get("src", "main", "java", FileUtils.getFullPathFromNamespace(this.namespace), "module", "submodels", subModel.getIdShort().toLowerCase(), String.valueOf(subModel.getIdShort().replace(" ", "")) + ".java")).toString(), this.smc.createSubModelFile());
            FileUtils.writeData(this.projectFolder.resolve(Paths.get("src", "main", "java", FileUtils.getFullPathFromNamespace(this.namespace), "module", "submodels", subModel.getIdShort().toLowerCase(), "DynamicElementsWorkspace.java")).toString(), this.dewc.generateDEWorkspace());
        }
        logger.info("Creating  Submodel Files successful!");
    }

    private void createProjectFile() {
        String text = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<projectDescription>\r\n\t<name>" + this.getProjectName() + "</name>\r\n" + "\t<comment></comment>\r\n" + "\t<projects>\r\n" + "\t</projects>\r\n" + "\t<buildSpec>\r\n" + "\t\t<buildCommand>\r\n" + "\t\t\t<name>org.eclipse.jdt.core.javabuilder</name>\r\n" + "\t\t\t<arguments>\r\n" + "\t\t\t</arguments>\r\n" + "\t\t</buildCommand>\r\n" + "   \t<buildCommand>\r\n" + "\t\t\t<name>org.eclipse.m2e.core.maven2Builder</name>\r\n" + "\t\t\t<arguments>\r\n" + "\t\t\t</arguments>\r\n" + "\t\t</buildCommand>\r\n" + "\t</buildSpec>\r\n" + "\t<natures>\r\n" + "\t\t<nature>org.eclipse.jdt.core.javanature</nature>\r\n" + "\t</natures>\r\n" + "</projectDescription>\r\n";
        FileUtils.writeData(this.projectFolder.resolve(".project").toString(), text);
        logger.info("Creating Project File successful!");
    }

    private void createPOMFile() {
        String text = "<project xmlns=\"http://maven.apache.org/POM/4.0.0\"\r\n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n\txsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\">\r\n\t<modelVersion>4.0.0</modelVersion>\r\n\r\n\t<groupId>de.dfki.Papyrus4Manufacturing</groupId>\r\n\t<artifactId>" + this.getSafeProjectName() + "</artifactId>\r\n" + "\t<version>0.1.0-SNAPSHOT</version>\r\n" + "\t<name>" + this.getProjectName() + "</name>\r\n" + "\r\n" + "\t<packaging>jar</packaging>\r\n" + "\r\n" + "  <properties>\r\n" + "    <project.build.sourceEncoding>UTF-8</project.build.sourceEncoding>\r\n" + "    <project.reporting.outputEncoding>UTF-8</project.reporting.outputEncoding>\r\n" + "  </properties>\r\n" + "\r\n" + "\t<build>\r\n" + "\t\t<!-- specify custom source directory (default maven source folder is /src/main/java) -->\r\n" + "\t\t<sourceDirectory>src/main/java</sourceDirectory>\r\n" + "\r\n" + "\t\t<plugins>\r\n" + "\t\t\t<!-- Add third-party licenses to generated-code -->\n" + "\t\t\t<plugin>\n" + "\t\t\t\t<groupId>org.codehaus.mojo</groupId>\n" + "\t\t\t\t<artifactId>license-maven-plugin</artifactId>\n" + "\t\t\t\t<version>2.0.0</version>\n" + "\t\t\t\t<executions>\n" + "\t\t\t\t\t<execution>\n" + "\t\t\t\t\t\t<goals>\n" + "\t\t\t\t\t\t\t<goal>add-third-party</goal>\n" + "\t\t\t\t\t\t</goals>\n" + "\t\t\t\t\t</execution>\n" + "\t\t\t\t</executions>\n" + "\t\t\t</plugin>\n" + "\t\t\t<!-- Compile Sources using Java 8 -->\r\n" + "\t\t\t<plugin>\r\n" + "\t\t\t\t<artifactId>maven-compiler-plugin</artifactId>\r\n" + "\t\t\t\t<version>3.8.1</version>\r\n" + "\t\t\t\t<configuration>\r\n" + "\t\t\t\t\t<source>1.8</source>\r\n" + "\t\t\t\t\t<target>1.8</target>\r\n" + "\t\t\t\t</configuration>\r\n" + "\t\t\t\t<executions>\r\n" + "                    <!-- Attach the shade into the package phase -->\r\n" + "                    <execution>\r\n" + "                        <phase>package</phase>\r\n" + "                        <configuration>\r\n" + "                            <transformers>\r\n" + "                                <transformer\r\n" + "                                        implementation=\"org.apache.maven.plugins.shade.resource.ManifestResourceTransformer\">\r\n" + "                                    <mainClass>" + this.getNamespace() + ".module.AASServer</mainClass>\r\n" + "                                </transformer>\r\n" + "                            </transformers>\r\n" + "                        </configuration>\r\n" + "                    </execution>\r\n" + "                </executions>\r\n" + "\t\t\t</plugin>\r\n" + "\t\t\t<!-- Executable Jar -->\n" + "\t\t\t<plugin>\n" + "\t\t\t\t<artifactId>maven-assembly-plugin</artifactId>\n" + "        \t\t<version>3.3.0</version>\n" + "        \t\t<executions>\n" + "          \t\t\t<execution>\n" + "            \t\t\t<id>make-assembly</id>\n" + "            \t\t\t<phase>package</phase>\n" + "            \t\t\t<goals>\n" + "              \t\t\t\t<goal>single</goal>\n" + "            \t\t\t</goals>\n" + "          \t\t\t</execution>\n" + "        \t\t</executions>\n" + "        \t\t<configuration>\n" + "          \t\t\t<descriptorRefs>\n" + "            \t\t\t<descriptorRef>jar-with-dependencies</descriptorRef>\n" + "          \t\t\t</descriptorRefs>\n" + "          \t\t\t<finalName>${project.artifactId}</finalName>\n" + "          \t\t\t<appendAssemblyId>false</appendAssemblyId>\n" + "          \t\t\t<outputDirectory>${project.basedir}</outputDirectory>\n" + "          \t\t\t<archive>\n" + "            \t\t\t<manifest>\n" + "                     \t<mainClass>" + this.getNamespace() + ".module.AASServer</mainClass>\r\n" + "            \t\t\t</manifest>\n" + "          \t\t\t</archive>\n" + "        \t\t</configuration>\n" + "\t\t\t</plugin>\r\n" + "\t\t</plugins>\r\n" + "\t</build>\r\n" + "\r\n" + "\t<dependencies>\r\n" + "\t\t<dependency>\r\n" + "\t\t\t<groupId>org.eclipse.basyx</groupId>\r\n" + "\t\t\t<artifactId>basyx.sdk</artifactId>\r\n" + "\t\t\t<version>1.2.0</version>\r\n" + "\t\t</dependency>\r\n" + "\t\t<dependency>\n" + "\t\t\t<groupId>com.festo.aas</groupId>\n" + "\t\t\t<artifactId>p4m-helpers</artifactId>\n" + "\t\t\t<version>1.0.4</version>\n" + "\t\t</dependency>\r\n" + "\t</dependencies>\r\n" + "</project>";
        FileUtils.writeData(this.projectFolder.resolve("pom.xml").toString(), text);
        logger.info("Creating POM File successful!");
    }

    private void createClassFile() {
        Path targetClasses = Paths.get("target", "classes");
        Path targetTestClasses = Paths.get("target", "test-classes");
        Path mainFolder = Paths.get("src", "main", "java");
        Path testFolder = Paths.get("src", "test", "java");
        Path resourcesFolder = Paths.get("src", "main", "resources");
        Paths.get("src", new String[0]);
        String text = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<classpath>\r\n\t<classpathentry kind=\"con\" path=\"org.eclipse.jdt.launching.JRE_CONTAINER/org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType/JavaSE-1.8\">\r\n\t\t<attributes>\r\n\t\t\t<attribute name=\"maven.pomderived\" value=\"true\"/>\r\n\t\t</attributes>\r\n\t</classpathentry>\r\n\t<classpathentry kind=\"con\" path=\"org.eclipse.m2e.MAVEN2_CLASSPATH_CONTAINER\">\r\n\t\t<attributes>\r\n\t\t\t<attribute name=\"maven.pomderived\" value=\"true\"/>\r\n\t\t</attributes>\r\n\t</classpathentry>\r\n\t<classpathentry kind=\"con\" path=\"org.eclipse.jdt.junit.JUNIT_CONTAINER/5\"/>\r\n\t<classpathentry excluding=\"**\" kind=\"src\" output=\"" + targetClasses.toString() + "\" path=\"" + resourcesFolder.toString() + "\">\r\n" + "\t\t<attributes>\r\n" + "\t\t\t<attribute name=\"maven.pomderived\" value=\"true\"/>\r\n" + "\t\t</attributes>\r\n" + "\t</classpathentry>\r\n" + "\t<classpathentry kind=\"src\" output=\"" + targetClasses.toString() + "\" path=\"" + mainFolder.toString() + "\">\r\n" + "\t\t<attributes>\r\n" + "\t\t\t<attribute name=\"optional\" value=\"true\"/>\r\n" + "\t\t\t<attribute name=\"maven.pomderived\" value=\"true\"/>\r\n" + "\t\t</attributes>\r\n" + "\t</classpathentry>\r\n" + "\t<classpathentry kind=\"src\" output=\"" + targetTestClasses.toString() + "\" path=\"" + testFolder.toString() + "\">\r\n" + "\t\t<attributes>\r\n" + "\t\t\t<attribute name=\"optional\" value=\"true\"/>\r\n" + "\t\t\t<attribute name=\"maven.pomderived\" value=\"true\"/>\r\n" + "\t\t\t<attribute name=\"test\" value=\"true\"/>\r\n" + "\t\t</attributes>\r\n" + "\t</classpathentry>\r\n" + "\t<classpathentry kind=\"output\" path=\"" + targetClasses.toString() + "\"/>\r\n" + "</classpath>\r\n";
        FileUtils.writeData(this.projectFolder.resolve(".classpath").toString(), text);
        logger.info("Creating Class File successful!");
    }

    private void createLaunchFile() {
        String text = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\r\n<launchConfiguration type=\"org.eclipse.jdt.launching.localJavaApplication\"> \r\n\t<listAttribute key=\"org.eclipse.debug.core.MAPPED_RESOURCE_PATHS\"> \r\n\t\t<listEntry value=\"/" + this.projectName + "/src/" + "main/java/" + this.projectName.toLowerCase() + "/module/AASServer.java\"/> \r\n" + "\t</listAttribute> \r\n" + "\t<listAttribute key=\"org.eclipse.debug.core.MAPPED_RESOURCE_TYPES\"> \r\n" + "\t\t<listEntry value=\"1\"/> \r\n" + "\t</listAttribute> \r\n" + "\t<booleanAttribute key=\"org.eclipse.jdt.launching.ATTR_EXCLUDE_TEST_CODE\" value=\"true\"/> \r\n" + "\t<stringAttribute key=\"org.eclipse.jdt.launching.CLASSPATH_PROVIDER\" value=\"org.eclipse.m2e.launchconfig.classpathProvider\"/> \r\n" + "\t<stringAttribute key=\"org.eclipse.jdt.launching.MAIN_TYPE\" value=\"" + this.projectName.toLowerCase() + ".module.AASServer\"/> \r\n" + "\t<stringAttribute key=\"org.eclipse.jdt.launching.MODULE_NAME\" value=\"" + this.projectName + "\"/> \r\n" + "\t<stringAttribute key=\"org.eclipse.jdt.launching.PROJECT_ATTR\" value=\"" + this.projectName + "\"/> \r\n" + "\t<stringAttribute key=\"org.eclipse.jdt.launching.SOURCE_PATH_PROVIDER\" value=\"org.eclipse.m2e.launchconfig.sourcepathProvider\"/> \r\n" + "</launchConfiguration>\r\n";
        FileUtils.writeData(this.projectFolder.resolve("AASServer.launch").toString(), text);
        logger.info("Creating Launch File successful!");
    }

    private void createReadMe() {
        List submodels = this.aas.getSubModels();
        AASEndpoint aasServer = this.aas.getAASEndpoint();
        String text = "# Welcome to " + this.projectName + "!\r\n" + "\r\n" + "This project contains all required files to run your AAS server.\r\n" + "\r\n" + "# Running\r\n" + "To run the AAS without modifications, please right-click on **AASServer.java** in *" + this.getSafeProjectName() + ".module* package and choose **Run As -> Java Application**. " + "Then, you will see when the server is ready to be accessed on: " + "**http://" + aasServer.getAddress() + ":" + aasServer.getPort() + "/" + "aas/**\r\n" + "\r\n" + "Another option could also be to cut the **AASServer.launch** created in the projectFolder and paste\r\n" + "it in the following path - {PATH to eclipse-workspace}\\.metadata\\.plugins\\org.eclipse.debug.core\\.launches\r\n" + "If the **AASServer.launch** is pasted in the above PATH, a direct click on the green play button in the eclipse\r\n" + "workspace will launch the AAS. Note: the AAS Folder must be selected before clicking on the green play button.\r\n" + "The AAS Server provides a REST interface. You can see the list of commands " + "[here](https://app.swaggerhub.com/apis/BaSyx/basyx_submodel_http_rest_api/v1#/).\r\n" + "Using the interface, you can invoke operations and/or get property values." + "\r\n" + "# Files\r\n" + "\r\n" + "## Sub Models\r\n" + "\r\n" + "The project contains the following submodels:\r\n" + "\r\n";
        for (SubModel subModel : submodels) {
            text = String.valueOf(text) + " - " + subModel.getIdShort() + " (URL to access: *[http://" + aasServer.getAddress() + ":" + aasServer.getPort() + "/" + "aas/submodels/" + subModel.getIdShort() + "]" + "(http://" + aasServer.getAddress() + ":" + aasServer.getPort() + "/" + "aas/submodels/" + subModel.getIdShort() + ")*)\r\n";
        }
        text = String.valueOf(text) + "\r\nYou can find them inside *" + this.getSafeProjectName() + ".module.submodel* package.\r\n" + "You can edit these files to tweak properties and operations. You may need to refer to " + "[Basyx Documentation](https://app.swaggerhub.com/apis/BaSyx/basyx_submodel_http_rest_api/v1#/) to work with those files manually.\r\n" + "\r\n" + "Example illustrations of formats to make REST API Calls:\r\n" + "#- POST Call Format (AAS Operations):\r\n" + "\r\n" + "\t\t-\tIn case, AAS Operation is added to a SubModelElementCollection:\r\n" + "\t\t\thttp://{host}/aas/submodels/{submodelName}/submodel/submodelElements/{submodelCollectionName}/{OperationName}/invoke\t\r\n" + "\r\n" + "\t\t- \tIn case, AAS Operation is not added to a SubModelElementCollection:\r\n" + "\t\t\thttp://{host}/aas/submodels/{submodelName}/submodel/submodelElements/{OperationName}/invoke \r\n" + "\r\n" + "# Example - POST Call Format (AAS Operations): An Operation with two Input Variables[Operand1 and Operand2] \r\n" + "\t\t-\t{\n" + "    \t\t\"requestId\": \"{{$timestamp}}\",\n" + "    \t\t\"inputArguments\": [\n" + "        \t\t{\n" + "            \t\t\"modelType\": {\n" + "                \t\t\"name\": \"OperationVariable\"\n" + "            \t\t},\n" + "            \t\t\"value\": {\n" + "                \t\t\"idShort\": \"Operand1\",\n" + "                \t\t\"modelType\": {\n" + "                    \t\t\"name\": \"Property\"\n" + "                \t\t},\n" + "                \t\t\"kind\": \"Template\",\n" + "                \t\t\"valueType\": \"Integer\",\n" + "                \t\t\"value\": 30\n" + "            \t\t}\n" + "        \t\t},\n" + "        \t\t{\n" + "            \t\t\"modelType\": {\n" + "                \t\t\"name\": \"OperationVariable\"\n" + "            \t\t},\n" + "            \t\t\"value\": {\n" + "                \t\t\"idShort\": \"Operand2\",\n" + "                \t\t\"modelType\": {\n" + "                    \t\t\"name\": \"Property\"\n" + "                \t\t},\n" + "                \t\t\"kind\": \"Template\",\n" + "                \t\t\"valueType\": \"Integer\",\n" + "                \t\t\"value\": 50\n" + "            \t\t}\n" + "        \t\t}\n" + "    \t\t],\n" + "    \t\t\"inoutputArguments\": [],\n" + "    \t\t\"timeout\": 5000\n" + "\t\t\t}\n" + "\r\n" + "\r\n" + "#- GET Call Format (AAS Properties): \r\n" + "\r\n" + "\t\t- \tIn case, AAS Properties is added to a SubModelElementCollection: \r\n" + "\t\t\thttp://{host}/aas/submodels/{submodelIdShort}/submodel/submodelElements/{SubModelElementsCollectionName}/{propertyIdShort}/value \r\n" + "\r\n" + "\t\t- \tIn case, AAS Properties is not added to a SubModelElementCollection: \r\n" + "\t\t\thttp://{host}/aas/submodels/{submodelIdShort}/submodel/submodelElements/{propertyIdShort}/value" + "\r\n" + "#- PUT Call Format (AAS Properties): \r\n" + "\r\n" + "\t\t-\tIn case, AAS Properties is added to a SubModelElementCollection: \r\n" + "\t\t\thttp://{host}/aas/submodels/{submodelIdShort}/submodel/submodelElements/{SubModelElementsCollectionName}/{propertyIdShort}/value \r\n" + "\r\n" + "\t\t- In case, AAS Properties is not added to a SubModelElementCollection: \r\n" + "\t\t\thttp://{host}/aas/submodels/{submodelIdShort}/submodel/submodelElements/{propertyIdShort}/value \r\n" + "\r\n" + "## Link\r\n" + "\r\n" + "If you linked two AAS projects, you can see pre-created methods to access remote API calls inside " + "*" + this.getSafeProjectName() + ".module.submodel.link* package. You can use these methods using static calls.\r\n";
        FileUtils.writeData(this.projectFolder.resolve("README.md").toString(), text);
        logger.info("Creating ReadMe File successful!");
    }

    private void createPropertiesFile() {
        this.dhc = new DataHandlerCreator(this.aas, this.aas.getAsset(), this.getNamespace());
        FileUtils.writeData(this.projectFolder.resolve(Paths.get("src", "main", "resources", "default.properties")).toString(), this.dhc.propertiesFile());
        logger.info("Creating Properties File successful!");
    }

    private void createLogbackFile() {
        String text = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n \r\n<configuration>\r\n  <appender name=\"STDOUT\" class=\"ch.qos.logback.core.ConsoleAppender\">\r\n    <encoder>\r\n      <pattern>%d{HH:mm:ss.SSS} [%thread] %-5level %logger{5} - %msg%n</pattern>\r\n    </encoder>\r\n  </appender>\r\n  \r\n  <root level=\"info\">          \r\n    <appender-ref ref=\"STDOUT\" />\r\n  </root>\r\n  \r\n  <logger name=\"org.apache\" level=\"info\"></logger>\r\n  <logger name=\"org.eclipse.milo\" level=\"info\"></logger>\r\n  <logger name=\"io.netty\" level=\"info\"></logger>\r\n</configuration>\r\n";
        FileUtils.writeData(this.projectFolder.resolve(Paths.get("src", "main", "resources", "logback.xml")).toString(), text);
        logger.info("Creating Logback File successful!");
    }

    public void createProject() {
        this.createConnectionFiles();
        this.createModuleFiles();
        this.createSubModelFiles();
        this.createProjectFile();
        this.createClassFile();
        this.createLaunchFile();
        this.createPOMFile();
        this.createReadMe();
        this.createPropertiesFile();
        this.createLogbackFile();
        System.out.println("Done. Files are at: " + this.projectFolder);
    }
}

