/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aas.basyx.codegen.generator.submodel.submodelelements;

import java.util.List;
import org.eclipse.aas.api.reference.Key;
import org.eclipse.aas.api.submodel.parts.ConceptDescription;
import org.eclipse.aas.api.submodel.submodelelement.Operation;
import org.eclipse.aas.api.submodel.submodelelement.SubModelElementCollection;
import org.eclipse.aas.api.submodel.submodelelement.dataelement.File;
import org.eclipse.aas.api.submodel.submodelelement.dataelement.MultiLanguageProperty;
import org.eclipse.aas.api.submodel.submodelelement.dataelement.Property;
import org.eclipse.aas.basyx.codegen.generator.FileUtils;
import org.eclipse.aas.basyx.codegen.generator.submodel.submodelelements.FileGenerator;
import org.eclipse.aas.basyx.codegen.generator.submodel.submodelelements.MLPGenerator;
import org.eclipse.aas.basyx.codegen.generator.submodel.submodelelements.OperationGenerator;
import org.eclipse.aas.basyx.codegen.generator.submodel.submodelelements.PropertyGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SECGenerator {
    private static final Logger logger = LoggerFactory.getLogger(SECGenerator.class);
    private SubModelElementCollection secInstance;
    private List<Key> semanticKeys;
    private List<Property> properties;
    private List<File> files;
    private List<Operation> operations;
    private List<MultiLanguageProperty> mlps;
    private List<SubModelElementCollection> subSECs;
    private String parent;
    private ConceptDescription conceptDesc;

    public SECGenerator(SubModelElementCollection secInstance) {
        this.secInstance = secInstance;
        this.properties = secInstance.getProperties();
        this.files = secInstance.getFiles();
        this.operations = secInstance.getOperations();
        this.mlps = secInstance.getMultiLanguageProperties();
        this.subSECs = secInstance.getSubModelElementCollections();
        try {
            this.semanticKeys = secInstance.getSemanticIdentifier().getKeys();
        }
        catch (NullPointerException nullPointerException) {
            logger.error("Null Pointer Exception in Semantic ID Declaration while initialising " + this.getClass().getSimpleName());
        }
        logger.info("SECGenerator Initialised for the SubModelElementCollection : " + secInstance.getIdShort());
        if (secInstance.getParentSEC() != null) {
            this.parent = secInstance.getParentSEC().getIdShort();
        } else if (secInstance.getParentSub() != null) {
            this.parent = secInstance.getParentSub().getIdShort();
        } else {
            logger.error("SubModelElementCollection: " + secInstance.getIdShort() + "has no Parent defined");
        }
    }

    public String generateSubModelElementCollection() {
        String secText = "";
        String propText = "";
        String fileText = "";
        String opText = "";
        String multiLangPropText = "";
        String subSECText = "";
        secText = "\t\tSubmodelElementCollection " + this.parent + "_" + this.secInstance.getIdShort() + " = new SubmodelElementCollection();\r\n" + "\t\tCollection<ISubmodelElement> " + this.parent + "_" + this.secInstance.getIdShort() + "value = new ArrayList<ISubmodelElement>();\r\n" + "\t\t" + this.parent + "_" + this.secInstance.getIdShort() + ".setIdShort(\"" + this.secInstance.getIdShort() + "\");\r\n" + this.generateDuplicateInfo() + this.generateOrderedInfo() + this.generateModelingInfo() + this.generateParentalRelation() + this.generateSemanticReference() + this.generateValueDelegates() + "\r\n\r\n";
        if (this.secInstance.isDynamic()) {
            logger.info("SubmodelElementCollection Code generated for Dynamic SubmodelElementCollection: " + this.secInstance.getIdShort());
            return secText;
        }
        if (this.properties != null) {
            for (Property property : this.properties) {
                PropertyGenerator propGen = new PropertyGenerator(property);
                propText = String.valueOf(propText) + propGen.generateProperty();
            }
        } else {
            propText = String.valueOf(propText);
        }
        if (this.files != null) {
            for (File file : this.files) {
                FileGenerator fileGen = new FileGenerator(file);
                fileText = String.valueOf(fileText) + fileGen.generateFile();
            }
        } else {
            fileText = String.valueOf(fileText);
        }
        if (this.operations != null) {
            for (Operation operation : this.operations) {
                OperationGenerator opGen = new OperationGenerator(operation);
                opText = String.valueOf(opText) + opGen.generateOperation();
            }
        } else {
            opText = String.valueOf(opText);
        }
        if (this.mlps != null) {
            for (MultiLanguageProperty mlp : this.mlps) {
                MLPGenerator mlpGen = new MLPGenerator(mlp);
                multiLangPropText = String.valueOf(multiLangPropText) + mlpGen.generateMultiLanguageProperty();
            }
        } else {
            multiLangPropText = String.valueOf(multiLangPropText);
        }
        if (this.subSECs != null) {
            for (SubModelElementCollection subSEC : this.subSECs) {
                SECGenerator secGen = new SECGenerator(subSEC);
                subSECText = String.valueOf(subSECText) + secGen.generateSubModelElementCollection();
            }
        } else {
            subSECText = String.valueOf(subSECText);
        }
        secText = String.valueOf(secText) + subSECText + opText + propText + fileText + multiLangPropText + this.generateSetValue();
        logger.info("SubmodelElementCollection Code generated for Non-Dynamic SubmodelElementCollection: " + this.secInstance.getIdShort());
        return secText;
    }

    private String generateModelingInfo() {
        String setKind = "     \t" + this.parent + "_" + this.secInstance.getIdShort() + ".setKind(ModelingKind." + this.secInstance.getKind() + ");\r\n";
        return setKind;
    }

    private String generateDuplicateInfo() {
        String setAllowDuplicates = "\t\t" + this.parent + "_" + this.secInstance.getIdShort() + ".setAllowDuplicates(" + this.secInstance.getAllowDuplicates() + ");\r\n";
        return setAllowDuplicates;
    }

    private String generateOrderedInfo() {
        String setOrdered = "\t\t" + this.parent + "_" + this.secInstance.getIdShort() + ".setOrdered(" + this.secInstance.getOrdered() + ");\r\n";
        return setOrdered;
    }

    private String generateSetValue() {
        String comment4SetValue = "\t\t// Adding the SubmodelElements that belong to SubmodelElementCollection - " + this.secInstance.getIdShort() + ". \r\n";
        String parentQualifiedName = String.valueOf(this.parent) + "_" + this.secInstance.getIdShort();
        String valueQualifiedName = String.valueOf(parentQualifiedName) + "value";
        String setValue = "\t\t" + parentQualifiedName + ".setElements(" + valueQualifiedName + ".stream().collect(Collectors.toMap(ISubmodelElement::getIdShort, Function.identity())));\r\n \r\n";
        return String.valueOf(comment4SetValue) + setValue;
    }

    private String generateParentalRelation() {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        boolean isSubModelSEC = true;
        if (stackTraceElements[3].getMethodName() == "generateSubModelElementCollection") {
            isSubModelSEC = false;
        }
        String addSEC = "";
        if (isSubModelSEC) {
            addSEC = "\t\taddSubmodelElement(" + this.parent + "_" + this.secInstance.getIdShort() + ");\r\n";
        } else {
            SubModelElementCollection parentSEC = this.secInstance.getParentSEC();
            String immediateParent = "";
            if (parentSEC.getParentSEC() != null) {
                immediateParent = parentSEC.getParentSEC().getIdShort();
            } else if (parentSEC.getParentSub() != null) {
                immediateParent = parentSEC.getParentSub().getIdShort();
            } else {
                logger.error("SubModelElementCollection: " + parentSEC.getIdShort() + "has no Parent defined");
            }
            addSEC = "\t\t" + immediateParent + "_" + parentSEC.getIdShort() + "value.add(" + this.parent + "_" + this.secInstance.getIdShort() + ");\r\n\r\n";
        }
        return addSEC;
    }

    private String generateSemanticReference() {
        String semanticStr = "";
        if (this.semanticKeys != null && this.conceptDesc == null) {
            semanticStr = String.valueOf(semanticStr) + "\t\tList<IKey> " + this.parent + "_" + this.secInstance.getIdShort().toLowerCase() + "Keys= new ArrayList<IKey>();\r\n";
            for (Key key : this.semanticKeys) {
                String basyxKeyElement = FileUtils.removeUnderScore(key.getType().toString());
                semanticStr = String.valueOf(semanticStr) + "\t\t" + this.parent + "_" + this.secInstance.getIdShort().toLowerCase() + "Keys.add(" + "new Key(KeyElements." + basyxKeyElement + ", " + key.isLocal() + ", " + "\"" + key.getValue() + "\"" + ", " + "KeyType." + key.getIdType() + ")); \r\n";
            }
            semanticStr = String.valueOf(semanticStr) + "\t\tReference " + this.parent + "_" + this.secInstance.getIdShort() + "Ref = new Reference(" + this.parent + "_" + this.secInstance.getIdShort().toLowerCase() + "Keys" + ");\r\n" + "\t\t" + this.parent + "_" + this.secInstance.getIdShort() + ".setSemanticId(" + this.parent + "_" + this.secInstance.getIdShort() + "Ref); \r\n \r\n";
            logger.info("Semantic Id reference for SubModelElementCollection: " + this.secInstance.getIdShort() + "generated.");
        } else if (this.conceptDesc != null && this.semanticKeys == null) {
            semanticStr = String.valueOf(semanticStr) + "\t\t" + this.parent + "_" + this.secInstance.getIdShort() + ".setSemanticId(conceptDescriptions." + this.conceptDesc.getIdShort() + ".getReference()); \r\n \r\n";
        } else {
            logger.debug("No Semantic Id reference for SubModelElementCollection: " + this.secInstance.getIdShort() + "found. Thus, not generated.");
        }
        return semanticStr;
    }

    private String generateValueDelegates() {
        String valueDelegate = "";
        String getterCode = "";
        String setterCode = "";
        if (this.secInstance.isDynamic()) {
            valueDelegate = String.valueOf(valueDelegate) + "\t\tValueDelegate<Collection<ISubmodelElement>> valDel" + this.parent + "_" + this.secInstance.getIdShort() + " = ValueDelegate.installOn(" + this.parent + "_" + this.secInstance.getIdShort() + "); \r\n";
            getterCode = String.valueOf(getterCode) + "\t\tvalDel" + this.parent + "_" + this.secInstance.getIdShort() + ".setGetHandler(dew::get_" + this.parent + "_" + this.secInstance.getIdShort() + "); \r\n";
            setterCode = String.valueOf(setterCode);
        }
        valueDelegate = String.valueOf(valueDelegate) + getterCode + setterCode;
        return valueDelegate;
    }
}

