/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.aas;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum IdType implements Enumerator
{
    STRING(0, "String", "String"),
    INTEGER(1, "Integer", "Integer"),
    LONG(2, "Long", "Long"),
    BYTE_ARRAY(3, "ByteArray", "ByteArray"),
    UUID(4, "UUID", "UUID");

    public static final int STRING_VALUE = 0;
    public static final int INTEGER_VALUE = 1;
    public static final int LONG_VALUE = 2;
    public static final int BYTE_ARRAY_VALUE = 3;
    public static final int UUID_VALUE = 4;
    private static final IdType[] VALUES_ARRAY;
    public static final List<IdType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new IdType[]{STRING, INTEGER, LONG, BYTE_ARRAY, UUID};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static IdType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            IdType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static IdType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            IdType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static IdType get(int value) {
        switch (value) {
            case 0: {
                return STRING;
            }
            case 1: {
                return INTEGER;
            }
            case 2: {
                return LONG;
            }
            case 3: {
                return BYTE_ARRAY;
            }
            case 4: {
                return UUID;
            }
        }
        return null;
    }

    private IdType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

