/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.aas.wizards.ui;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.papyrus.aas.wizards.Activator;
import org.eclipse.papyrus.aas.wizards.pages.DummySelectRepresentationKindPage;
import org.eclipse.papyrus.aas.wizards.pages.SelectViewPointPage;
import org.eclipse.papyrus.infra.core.resource.BadArgumentExcetion;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.NotFoundException;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.gmfdiag.common.model.NotationModel;
import org.eclipse.papyrus.infra.gmfdiag.common.model.NotationUtils;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.uml.diagram.wizards.pages.NewModelFilePage;
import org.eclipse.papyrus.uml.diagram.wizards.pages.SelectArchitectureContextPage;
import org.eclipse.papyrus.uml.diagram.wizards.pages.SelectRepresentationKindPage;
import org.eclipse.papyrus.uml.diagram.wizards.wizards.CreateModelWizard;
import org.eclipse.papyrus.uml.tools.model.UmlUtils;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IWorkbench;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.UMLPackage;
import org.osgi.framework.Bundle;

public class NewModelWizardAAS
extends CreateModelWizard {
    private static final String DOT_UML = ".uml";
    private static final String DOT_DI = ".di";
    public static final String MODEL_NAME_UC = "[modelNameUC]";
    public static final String WIZARD_ID = "org.eclipse.papyrus.aas.wizards.createmodel";
    protected SelectViewPointPage selectViewPointPage;
    protected DummySelectRepresentationKindPage selectRepresentationKindPage;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        super.init(workbench, selection);
        this.setWindowTitle("New AAS Model");
        String imagePath = "platform:/plugin/org.eclipse.papyrus.aas.wizards/icons/WizardAAS.gif";
        this.setWindowTitle("New AAS Project");
        this.setDefaultPageImageDescriptor(ImageDescriptor.createFromImage((Image)NewModelWizardAAS.ImageFromPath(imagePath)));
    }

    public void addPage(IWizardPage page) {
        if (page instanceof SelectArchitectureContextPage) {
            this.selectViewPointPage = new SelectViewPointPage();
        } else {
            super.addPage(page);
        }
    }

    protected String[] getSelectedContexts() {
        return new String[]{"org.eclipse.papyrus.aas.ml"};
    }

    protected String getRootElementName() {
        return this.selectRepresentationKindPage.getRootElementName();
    }

    protected String[] getSelectedViewpoints() {
        return this.selectViewPointPage.getSelectedIDs();
    }

    public void setViewpoint(String selectedId) {
        this.selectViewPointPage.setSelectedID(selectedId);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page instanceof SelectViewPointPage) {
            IWizardPage modelPage = this.getPages()[1];
            this.updateExtension();
            return modelPage;
        }
        return super.getNextPage(page);
    }

    protected SelectRepresentationKindPage doCreateSelectRepresentationKindPage() {
        this.selectRepresentationKindPage = new DummySelectRepresentationKindPage(this.createContextProvider());
        return this.selectRepresentationKindPage;
    }

    protected void initDomainModel(ModelSet modelSet, String contextId, String[] viewpointIds) {
        Package root;
        PackageableElement ne;
        super.initDomainModel(modelSet, contextId, viewpointIds);
        Resource umlR = UmlUtils.getUmlResource((ModelSet)modelSet);
        NotationModel notation = NotationUtils.getNotationModel((ModelSet)modelSet);
        try {
            final Diagram diagram = notation.getDiagram(MODEL_NAME_UC);
            if (diagram != null) {
                final String newName = String.valueOf(this.selectRepresentationKindPage.getRootElementName()) + " diagram";
                this.getCommandStack(modelSet).execute((Command)new RecordingCommand(modelSet.getTransactionalEditingDomain()){

                    protected void doExecute() {
                        diagram.setName(newName);
                    }
                });
            }
        }
        catch (NotFoundException newName) {
        }
        catch (BadArgumentExcetion e) {
            System.out.println((Object)e);
        }
        if ((ne = (root = (Package)umlR.getContents().get(0)).getPackagedElement(MODEL_NAME_UC)) != null) {
            String ucFirst = this.selectRepresentationKindPage.getRootElementName();
            SetRequest setRequest = new SetRequest((EObject)ne, (EStructuralFeature)UMLPackage.eINSTANCE.getNamedElement_Name(), (Object)ucFirst);
            ICommand setNameCmd = ElementEditServiceUtils.getCommandProvider((EObject)ne).getEditCommand((IEditCommandRequest)setRequest);
            if (setNameCmd.canExecute()) {
                this.getCommandStack(modelSet).execute(GMFtoEMFCommandWrapper.wrap((ICommand)setNameCmd));
            }
        }
    }

    public String getExtension() {
        String extension = DOT_UML;
        String id = this.selectViewPointPage.getSelectedID();
        return extension.replace(DOT_UML, DOT_DI).substring(1);
    }

    public boolean performFinish() {
        this.selectRepresentationKindPage.selectTemplate(this.selectViewPointPage.getSelectedID());
        this.updateExtension();
        URI newURI = this.createNewModelURI("org.eclipse.papyrus.aas.ml");
        String[] viewpointIds = this.getSelectedViewpoints();
        this.createAndOpenPapyrusModel(newURI, "org.eclipse.papyrus.aas.ml", viewpointIds);
        return true;
    }

    public static Image ImageFromPath(String PathOfImage) {
        Bundle bundl = Activator.getInstance().getBundle();
        URL url = FileLocator.find((Bundle)bundl, (IPath)new Path(PathOfImage), null);
        try {
            url = new URL(PathOfImage);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        ImageDescriptor Descriptor = ImageDescriptor.createFromURL((URL)url);
        return Descriptor.createImage();
    }

    public void updateExtension() {
        String extension = this.getExtension();
        IWizardPage modelPage = this.getPages()[1];
        if (extension != null && modelPage instanceof NewModelFilePage) {
            ((NewModelFilePage)modelPage).diagramExtensionChanged(extension);
        }
    }
}

