/*****************************************************************************
 * Copyright (c) 2019, 2021 CEA LIST.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *  Yupanqui Munoz (CEA LIST) yupanqui.munozjulho@cea.fr - Initial API and implementation
 *  Vincent Lorenzo (CEA LIST) vincent.lorenzo@cea.fr - Initial API and implementation
 *  Vincent Lorenzo (CEA LIST) vincent.lorenzo@cea.fr - bug 563995
 *****************************************************************************/
package org.eclipse.papyrus.model2doc.odt.internal.util;

/**
 * Extension constants.
 */
public final class ExtensionConstants {

	private ExtensionConstants() {
		// to prevent instantiation
	}

	/**
	 * the odt file extension
	 */
	public static final String ODT = "odt";//$NON-NLS-1$

	/**
	 * the PDF file extension
	 */
	public static final String PDF = "pdf"; //$NON-NLS-1$

}
