/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.externalcontrol.semantics;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.papyrus.moka.externalcontrol.advice.IControllerAdvice;
import org.eclipse.papyrus.moka.externalcontrol.controller.AbstractExternallyControlledVisitor;
import org.eclipse.papyrus.moka.externalcontrol.controller.ExternalController;
import org.eclipse.papyrus.moka.externalcontrol.profiling.IExternallyControlledVisitorProfiler;
import org.eclipse.papyrus.moka.fuml.Semantics.Actions.BasicActions.IActionActivation;
import org.eclipse.papyrus.moka.fuml.Semantics.Actions.BasicActions.IPinActivation;
import org.eclipse.papyrus.moka.fuml.Semantics.Activities.IntermediateActivities.IActivityEdgeInstance;
import org.eclipse.papyrus.moka.fuml.Semantics.Activities.IntermediateActivities.IActivityExecution;
import org.eclipse.papyrus.moka.fuml.Semantics.Activities.IntermediateActivities.IActivityNodeActivation;
import org.eclipse.papyrus.moka.fuml.Semantics.Activities.IntermediateActivities.IActivityNodeActivationGroup;
import org.eclipse.papyrus.moka.fuml.Semantics.Activities.IntermediateActivities.IToken;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IBooleanValue;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.ILink;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IObject_;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IValue;
import org.eclipse.papyrus.moka.fuml.Semantics.Loci.LociL1.ILocus;
import org.eclipse.papyrus.moka.fuml.Semantics.Loci.LociL1.ISemanticVisitor;
import org.eclipse.papyrus.moka.fuml.debug.Debug;
import org.eclipse.uml2.uml.Action;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.ConditionalNode;
import org.eclipse.uml2.uml.InputPin;
import org.eclipse.uml2.uml.LoopNode;
import org.eclipse.uml2.uml.OutputPin;
import org.eclipse.uml2.uml.Pin;

public abstract class AbstractExternallyControlledActionActivation<T extends IActionActivation>
extends AbstractExternallyControlledVisitor<T>
implements IActionActivation {
    public AbstractExternallyControlledActionActivation(T visitor, ExternalController controller, List<IControllerAdvice> advices) {
        super(visitor, controller, advices);
    }

    public void fire(List<IToken> incomingTokens) {
        Debug.println((String)("[fire] Action " + this.getNode().getName() + "..."));
        Debug.println((String)("[event] Fire activity=" + this.getActivityExecution().getBehavior().getName() + " action=" + this.getNode().getName()));
        this.suspendedTokens = incomingTokens;
        this.suspendForControl();
        this.suspend();
    }

    public AbstractExternallyControlledVisitor<? extends ISemanticVisitor> getStackParent() {
        IActivityExecution execution = this.getActivityExecution();
        if (execution instanceof AbstractExternallyControlledVisitor) {
            return (AbstractExternallyControlledVisitor)execution;
        }
        return null;
    }

    public void run() {
        ((IActionActivation)this.delegatedVisitor).run();
    }

    public void receiveOffer() {
        Debug.println((String)("[receiveOffer] " + (this.getNode() == null ? "..." : "node = " + this.getNode().getName())));
        AbstractExternallyControlledActionActivation abstractExternallyControlledActionActivation = this;
        IExternallyControlledVisitorProfiler.aspectOf().ajc$before$org_eclipse_papyrus_moka_fuml_profiling_Semantics_Loci_SemanticVisitorProfiler$1$ccbc371e(abstractExternallyControlledActionActivation);
        abstractExternallyControlledActionActivation._beginIsolation();
        boolean ready = this.isReady();
        ArrayList<IToken> tokens = new ArrayList();
        if (ready) {
            Debug.println((String)"[receiveOffer] Firing.");
            tokens = this.takeOfferedTokens();
        }
        AbstractExternallyControlledActionActivation abstractExternallyControlledActionActivation2 = this;
        try {
            abstractExternallyControlledActionActivation2._endIsolation();
        }
        finally {
            IExternallyControlledVisitorProfiler.aspectOf().ajc$after$org_eclipse_papyrus_moka_fuml_profiling_Semantics_Loci_SemanticVisitorProfiler$2$b74c5ed0(abstractExternallyControlledActionActivation2);
        }
        if (ready) {
            this.fire(tokens);
        }
    }

    public List<IToken> takeOfferedTokens() {
        return ((IActionActivation)this.delegatedVisitor).takeOfferedTokens();
    }

    public void sendOffers(List<IToken> tokens) {
        ((IActionActivation)this.delegatedVisitor).sendOffers(tokens);
    }

    public void terminate() {
        ((IActionActivation)this.delegatedVisitor).terminate();
    }

    public Boolean isReady() {
        return ((IActionActivation)this.delegatedVisitor).isReady();
    }

    public Boolean isRunning() {
        return ((IActionActivation)this.delegatedVisitor).isRunning();
    }

    public void addOutgoingEdge(IActivityEdgeInstance edge) {
        edge.setSource((IActivityNodeActivation)this);
        this.getOutgoingEdges().add(edge);
    }

    public void addIncomingEdge(IActivityEdgeInstance edge) {
        edge.setTarget((IActivityNodeActivation)this);
        this.getIncomingEdges().add(edge);
    }

    public void createNodeActivations() {
        Action action = (Action)this.getNode();
        ArrayList<InputPin> inputPinNodes = new ArrayList<InputPin>();
        List<InputPin> inputPins = AbstractExternallyControlledActionActivation.getInputs(action);
        int i = 0;
        while (i < inputPins.size()) {
            InputPin inputPin = inputPins.get(i);
            inputPinNodes.add(inputPin);
            ++i;
        }
        this.getGroup().createNodeActivations(inputPinNodes);
        i = 0;
        while (i < inputPinNodes.size()) {
            ActivityNode node = (ActivityNode)inputPinNodes.get(i);
            this.addPinActivation((IPinActivation)this.getGroup().getNodeActivation(node));
            ++i;
        }
        ArrayList<OutputPin> outputPinNodes = new ArrayList<OutputPin>();
        List<OutputPin> outputPins = AbstractExternallyControlledActionActivation.getOutputs(action);
        int i2 = 0;
        while (i2 < outputPins.size()) {
            OutputPin outputPin = outputPins.get(i2);
            outputPinNodes.add(outputPin);
            ++i2;
        }
        this.getGroup().createNodeActivations(outputPinNodes);
        i2 = 0;
        while (i2 < outputPinNodes.size()) {
            ActivityNode node = (ActivityNode)outputPinNodes.get(i2);
            this.addPinActivation((IPinActivation)this.getGroup().getNodeActivation(node));
            ++i2;
        }
    }

    public void createEdgeInstances() {
        ((IActionActivation)this.delegatedVisitor).createEdgeInstances();
    }

    public Boolean isSourceFor(IActivityEdgeInstance edgeInstance) {
        return ((IActionActivation)this.delegatedVisitor).isSourceFor(edgeInstance);
    }

    public IActivityExecution getActivityExecution() {
        return ((IActionActivation)this.delegatedVisitor).getActivityExecution();
    }

    public IObject_ getExecutionContext() {
        return ((IActionActivation)this.delegatedVisitor).getExecutionContext();
    }

    public ILocus getExecutionLocus() {
        return ((IActionActivation)this.delegatedVisitor).getExecutionLocus();
    }

    public IActivityNodeActivation getNodeActivation(ActivityNode node) {
        AbstractExternallyControlledActionActivation activation = null;
        if (node == this.getNode()) {
            activation = this;
        }
        return activation;
    }

    public void addToken(IToken token) {
        ((IActionActivation)this.delegatedVisitor).addToken(token);
    }

    public Integer removeToken(IToken token) {
        return ((IActionActivation)this.delegatedVisitor).removeToken(token);
    }

    public void addTokens(List<IToken> tokens) {
        ((IActionActivation)this.delegatedVisitor).addTokens(tokens);
    }

    public List<IToken> takeTokens() {
        return ((IActionActivation)this.delegatedVisitor).takeOfferedTokens();
    }

    public void clearTokens() {
        ((IActionActivation)this.delegatedVisitor).clearTokens();
    }

    public List<IToken> getTokens() {
        return ((IActionActivation)this.delegatedVisitor).getTokens();
    }

    public void initialize(ActivityNode node, IActivityNodeActivationGroup group) {
        ((IActionActivation)this.delegatedVisitor).initialize(node, group);
    }

    public void suspend() {
        ((IActionActivation)this.delegatedVisitor).suspend();
    }

    public void resume() {
        ((IActionActivation)this.delegatedVisitor).resume();
    }

    public void setNode(ActivityNode node) {
        ((IActionActivation)this.delegatedVisitor).setNode(node);
    }

    public ActivityNode getNode() {
        return ((IActionActivation)this.delegatedVisitor).getNode();
    }

    public void setGroup(IActivityNodeActivationGroup group) {
        ((IActionActivation)this.delegatedVisitor).setGroup(group);
    }

    public IActivityNodeActivationGroup getGroup() {
        return ((IActionActivation)this.delegatedVisitor).getGroup();
    }

    public List<IActivityEdgeInstance> getIncomingEdges() {
        return ((IActionActivation)this.delegatedVisitor).getIncomingEdges();
    }

    public List<IActivityEdgeInstance> getOutgoingEdges() {
        return ((IActionActivation)this.delegatedVisitor).getOutgoingEdges();
    }

    public void setRunning(Boolean status) {
        ((IActionActivation)this.delegatedVisitor).setRunning(status);
    }

    public void _endIsolation() {
        IActionActivation iActionActivation = (IActionActivation)this.delegatedVisitor;
        try {
            iActionActivation._endIsolation();
        }
        finally {
            IExternallyControlledVisitorProfiler.aspectOf().ajc$after$org_eclipse_papyrus_moka_fuml_profiling_Semantics_Loci_SemanticVisitorProfiler$2$b74c5ed0((ISemanticVisitor)iActionActivation);
        }
    }

    public void _beginIsolation() {
        IActionActivation iActionActivation = (IActionActivation)this.delegatedVisitor;
        IExternallyControlledVisitorProfiler.aspectOf().ajc$before$org_eclipse_papyrus_moka_fuml_profiling_Semantics_Loci_SemanticVisitorProfiler$1$ccbc371e((ISemanticVisitor)iActionActivation);
        iActionActivation._beginIsolation();
    }

    public void doAction() {
        ((IActionActivation)this.delegatedVisitor).doAction();
    }

    public void sendOffers() {
        ((IActionActivation)this.delegatedVisitor).sendOffers();
    }

    public void addPinActivation(IPinActivation pinActivation) {
        ((IActionActivation)this.delegatedVisitor).addPinActivation(pinActivation);
        pinActivation.setActionActivation((IActionActivation)this);
    }

    public IPinActivation getPinActivation(Pin pin) {
        return ((IActionActivation)this.delegatedVisitor).getPinActivation(pin);
    }

    public void putToken(OutputPin pin, IValue value) {
        ((IActionActivation)this.delegatedVisitor).putToken(pin, value);
    }

    public void putTokens(OutputPin pin, List<IValue> values) {
        ((IActionActivation)this.delegatedVisitor).putTokens(pin, values);
    }

    public List<IValue> getTokens(InputPin pin) {
        return ((IActionActivation)this.delegatedVisitor).getTokens(pin);
    }

    public List<IValue> takeTokens(InputPin pin) {
        return ((IActionActivation)this.delegatedVisitor).takeTokens(pin);
    }

    public Boolean valueParticipatesInLink(IValue value, ILink link) {
        return ((IActionActivation)this.delegatedVisitor).valueParticipatesInLink(value, link);
    }

    public IBooleanValue makeBooleanValue(Boolean value) {
        return ((IActionActivation)this.delegatedVisitor).makeBooleanValue(value);
    }

    protected static List<InputPin> getInputs(Action action) {
        return action instanceof LoopNode ? ((LoopNode)action).getLoopVariableInputs() : action.getInputs();
    }

    protected static List<OutputPin> getOutputs(Action action) {
        return action instanceof LoopNode ? ((LoopNode)action).getResults() : (action instanceof ConditionalNode ? ((ConditionalNode)action).getResults() : action.getOutputs());
    }
}

