/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.ui.launch;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.papyrus.moka.ui.launch.MokaUMLComboBox;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.AssociationClass;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Node;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.Stereotype;

public class MokaTriggerComboPopulation
implements ModifyListener {
    protected transient MokaUMLComboBox list;

    public MokaTriggerComboPopulation(MokaUMLComboBox combo) {
        this.list = combo;
    }

    public void modifyText(ModifyEvent e) {
        ArrayList<NamedElement> namedElements = new ArrayList<NamedElement>();
        this.list.removeAll();
        Text text = (Text)e.widget;
        URI projectUri = URI.createURI((String)text.getText());
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.getResource(projectUri, true);
        TreeIterator contentIterator = resource.getAllContents();
        while (contentIterator.hasNext()) {
            EObject eObject = (EObject)contentIterator.next();
            if (eObject instanceof Behavior) {
                if (!(eObject instanceof Activity) && !(eObject instanceof OpaqueBehavior) && !(eObject instanceof StateMachine)) continue;
                namedElements.add((NamedElement)eObject);
                continue;
            }
            if (eObject instanceof Class) {
                if (eObject instanceof Node && eObject instanceof Stereotype && eObject instanceof AssociationClass) continue;
                namedElements.add((NamedElement)eObject);
                continue;
            }
            if (!(eObject instanceof InstanceSpecification)) continue;
            namedElements.add((NamedElement)eObject);
        }
        Comparator<NamedElement> comp = new Comparator<NamedElement>(){

            @Override
            public int compare(NamedElement o1, NamedElement o2) {
                String s1 = MokaTriggerComboPopulation.this.list.generateLabel(o1);
                String s2 = MokaTriggerComboPopulation.this.list.generateLabel(o2);
                return s1.compareTo(s2);
            }
        };
        Collections.sort(namedElements, comp);
        for (NamedElement n : namedElements) {
            this.list.add(n);
        }
        this.list.selectFirst();
    }
}

