/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.animation.engine.rendering;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.infra.services.markerlistener.IPapyrusMarker;
import org.eclipse.papyrus.infra.services.markerlistener.PapyrusMarkerAdapter;
import org.eclipse.papyrus.moka.animation.engine.rendering.AnimationKind;
import org.eclipse.papyrus.moka.animation.engine.rendering.DiagramHandler;
import org.eclipse.papyrus.moka.animation.engine.rendering.IRenderingEngine;
import org.eclipse.papyrus.moka.animation.utils.AnimationUtils;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IObject_;
import org.eclipse.papyrus.moka.utils.constants.MokaConstants;

public class AnimationEngine
implements IRenderingEngine {
    protected DiagramHandler diagramManager;
    protected Map<EObject, List<IPapyrusMarker>> modelElementMarkers = new HashMap<EObject, List<IPapyrusMarker>>();
    protected boolean isReady = false;

    public AnimationEngine() {
        this.diagramManager = new DiagramHandler();
        this.modelElementMarkers = new HashMap<EObject, List<IPapyrusMarker>>();
    }

    private boolean hasMarker(EObject modelElement, AnimationKind kind) {
        if (modelElement == null) {
            return false;
        }
        List<IPapyrusMarker> markers = this.modelElementMarkers.get(modelElement);
        if (markers == null || markers.isEmpty()) {
            return false;
        }
        boolean found = false;
        int i = 0;
        while (!found && i < markers.size()) {
            IPapyrusMarker marker = markers.get(i);
            String type = "";
            try {
                type = marker.getType();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            if (kind == AnimationKind.ANIMATED) {
                found = type.equals(AnimationUtils.ANIMATED_MARKER_ID);
            } else if (kind == AnimationKind.SUSPENDED) {
                found = type.equals(AnimationUtils.SUSPENDED_MARKER_ID);
            } else if (kind == AnimationKind.VISITED) {
                found = type.equals(AnimationUtils.VISITED_MARKER_ID);
            }
            ++i;
        }
        return found;
    }

    private IPapyrusMarker createMarker(EObject modelElement, String markerID, Map attributes) {
        PapyrusMarkerAdapter marker = null;
        if (modelElement == null || modelElement.eResource() == null) {
            return null;
        }
        String uri = EcoreUtil.getURI((EObject)modelElement).toString();
        if (uri == null || uri.isEmpty()) {
            return null;
        }
        IResource resource = this.getWorkspaceResource(modelElement);
        if (resource != null && resource.exists()) {
            IMarker newMarker = null;
            try {
                newMarker = resource.createMarker(markerID);
                newMarker.setAttributes(attributes);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            if (newMarker != null) {
                marker = PapyrusMarkerAdapter.wrap((Resource)modelElement.eResource(), (IMarker)newMarker, (Map)attributes);
            }
        }
        return marker;
    }

    private IPapyrusMarker deleteMarker(EObject modelElement, AnimationKind kind) {
        List<IPapyrusMarker> markers = this.modelElementMarkers.get(modelElement);
        Iterator<IPapyrusMarker> markersIterator = markers.iterator();
        IPapyrusMarker deletedMarker = null;
        while (deletedMarker == null && markersIterator.hasNext()) {
            IPapyrusMarker currentMarker = markersIterator.next();
            String markerType = "";
            try {
                markerType = currentMarker.getType();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            if (kind == AnimationKind.ANIMATED) {
                deletedMarker = markerType.equals(AnimationUtils.ANIMATED_MARKER_ID) ? currentMarker : null;
                continue;
            }
            if (kind == AnimationKind.SUSPENDED) {
                deletedMarker = markerType.equals(AnimationUtils.SUSPENDED_MARKER_ID) ? currentMarker : null;
                continue;
            }
            if (kind != AnimationKind.VISITED) continue;
            Object object = deletedMarker = markerType.equals(AnimationUtils.VISITED_MARKER_ID) ? currentMarker : null;
        }
        if (deletedMarker != null) {
            try {
                deletedMarker.delete();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return deletedMarker;
    }

    private IResource getWorkspaceResource(EObject modelElement) {
        IFile resource = null;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace != null) {
            resource = workspace.getRoot().getFile((IPath)new Path(modelElement.eResource().getURI().toPlatformString(true)));
        }
        return resource;
    }

    public void init(EObject modelElement) {
        this.diagramManager.init(modelElement);
    }

    protected void preRendering(EObject modelElement) {
        if (MokaConstants.MOKA_OPEN_DIAGRAM_IN_AUTOMATIC_ANIMATION && !this.diagramManager.hasOpenedDiagram(modelElement)) {
            this.diagramManager.openDiagrams(modelElement);
        }
    }

    @Override
    public synchronized void startRendering(EObject modelElement, IObject_ animator, AnimationKind animationKind) {
        if (!this.isReady) {
            this.diagramManager.init(modelElement);
            this.isReady = true;
        }
        if (modelElement != null && this.isRenderable(modelElement, animator)) {
            this.preRendering(modelElement);
            IPapyrusMarker requestedMarker = null;
            if (!this.hasMarker(modelElement, animationKind)) {
                HashMap<String, Object> attributes = new HashMap<String, Object>();
                attributes.put("uri", EcoreUtil.getURI((EObject)modelElement).toString());
                attributes.put("CONSTRAINTS", this.diagramManager.getAnimatedDiagrams(animator));
                if (animationKind.equals((Object)AnimationKind.ANIMATED)) {
                    requestedMarker = this.createMarker(modelElement, AnimationUtils.ANIMATED_MARKER_ID, attributes);
                } else if (animationKind.equals((Object)AnimationKind.SUSPENDED)) {
                    requestedMarker = this.createMarker(modelElement, AnimationUtils.SUSPENDED_MARKER_ID, attributes);
                } else if (animationKind.equals((Object)AnimationKind.VISITED)) {
                    requestedMarker = this.createMarker(modelElement, AnimationUtils.VISITED_MARKER_ID, attributes);
                } else {
                    System.err.println("[startRendering] - animation kind not recognized");
                }
                List<IPapyrusMarker> markerList = this.modelElementMarkers.get(modelElement);
                if (markerList == null) {
                    markerList = new ArrayList<IPapyrusMarker>();
                    this.modelElementMarkers.put(modelElement, markerList);
                }
                if (requestedMarker != null) {
                    markerList.add(requestedMarker);
                }
            }
        }
    }

    @Override
    public synchronized void stopRendering(EObject modelElement, IObject_ animator, AnimationKind kind) {
        IPapyrusMarker marker;
        if (!this.isReady) {
            this.diagramManager.init(modelElement);
            this.isReady = true;
        }
        if (modelElement != null && this.isRenderable(modelElement, animator) && this.hasMarker(modelElement, kind) && (marker = this.deleteMarker(modelElement, kind)) != null) {
            this.modelElementMarkers.get(modelElement).remove(marker);
        }
    }

    public boolean isRenderable(EObject modelElement, IObject_ animator) {
        return MokaConstants.MOKA_AUTOMATIC_ANIMATION && this.diagramManager.isRenderable(modelElement);
    }

    public void deleteAllMarkers() {
        for (EObject modelElement : this.modelElementMarkers.keySet()) {
            for (IPapyrusMarker marker : this.modelElementMarkers.get(modelElement)) {
                if (!marker.exists()) continue;
                try {
                    marker.delete();
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            this.modelElementMarkers.get(modelElement).clear();
        }
        this.modelElementMarkers.clear();
    }

    public synchronized void clean() {
        this.deleteAllMarkers();
        this.diagramManager.clean();
    }

    public DiagramHandler getDiagramHandler() {
        return this.diagramManager;
    }

    @Override
    public boolean isRenderingRuleApplied(EObject modelElement, AnimationKind kind) {
        return this.hasMarker(modelElement, kind);
    }

    @Override
    public void removeRenderingRules(EObject modelElement) {
        if (this.modelElementMarkers.get(modelElement) != null) {
            for (IPapyrusMarker marker : this.modelElementMarkers.get(modelElement)) {
                if (!marker.exists()) continue;
                try {
                    marker.delete();
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            this.modelElementMarkers.get(modelElement).clear();
        }
    }
}

