/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.fmi.fmiprofile;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum VariabilityNamingConvention implements Enumerator
{
    FLAT(0, "flat", "flat"),
    STRUCTURED(1, "structured", "structured");

    public static final int FLAT_VALUE = 0;
    public static final int STRUCTURED_VALUE = 1;
    private static final VariabilityNamingConvention[] VALUES_ARRAY;
    public static final List<VariabilityNamingConvention> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new VariabilityNamingConvention[]{FLAT, STRUCTURED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static VariabilityNamingConvention get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            VariabilityNamingConvention result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static VariabilityNamingConvention getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            VariabilityNamingConvention result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static VariabilityNamingConvention get(int value) {
        switch (value) {
            case 0: {
                return FLAT;
            }
            case 1: {
                return STRUCTURED;
            }
        }
        return null;
    }

    private VariabilityNamingConvention(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

