/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.fmi.ui.dnd;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.papyrus.infra.gmfdiag.dnd.strategy.TransactionalDropStrategy;
import org.eclipse.papyrus.moka.fmi.profile.util.FMIProfileUtil;
import org.eclipse.papyrus.moka.fmi.ui.commands.DropFMUAsPartCommand;
import org.eclipse.swt.graphics.Image;
import org.eclipse.uml2.uml.Class;

public class FMUToPartDropStrategy
extends TransactionalDropStrategy {
    public String getLabel() {
        return "Drop an FMU as composite part";
    }

    public String getDescription() {
        return "Drop an FMU stereotyped Class into a composite structure. It automatically places input ports on the left and output ports on the right";
    }

    public Image getImage() {
        return null;
    }

    public String getID() {
        return "org.eclipse.papyrus.moka.fmi.ui.component2part";
    }

    protected Command doGetCommand(Request request, EditPart targetEditPart) {
        if (!(request instanceof DropObjectsRequest)) {
            return null;
        }
        DropObjectsRequest dropRequest = (DropObjectsRequest)request;
        EObject targetSemanticElement = this.getTargetSemanticElement(targetEditPart);
        if (targetSemanticElement instanceof Class && dropRequest.getLocation() != null && targetEditPart instanceof GraphicalEditPart) {
            GraphicalEditPart targetGraphicalEditPart = (GraphicalEditPart)targetEditPart;
            Class targetSimulator = (Class)targetSemanticElement;
            List sourceElements = this.getSourceEObjects(request);
            if (sourceElements.size() != 1) {
                return null;
            }
            EObject sourceElement = (EObject)sourceElements.get(0);
            if (sourceElement instanceof Class && FMIProfileUtil.isFMU((Class)((Class)sourceElement)).booleanValue()) {
                Class sourceType = (Class)sourceElement;
                ICommandProxy resultCommand = new ICommandProxy((ICommand)new DropFMUAsPartCommand(dropRequest, this.getTransactionalEditingDomain((EditPart)targetGraphicalEditPart), targetSimulator, sourceType, targetGraphicalEditPart, this.getTargetView((EditPart)targetGraphicalEditPart)));
                return resultCommand;
            }
        }
        return null;
    }

    public int getPriority() {
        return 0;
    }
}

