/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.fmi.modeldescription;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum VariableNamingConventionType implements Enumerator
{
    FLAT(0, "flat", "flat"),
    STRUCTURED(1, "structured", "structured");

    public static final int FLAT_VALUE = 0;
    public static final int STRUCTURED_VALUE = 1;
    private static final VariableNamingConventionType[] VALUES_ARRAY;
    public static final List<VariableNamingConventionType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new VariableNamingConventionType[]{FLAT, STRUCTURED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static VariableNamingConventionType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            VariableNamingConventionType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static VariableNamingConventionType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            VariableNamingConventionType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static VariableNamingConventionType get(int value) {
        switch (value) {
            case 0: {
                return FLAT;
            }
            case 1: {
                return STRUCTURED;
            }
        }
        return null;
    }

    private VariableNamingConventionType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

