/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.fmu.engine.control;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.Semaphore;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.moka.discreteevent.DEScheduler;
import org.eclipse.papyrus.moka.discreteevent.Event;
import org.eclipse.papyrus.moka.discreteevent.actions.Action;
import org.eclipse.papyrus.moka.fmu.communication.FMUInterface;
import org.eclipse.papyrus.moka.fmu.engine.control.EngineStatus;
import org.eclipse.papyrus.moka.fmu.engine.de.FMUStepEnd;
import org.eclipse.papyrus.moka.fmu.engine.semantics.FMUObject;
import org.eclipse.papyrus.moka.fmu.engine.utils.FMUEngineUtils;
import org.eclipse.papyrus.moka.service.AbstractMokaService;
import org.eclipse.uml2.uml.Class;

public class FMUControlService
extends AbstractMokaService
implements FMUInterface {
    protected FMUObject fmuObject;
    protected Class fmuClass;
    protected Semaphore instantiationLock = new Semaphore(0);
    protected Semaphore stepLock = new Semaphore(0);
    protected Semaphore engineLock = new Semaphore(0);
    protected Semaphore terminationLock = new Semaphore(0);
    protected EngineStatus engineStatus = EngineStatus.NOT_STARTED;

    public EngineStatus getEngineStatus() {
        return this.engineStatus;
    }

    public void init(ILaunch launcher, EObject modelElement) {
        this.fmuClass = (Class)modelElement;
        this.instantiationLock = new Semaphore(0);
        this.stepLock = new Semaphore(0);
        this.engineLock = new Semaphore(0);
        this.terminationLock = new Semaphore(0);
        FMUEngineUtils.setFMUControlService(this);
    }

    public FMUObject getFmuObject() {
        return this.fmuObject;
    }

    public void setFmuObject(FMUObject fmuObject) {
        this.fmuObject = fmuObject;
    }

    public Class getFmuClass() {
        return this.fmuClass;
    }

    public void setFmuClass(Class fmuClass) {
        this.fmuClass = fmuClass;
    }

    public Semaphore getInstantiationLock() {
        return this.instantiationLock;
    }

    public Semaphore getStepLock() {
        return this.stepLock;
    }

    public Semaphore getEngineLock() {
        return this.engineLock;
    }

    public Semaphore getTerminationLock() {
        return this.terminationLock;
    }

    @Override
    public void init() {
        this.engineStatus = EngineStatus.INIT;
        this.fmuObject.init();
        this.fmuObject.startBehavior(this.fmuClass, new ArrayList());
        FMUStepEnd stepEnd = new FMUStepEnd();
        DEScheduler.getInstance().pushEvent(new Event(0.0, (Action)stepEnd));
        Runnable deSchedulerRunnable = new Runnable(){

            @Override
            public void run() {
                DEScheduler.getInstance().run();
            }
        };
        Thread deSchedulerThread = new Thread(deSchedulerRunnable);
        deSchedulerThread.start();
        try {
            this.stepLock.acquire();
        }
        catch (InterruptedException interruptedException) {}
        System.out.println("here");
    }

    @Override
    public void doStep(double currentCommunicationTime, double stepSize) {
        this.engineStatus = EngineStatus.STEPPING;
        FMUStepEnd stepEnd = new FMUStepEnd();
        DEScheduler.getInstance().pushEvent(new Event(stepSize, (Action)stepEnd), currentCommunicationTime + stepSize);
        this.engineLock.release();
        try {
            this.stepLock.acquire();
        }
        catch (InterruptedException interruptedException) {}
    }

    @Override
    public void terminate() {
        this.engineLock.release();
        this.stepLock.release();
        this.terminationLock.release();
    }

    public void waitForTermination() {
        try {
            this.terminationLock.acquire();
        }
        catch (InterruptedException interruptedException) {}
    }

    @Override
    public void updateMaps() {
        this.fmuObject.updateMaps();
    }

    @Override
    public Map<Integer, Double> fmiGetReals() {
        return this.fmuObject.fmiGetReals();
    }

    @Override
    public Map<Integer, Integer> fmiGetIntegers() {
        return this.fmuObject.fmiGetIntegers();
    }

    @Override
    public Map<Integer, Boolean> fmiGetBools() {
        return this.fmuObject.fmiGetBools();
    }

    @Override
    public Map<Integer, String> fmiGetStrings() {
        return this.fmuObject.fmiGetStrings();
    }

    @Override
    public void fmiSetReals(Map<Integer, Double> realsMap) {
        this.fmuObject.fmiSetReals(realsMap);
    }

    @Override
    public void fmiSetIntegers(Map<Integer, Integer> integersMap) {
        this.fmuObject.fmiSetIntegers(integersMap);
    }

    @Override
    public void fmiSetBools(Map<Integer, Boolean> boolsMap) {
        this.fmuObject.fmiSetBools(boolsMap);
    }

    @Override
    public void fmiSetStrings(Map<Integer, String> stringsMap) {
        this.fmuObject.fmiSetStrings(stringsMap);
    }
}

