/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.simex.utils;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.papyrus.moka.simex.utils.RequestUtils;
import org.eclipse.papyrus.moka.simex.utils.UMLPrimitiveTypesUtils;
import org.eclipse.papyrus.uml.service.types.element.UMLElementTypes;
import org.eclipse.uml2.uml.AcceptCallAction;
import org.eclipse.uml2.uml.AcceptEventAction;
import org.eclipse.uml2.uml.Action;
import org.eclipse.uml2.uml.AddStructuralFeatureValueAction;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.BroadcastSignalAction;
import org.eclipse.uml2.uml.CallBehaviorAction;
import org.eclipse.uml2.uml.CallEvent;
import org.eclipse.uml2.uml.CallOperationAction;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.ClearAssociationAction;
import org.eclipse.uml2.uml.ClearStructuralFeatureAction;
import org.eclipse.uml2.uml.CreateLinkAction;
import org.eclipse.uml2.uml.CreateObjectAction;
import org.eclipse.uml2.uml.DestroyLinkAction;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Event;
import org.eclipse.uml2.uml.InputPin;
import org.eclipse.uml2.uml.InvocationAction;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.OutputPin;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterableElement;
import org.eclipse.uml2.uml.Pin;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.ReadExtentAction;
import org.eclipse.uml2.uml.ReadIsClassifiedObjectAction;
import org.eclipse.uml2.uml.ReadLinkAction;
import org.eclipse.uml2.uml.ReadStructuralFeatureAction;
import org.eclipse.uml2.uml.ReduceAction;
import org.eclipse.uml2.uml.SendSignalAction;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.SignalEvent;
import org.eclipse.uml2.uml.StructuralFeature;
import org.eclipse.uml2.uml.Trigger;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.TypedElement;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.UnmarshallAction;
import org.eclipse.uml2.uml.ValueSpecification;

public class PinUtils {
    public static void updateCallOperationActionPins(CallOperationAction callOperationAction) {
        Operation operation = callOperationAction.getOperation();
        if (operation != null) {
            PinUtils.updateTargetPin((InvocationAction)callOperationAction, PinUtils.getTargetPinTheoriticalType(callOperationAction));
            PinUtils.alignPinsWithTypedElements((EObject)callOperationAction, (List<? extends TypedElement>)operation.inputParameters(), (List<? extends Pin>)callOperationAction.getArguments(), UMLElementTypes.INPUT_PIN, UMLPackage.eINSTANCE.getInvocationAction_Argument());
            PinUtils.alignPinsWithTypedElements((EObject)callOperationAction, (List<? extends TypedElement>)operation.outputParameters(), (List<? extends Pin>)callOperationAction.getResults(), UMLElementTypes.OUTPUT_PIN, UMLPackage.eINSTANCE.getCallAction_Result());
        }
    }

    public static void updateCallBehaviorActionPins(CallBehaviorAction callBehaviorAction) {
        Behavior behavior = callBehaviorAction.getBehavior();
        if (behavior != null) {
            PinUtils.alignPinsWithTypedElements((EObject)callBehaviorAction, (List<? extends TypedElement>)behavior.inputParameters(), (List<? extends Pin>)callBehaviorAction.getArguments(), UMLElementTypes.INPUT_PIN, UMLPackage.eINSTANCE.getInvocationAction_Argument());
            PinUtils.alignPinsWithTypedElements((EObject)callBehaviorAction, (List<? extends TypedElement>)behavior.outputParameters(), (List<? extends Pin>)callBehaviorAction.getResults(), UMLElementTypes.OUTPUT_PIN, UMLPackage.eINSTANCE.getCallAction_Result());
        }
    }

    public static void updateSendSignalActionPins(SendSignalAction sendSignalAction) {
        PinUtils.updateTargetPin((InvocationAction)sendSignalAction, PinUtils.getTargetPinTheoriticalType(sendSignalAction));
        Signal signal = sendSignalAction.getSignal();
        if (signal != null) {
            PinUtils.alignPinsWithTypedElements((EObject)sendSignalAction, (List<? extends TypedElement>)signal.allAttributes(), (List<? extends Pin>)sendSignalAction.getArguments(), UMLElementTypes.INPUT_PIN, UMLPackage.eINSTANCE.getInvocationAction_Argument());
        }
    }

    public static void updateBroadcastSignalActionPins(BroadcastSignalAction braodCastSignalAction) {
        Signal signal = braodCastSignalAction.getSignal();
        if (signal != null) {
            PinUtils.alignPinsWithTypedElements((EObject)braodCastSignalAction, (List<? extends TypedElement>)signal.allAttributes(), (List<? extends Pin>)braodCastSignalAction.getArguments(), UMLElementTypes.INPUT_PIN, UMLPackage.eINSTANCE.getInvocationAction_Argument());
        }
    }

    public static void updateAcceptEventActionPins(AcceptEventAction acceptEventAction) {
        if (acceptEventAction.isUnmarshall() && !acceptEventAction.getTriggers().isEmpty()) {
            Signal signal;
            Trigger firstTrigger = (Trigger)acceptEventAction.getTriggers().get(0);
            Event event = firstTrigger.getEvent();
            if (event instanceof SignalEvent && (signal = ((SignalEvent)event).getSignal()) != null) {
                PinUtils.alignPinsWithTypedElements((EObject)acceptEventAction, (List<? extends TypedElement>)signal.allAttributes(), (List<? extends Pin>)acceptEventAction.getResults(), UMLElementTypes.OUTPUT_PIN, UMLPackage.eINSTANCE.getAcceptEventAction_Result());
            }
        } else if (acceptEventAction.getResults().isEmpty()) {
            OutputPin result = (OutputPin)RequestUtils.createElementWithRequest((EObject)acceptEventAction, (IElementType)UMLElementTypes.OUTPUT_PIN, UMLPackage.eINSTANCE.getAcceptEventAction_Result());
            result.setName("result");
        } else {
            OutputPin result = (OutputPin)acceptEventAction.getResults().get(0);
            result.setName("result");
            result.setType(null);
            PinUtils.destroyObjectsAfterIndex((List<? extends EObject>)acceptEventAction.getResults(), 1);
        }
    }

    public static void updateAcceptCallActionPins(AcceptCallAction acceptAction) {
        CallEvent event;
        Operation operation;
        Trigger trigger;
        PinUtils.getOrCreatePin((Action)acceptAction, UMLElementTypes.OUTPUT_PIN, UMLPackage.eINSTANCE.getAcceptCallAction_ReturnInformation(), "returnInformation");
        if (!acceptAction.getTriggers().isEmpty() && (trigger = (Trigger)acceptAction.getTriggers().get(0)).getEvent() instanceof CallEvent && (operation = (event = (CallEvent)trigger.getEvent()).getOperation()) != null) {
            PinUtils.alignPinsWithTypedElements((EObject)acceptAction, (List<? extends TypedElement>)operation.inputParameters(), (List<? extends Pin>)acceptAction.getResults(), UMLElementTypes.OUTPUT_PIN, UMLPackage.eINSTANCE.getAcceptEventAction_Result());
        }
    }

    public static void updateReadStructuralFeatureActionPins(ReadStructuralFeatureAction readAction) {
        InputPin object = (InputPin)PinUtils.getOrCreatePin((Action)readAction, UMLElementTypes.INPUT_PIN, UMLPackage.eINSTANCE.getStructuralFeatureAction_Object(), "object");
        OutputPin result = (OutputPin)PinUtils.getOrCreatePin((Action)readAction, UMLElementTypes.OUTPUT_PIN, UMLPackage.eINSTANCE.getReadStructuralFeatureAction_Result(), "result");
        StructuralFeature feature = readAction.getStructuralFeature();
        if (feature != null) {
            PinUtils.alignTypeIfNotCompatible((Pin)object, (Type)feature.getOwner());
            PinUtils.alignPinWithTypedElement((Pin)result, (TypedElement)feature);
        }
    }

    public static void updateAddStructuralFeatureActionPins(AddStructuralFeatureValueAction addAction) {
        InputPin object = (InputPin)PinUtils.getOrCreatePin((Action)addAction, UMLElementTypes.INPUT_PIN, UMLPackage.eINSTANCE.getStructuralFeatureAction_Object(), "object");
        OutputPin result = (OutputPin)PinUtils.getOrCreatePin((Action)addAction, UMLElementTypes.OUTPUT_PIN, UMLPackage.eINSTANCE.getWriteStructuralFeatureAction_Result(), "result");
        InputPin value = (InputPin)PinUtils.getOrCreatePin((Action)addAction, UMLElementTypes.INPUT_PIN, UMLPackage.eINSTANCE.getWriteStructuralFeatureAction_Value(), "value");
        StructuralFeature feature = addAction.getStructuralFeature();
        if (feature != null) {
            PinUtils.alignTypeIfNotCompatible((Pin)object, (Type)feature.getOwner());
            PinUtils.alignTypeIfNotCompatible((Pin)result, (Type)feature.getOwner());
            PinUtils.alignTypeIfNotCompatible((Pin)value, feature.getType());
            if (feature.isOrdered()) {
                InputPin insertAt = (InputPin)PinUtils.getOrCreatePin((Action)addAction, UMLElementTypes.INPUT_PIN, UMLPackage.eINSTANCE.getAddStructuralFeatureValueAction_InsertAt(), "insertAt");
                if (insertAt.getType() == null) {
                    insertAt.setType(UMLPrimitiveTypesUtils.getUnlimitedNatural((Element)addAction));
                }
            } else {
                PinUtils.destroyIfExists((EObject)addAction.getInsertAt());
            }
        }
    }

    public static void updateClearStructuralFeatureActionPins(ClearStructuralFeatureAction clearAction) {
        InputPin object = (InputPin)PinUtils.getOrCreatePin((Action)clearAction, UMLElementTypes.INPUT_PIN, UMLPackage.eINSTANCE.getStructuralFeatureAction_Object(), "object");
        OutputPin result = (OutputPin)PinUtils.getOrCreatePin((Action)clearAction, UMLElementTypes.OUTPUT_PIN, UMLPackage.eINSTANCE.getClearStructuralFeatureAction_Result(), "result");
        StructuralFeature feature = clearAction.getStructuralFeature();
        if (feature != null) {
            PinUtils.alignTypeIfNotCompatible((Pin)object, (Type)feature.getOwner());
            PinUtils.alignTypeIfNotCompatible((Pin)result, (Type)feature.getOwner());
        }
    }

    public static void updateUnmarshallActionPins(UnmarshallAction action) {
        InputPin object = (InputPin)PinUtils.getOrCreatePin((Action)action, UMLElementTypes.INPUT_PIN, UMLPackage.eINSTANCE.getUnmarshallAction_Object(), "object");
        Classifier unmarchallType = action.getUnmarshallType();
        if (unmarchallType != null) {
            PinUtils.alignTypeIfNotCompatible((Pin)object, (Type)unmarchallType);
            PinUtils.alignPinsWithTypedElements((EObject)action, (List<? extends TypedElement>)unmarchallType.allAttributes(), (List<? extends Pin>)action.getResults(), UMLElementTypes.OUTPUT_PIN, UMLPackage.eINSTANCE.getUnmarshallAction_Result());
        }
    }

    public static void updateReadIsClassifiedObjectAction(ReadIsClassifiedObjectAction action) {
        PinUtils.getOrCreatePin((Action)action, UMLElementTypes.INPUT_PIN, UMLPackage.eINSTANCE.getReadIsClassifiedObjectAction_Object(), "object");
        OutputPin result = (OutputPin)PinUtils.getOrCreatePin((Action)action, UMLElementTypes.OUTPUT_PIN, UMLPackage.eINSTANCE.getReadIsClassifiedObjectAction_Result(), "result");
        RequestUtils.setFeatureWithRequest((EObject)result, UMLPrimitiveTypesUtils.getBoolean((Element)result), (EStructuralFeature)UMLPackage.eINSTANCE.getTypedElement_Type());
    }

    public static void updateReadExtentActionPins(ReadExtentAction action) {
        OutputPin result = (OutputPin)PinUtils.getOrCreatePin((Action)action, UMLElementTypes.OUTPUT_PIN, UMLPackage.eINSTANCE.getReadExtentAction_Result(), "result");
        RequestUtils.setFeatureWithRequest((EObject)result, action.getClassifier(), (EStructuralFeature)UMLPackage.eINSTANCE.getTypedElement_Type());
        result.setLower(0);
        result.setUpper(-1);
    }

    public static void updateCreateObjectActionPins(CreateObjectAction action) {
        OutputPin result = (OutputPin)PinUtils.getOrCreatePin((Action)action, UMLElementTypes.OUTPUT_PIN, UMLPackage.eINSTANCE.getCreateObjectAction_Result(), "result");
        RequestUtils.setFeatureWithRequest((EObject)result, action.getClassifier(), (EStructuralFeature)UMLPackage.eINSTANCE.getTypedElement_Type());
    }

    public static void updateReduceActionPins(ReduceAction action) {
        InputPin collection = (InputPin)PinUtils.getOrCreatePin((Action)action, UMLElementTypes.INPUT_PIN, UMLPackage.eINSTANCE.getReduceAction_Collection(), "collection");
        OutputPin result = (OutputPin)PinUtils.getOrCreatePin((Action)action, UMLElementTypes.OUTPUT_PIN, UMLPackage.eINSTANCE.getReduceAction_Result(), "result");
        Behavior reducer = action.getReducer();
        if (reducer != null) {
            if (!reducer.inputParameters().isEmpty()) {
                Parameter firstParam = (Parameter)reducer.inputParameters().get(0);
                PinUtils.alignTypeIfNotCompatible((Pin)collection, firstParam.getType());
            }
            if (!reducer.outputParameters().isEmpty()) {
                Parameter firstOutput = (Parameter)reducer.outputParameters().get(0);
                PinUtils.alignTypeIfNotCompatible((Pin)result, firstOutput.getType());
            }
        }
    }

    public static void updateClearAssocationActionPins(ClearAssociationAction action) {
        PinUtils.getOrCreatePin((Action)action, UMLElementTypes.INPUT_PIN, UMLPackage.eINSTANCE.getClearAssociationAction_Object(), "object");
    }

    public static void updateCreateLinkAction(CreateLinkAction action, Association association) {
    }

    public static void updateReadLinkAction(ReadLinkAction action, Association association) {
    }

    public static void updateDestroyLinkAction(DestroyLinkAction action, Association association) {
    }

    private static void destroyIfExists(EObject objectToDestroy) {
        if (objectToDestroy != null) {
            RequestUtils.deleteObjectWithRequest(objectToDestroy);
        }
    }

    private static <T extends Pin> T getOrCreatePin(Action action, IHintedType pinType, EReference containingFeature, String name) {
        Object result = action.eGet((EStructuralFeature)containingFeature);
        if (!(result instanceof Pin)) {
            result = RequestUtils.createElementWithRequest((EObject)action, (IElementType)pinType, containingFeature);
            ((Pin)result).setName(name);
        }
        return (T)((Pin)result);
    }

    private static void updateTargetPin(InvocationAction invocationAction, Classifier targetPinTheoriticalType) {
        EStructuralFeature targetFeature = invocationAction.eClass().getEStructuralFeature("target");
        InputPin targetInputPin = (InputPin)PinUtils.getOrCreatePin((Action)invocationAction, UMLElementTypes.INPUT_PIN, (EReference)targetFeature, "target");
        PinUtils.alignTypeIfNotCompatible((Pin)targetInputPin, (Type)targetPinTheoriticalType);
    }

    private static void alignPinsWithTypedElements(EObject objectWithPins, List<? extends TypedElement> typedElements, List<? extends Pin> pins, IHintedType pinType, EReference containmentFeature) {
        int index = 0;
        while (index < typedElements.size()) {
            TypedElement param = typedElements.get(index);
            Pin argument = index >= pins.size() ? (Pin)RequestUtils.createElementWithRequest(objectWithPins, (IElementType)pinType, containmentFeature) : pins.get(index);
            PinUtils.alignPinWithTypedElement(argument, param);
            ++index;
        }
        PinUtils.destroyObjectsAfterIndex(pins, index);
    }

    private static void alignPinWithTypedElement(Pin pin, TypedElement typedElement) {
        String name = typedElement.getName();
        if (name != null) {
            pin.setName(name);
        }
        PinUtils.alignTypeIfNotCompatible(pin, typedElement.getType());
        if (pin instanceof MultiplicityElement) {
            pin.setIsOrdered(((MultiplicityElement)typedElement).isOrdered());
            pin.setUpper(((MultiplicityElement)typedElement).getUpper());
            pin.setUpperBound((ValueSpecification)EcoreUtil.copy((EObject)((MultiplicityElement)typedElement).getUpperValue()));
            pin.setLower(((MultiplicityElement)typedElement).getLower());
        }
    }

    private static void alignTypeIfNotCompatible(Pin pin, Type typeToComplyWith) {
        Type pinType = pin.getType();
        if (typeToComplyWith != null) {
            if (pinType == null || !pinType.isCompatibleWith((ParameterableElement)typeToComplyWith)) {
                RequestUtils.setFeatureWithRequest((EObject)pin, typeToComplyWith, (EStructuralFeature)UMLPackage.eINSTANCE.getTypedElement_Type());
            }
        } else if (pinType != null) {
            RequestUtils.setFeatureWithRequest((EObject)pin, null, (EStructuralFeature)UMLPackage.eINSTANCE.getTypedElement_Type());
        }
    }

    private static Classifier getTargetPinTheoriticalType(CallOperationAction callOperationAction) {
        Port onPort = callOperationAction.getOnPort();
        if (onPort != null) {
            return (Classifier)onPort.getOwner();
        }
        Operation operation = callOperationAction.getOperation();
        return (Classifier)operation.getOwner();
    }

    private static Classifier getTargetPinTheoriticalType(SendSignalAction sendSignalAction) {
        Port onPort = sendSignalAction.getOnPort();
        if (onPort != null) {
            return (Classifier)onPort.getOwner();
        }
        return null;
    }

    private static void destroyObjectsAfterIndex(List<? extends EObject> collection, int index) {
        ArrayList<EObject> objectToDelete = new ArrayList<EObject>();
        while (index < collection.size()) {
            objectToDelete.add(collection.get(index));
            ++index;
        }
        RequestUtils.deleteObjectsWithRequest(objectToDelete);
    }
}

