/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.datavisualization.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.moka.datavisualization.profile.DataSource;
import org.eclipse.papyrus.moka.datavisualization.profile.ValueSeries;
import org.eclipse.papyrus.moka.datavisualization.service.DataSourceVariableID;
import org.eclipse.papyrus.moka.xygraph.model.xygraph.AxisDescriptor;
import org.eclipse.papyrus.moka.xygraph.model.xygraph.ColorDescriptor;
import org.eclipse.papyrus.moka.xygraph.model.xygraph.FontDescriptor;
import org.eclipse.papyrus.moka.xygraph.model.xygraph.LinearScale_Orientation;
import org.eclipse.papyrus.moka.xygraph.model.xygraph.TraceDescriptor;
import org.eclipse.papyrus.moka.xygraph.model.xygraph.Trace_TraceType;
import org.eclipse.papyrus.moka.xygraph.model.xygraph.XYGraphDescriptor;
import org.eclipse.papyrus.moka.xygraph.model.xygraph.XYGraphFactory;

public class GraphBuilderHelper {
    static final int[][] colors;
    static final Trace_TraceType[] types;

    static {
        int[][] nArrayArray = new int[9][];
        nArrayArray[0] = new int[]{21, 21, 196};
        nArrayArray[1] = new int[]{242, 26, 26};
        nArrayArray[2] = new int[]{33, 179, 33};
        int[] nArray = new int[3];
        nArray[0] = 255;
        nArray[1] = 170;
        nArrayArray[3] = nArray;
        int[] nArray2 = new int[3];
        nArray2[0] = 255;
        nArray2[2] = 240;
        nArrayArray[4] = nArray2;
        nArrayArray[5] = new int[]{243, 132, 132};
        int[] nArray3 = new int[3];
        nArray3[1] = 255;
        nArray3[2] = 11;
        nArrayArray[6] = nArray3;
        nArrayArray[7] = new int[]{114, 40, 3};
        nArrayArray[8] = new int[]{219, 128, 4};
        colors = nArrayArray;
        types = new Trace_TraceType[]{Trace_TraceType.SOLID_LINE, Trace_TraceType.DASHDOT_LINE, Trace_TraceType.DOT_LINE};
    }

    private static ColorDescriptor makeColor(int r, int g, int b) {
        ColorDescriptor color = XYGraphFactory.eINSTANCE.createColorDescriptor();
        color.setR(r);
        color.setG(g);
        color.setB(b);
        return color;
    }

    private static FontDescriptor makeFontDescriptor(String name, int size, int style) {
        FontDescriptor fd = XYGraphFactory.eINSTANCE.createFontDescriptor();
        fd.setName(name);
        fd.setSize(size);
        fd.setStyle(style);
        return fd;
    }

    public static TraceDescriptor buildTraceFor(XYGraphDescriptor xyDesc, ValueSeries serie) {
        String traceName = serie.getBase_Property().getLabel();
        DataSourceVariableID traceID = new DataSourceVariableID(serie);
        int added = xyDesc.getTraceDescriptors().size();
        TraceDescriptor tDesc = XYGraphFactory.eINSTANCE.createTraceDescriptor();
        tDesc.setXAxis((AxisDescriptor)xyDesc.getAxisDescriptors().get(0));
        tDesc.setYAxis((AxisDescriptor)xyDesc.getAxisDescriptors().get(1));
        tDesc.setName(traceName);
        if (traceID instanceof DataSourceVariableID) {
            tDesc.setDataSource((EObject)serie);
        }
        tDesc.setTraceColor(GraphBuilderHelper.makeColor(colors[added % colors.length][0], colors[added % colors.length][1], colors[added % colors.length][2]));
        tDesc.setTraceType(types[added / colors.length % types.length]);
        return tDesc;
    }

    public static void separateValueSeries(List<ValueSeries> series, List<ValueSeries> indep, List<ValueSeries> dep) {
        for (ValueSeries vs : series) {
            if (vs.getDependent() == null) {
                indep.add(vs);
                continue;
            }
            dep.add(vs);
        }
    }

    public static XYGraphDescriptor buildFromSeries(DataSource dataSource, List<ValueSeries> visibles) {
        ArrayList<ValueSeries> independent = new ArrayList<ValueSeries>();
        ArrayList<ValueSeries> dependent = new ArrayList<ValueSeries>();
        GraphBuilderHelper.separateValueSeries((List<ValueSeries>)dataSource.getSeries(), independent, dependent);
        if (independent.size() != 1) {
            throw new UnsupportedOperationException("For the moment there can only be one independent value series");
        }
        ValueSeries ind = independent.get(0);
        XYGraphDescriptor xy = XYGraphFactory.eINSTANCE.createXYGraphDescriptor();
        xy.setTitle("CSV-Graph");
        xy.setTitleFont(GraphBuilderHelper.makeFontDescriptor("Segoe UI", 16, 1));
        xy.setPlotAreaBackgroundColor(GraphBuilderHelper.makeColor(255, 255, 255));
        xy.setDataSource(null);
        AxisDescriptor xAxis = XYGraphFactory.eINSTANCE.createAxisDescriptor();
        xAxis.setAutoScale(false);
        xAxis.setRangeLower(1.0);
        xAxis.setRangeUpper(-1.0);
        xAxis.setOrientation(LinearScale_Orientation.HORIZONTAL);
        xAxis.setTitle(ind.getBase_Property().getLabel());
        xAxis.setFont(GraphBuilderHelper.makeFontDescriptor("Segoe UI", 12, 0));
        xAxis.setTitleFont(GraphBuilderHelper.makeFontDescriptor("Segoe UI", 12, 0));
        xy.getAxisDescriptors().add((Object)xAxis);
        AxisDescriptor yAxis = XYGraphFactory.eINSTANCE.createAxisDescriptor();
        yAxis.setAutoScale(false);
        yAxis.setRangeLower(1.0);
        yAxis.setRangeUpper(-1.0);
        yAxis.setOrientation(LinearScale_Orientation.VERTICAL);
        yAxis.setTitle("Values");
        yAxis.setFont(GraphBuilderHelper.makeFontDescriptor("Segoe UI", 12, 0));
        yAxis.setTitleFont(GraphBuilderHelper.makeFontDescriptor("Segoe UI", 12, 0));
        xy.getAxisDescriptors().add((Object)yAxis);
        for (ValueSeries serie : dependent) {
            TraceDescriptor tDesc = GraphBuilderHelper.buildTraceFor(xy, serie);
            xy.getTraceDescriptors().add((Object)tDesc);
            if (!visibles.contains(serie)) continue;
            xy.getVisibleTraces().add((Object)tDesc);
        }
        return xy;
    }
}

