/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.fmi.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class UnzipUtility {
    private static final int BUFFER_SIZE = 4096;

    public static void unzip(String zipFilePath, String destDirectory) throws IOException {
        File destDir = new File(destDirectory);
        if (!destDir.exists()) {
            destDir.mkdir();
        }
        Throwable throwable = null;
        Object var4_5 = null;
        try (ZipInputStream zipIn = new ZipInputStream(new FileInputStream(zipFilePath));){
            UnzipUtility.unzip(zipIn, destDirectory);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void unzip(ZipInputStream zipIn, String destDirectory) throws IOException {
        ZipEntry entry = zipIn.getNextEntry();
        while (entry != null) {
            String filePath = String.valueOf(destDirectory) + File.separator + entry.getName();
            boolean isDirectory = entry.isDirectory();
            String replacement = File.separator.equals("\\") ? "\\\\" : "/";
            filePath = filePath.replaceAll("/", replacement);
            filePath = filePath.replaceAll("\\\\", replacement);
            if (!isDirectory) {
                UnzipUtility.extractFile(zipIn, filePath);
            } else {
                File dir = new File(filePath);
                dir.mkdirs();
            }
            zipIn.closeEntry();
            entry = zipIn.getNextEntry();
        }
        zipIn.close();
    }

    private static void extractFile(ZipInputStream zipIn, String filePath) throws IOException {
        File outputFile = new File(filePath);
        File parent = new File(outputFile.getParent());
        if (!parent.exists()) {
            parent.mkdirs();
        }
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(filePath));
        byte[] bytesIn = new byte[4096];
        int read = 0;
        while ((read = zipIn.read(bytesIn)) != -1) {
            bos.write(bytesIn, 0, read);
        }
        bos.close();
        outputFile.setExecutable(true);
    }
}

