/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.uml.diagram.common.core.services;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import javax.swing.event.ChangeEvent;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.sirius.uml.diagram.common.core.services.AssociationClassServices;
import org.eclipse.papyrus.sirius.uml.diagram.common.core.services.AssociationServices;
import org.eclipse.papyrus.sirius.uml.diagram.common.core.services.DisplayLabelSwitch;
import org.eclipse.papyrus.sirius.uml.diagram.common.core.services.EditLabelSwitch;
import org.eclipse.uml2.uml.AcceptEventAction;
import org.eclipse.uml2.uml.ActivityFinalNode;
import org.eclipse.uml2.uml.ActivityParameterNode;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.AssociationClass;
import org.eclipse.uml2.uml.CallEvent;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.DataStoreNode;
import org.eclipse.uml2.uml.DecisionNode;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.Event;
import org.eclipse.uml2.uml.FinalState;
import org.eclipse.uml2.uml.FlowFinalNode;
import org.eclipse.uml2.uml.ForkNode;
import org.eclipse.uml2.uml.InitialNode;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.JoinNode;
import org.eclipse.uml2.uml.MergeNode;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.ParameterableElement;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Pseudostate;
import org.eclipse.uml2.uml.SignalEvent;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.TemplateParameter;
import org.eclipse.uml2.uml.TemplateSignature;
import org.eclipse.uml2.uml.TemplateableElement;
import org.eclipse.uml2.uml.TimeEvent;
import org.eclipse.uml2.uml.Trigger;

public class LabelServices {
    public static final LabelServices INSTANCE = new LabelServices();
    private static final String SPACE = " ";

    private LabelServices() {
    }

    public String association_getBeginLabel(Association association) {
        return this.computeAssociationEndLabel(AssociationServices.INSTANCE.getTargetProperty(association));
    }

    public String association_getEndLabel(Association association) {
        return this.computeAssociationEndLabel(AssociationServices.INSTANCE.getSourceProperty(association));
    }

    public String associationClass_getBeginLabel(AssociationClass associationClass) {
        return this.computeAssociationEndLabel(AssociationClassServices.INSTANCE.getTargetProperty(associationClass));
    }

    public String associationClass_getEndLabel(AssociationClass associationClass) {
        return this.computeAssociationEndLabel(AssociationClassServices.INSTANCE.getSourceProperty(associationClass));
    }

    public String computeAssociationEndLabel(Property p) {
        DisplayLabelSwitch displayLabel = new DisplayLabelSwitch();
        return displayLabel.getAssociationEndLabel(p);
    }

    public String computeDefaultName(final EObject element) {
        if (element instanceof NamedElement && ((NamedElement)element).getName() != null) {
            return ((NamedElement)element).getName();
        }
        Object predicate = null;
        String name = element.getClass().getSimpleName();
        name = name.substring(0, name.indexOf("Impl"));
        predicate = new Predicate<EObject>(){

            public boolean apply(EObject input) {
                return input.getClass().getName().equals(element.getClass().getName());
            }
        };
        if (element instanceof AssociationClass) {
            name = "AssociationClass";
        } else if (element instanceof InitialNode) {
            name = "Initial";
        } else if (element instanceof DecisionNode) {
            name = "Decision";
        } else if (element instanceof ActivityFinalNode) {
            name = "ActivityFinal";
        } else if (element instanceof StateMachine) {
            name = "StateMachine";
        } else if (element instanceof FlowFinalNode) {
            name = "FlowFinal";
        } else if (element instanceof MergeNode) {
            name = "Merge";
        } else if (element instanceof JoinNode) {
            name = "Join";
        } else if (element instanceof DataStoreNode) {
            name = "DataStore";
        } else if (element instanceof ActivityParameterNode) {
            name = "Parameter";
        } else if (element instanceof ForkNode) {
            name = "Fork";
        } else if (element instanceof EnumerationLiteral) {
            name = "EnumerationLiteral";
        } else if (element instanceof Port) {
            name = "port";
        } else if (element instanceof Property) {
            name = element.eContainingFeature().getFeatureID() == 33 ? "qualifier" : "property";
        } else if (element instanceof FinalState) {
            name = "Final";
        } else if (element instanceof Pseudostate) {
            String kind = ((Pseudostate)element).getKind().getLiteral();
            name = String.valueOf(Character.toUpperCase(kind.charAt(0))) + kind.substring(1);
        } else {
            AcceptEventAction acceptEventAction;
            EList triggers;
            if (element instanceof Association) {
                String end1 = ((Property)((Association)element).getOwnedEnds().get(0)).getName();
                String end2 = ((Property)((Association)element).getOwnedEnds().get(1)).getName();
                return String.valueOf(end1) + "To" + Character.toUpperCase(end2.charAt(0)) + end2.substring(1);
            }
            if (element instanceof InstanceSpecification) {
                String classifierName;
                predicate = new Predicate<EObject>(){

                    public boolean apply(EObject input) {
                        return input instanceof InstanceSpecification;
                    }
                };
                name = "anObject";
                EList classifiers = ((InstanceSpecification)element).getClassifiers();
                if (!classifiers.isEmpty() && (classifierName = ((Classifier)classifiers.get(0)).getName()) != null && classifierName.length() > 0) {
                    name = this.startWithVowel(classifierName) ? "an" : "a";
                    name = String.valueOf(name) + classifierName;
                }
            } else if (element instanceof AcceptEventAction && (triggers = (acceptEventAction = (AcceptEventAction)element).getTriggers()).size() > 0) {
                Trigger trigger = (Trigger)triggers.get(0);
                Event event = trigger.getEvent();
                if (event instanceof TimeEvent) {
                    name = "TimeEventAction";
                } else if (event instanceof SignalEvent) {
                    name = "SignalEventAction";
                } else if (event instanceof CallEvent) {
                    name = "CallEventAction";
                } else if (event instanceof ChangeEvent) {
                    name = "AcceptEventAction";
                }
            }
        }
        ArrayList existingElements = Lists.newArrayList((Iterable)Iterables.filter((Iterable)element.eContainer().eContents(), (Predicate)predicate));
        return String.valueOf(name) + existingElements.size();
    }

    public String computeUmlLabel(Element element) {
        DisplayLabelSwitch displayLabel = new DisplayLabelSwitch();
        if (element != null) {
            return (String)displayLabel.doSwitch((EObject)element);
        }
        return "";
    }

    public String convertBound(int bound) {
        if (bound == -1) {
            return "*";
        }
        return String.valueOf(bound);
    }

    public int convertBound(String bound) {
        if ("*".equals(bound)) {
            return -1;
        }
        try {
            return Integer.parseInt(bound);
        }
        catch (NumberFormatException e) {
            return Integer.MAX_VALUE;
        }
    }

    public Element editUmlLabel(Element context, String editedLabelContent) {
        EditLabelSwitch editLabel = new EditLabelSwitch();
        editLabel.setEditedLabelContent(editedLabelContent);
        return (Element)editLabel.doSwitch((EObject)context);
    }

    public String getTemplatedParameters(TemplateableElement object) {
        TemplateSignature ownedTemplateSignature = object.getOwnedTemplateSignature();
        StringBuffer templateParameters = new StringBuffer();
        if (ownedTemplateSignature != null) {
            EList ownedTemplateParameters = ownedTemplateSignature.getOwnedParameters();
            boolean first = true;
            for (TemplateParameter templateParameter : ownedTemplateParameters) {
                if (first) {
                    first = false;
                } else {
                    templateParameters.append(", ");
                }
                ParameterableElement parameterableElement = templateParameter.getOwnedDefault();
                if (!(parameterableElement instanceof NamedElement)) continue;
                NamedElement classTempate = (NamedElement)parameterableElement;
                templateParameters.append(classTempate.getName());
            }
            return " <" + templateParameters + ">";
        }
        return null;
    }

    public boolean isNameNotSet(Element element) {
        String label = this.computeUmlLabel(element);
        return label == null || label.isEmpty();
    }

    private boolean startWithVowel(String str) {
        boolean result = false;
        if (str != null && str.length() > 0) {
            char[] vowels;
            char[] cArray = vowels = new char[]{'a', 'e', 'i', 'o', 'u'};
            int n = vowels.length;
            int n2 = 0;
            while (n2 < n) {
                char vowel = cArray[n2];
                if (str.startsWith(Character.toString(vowel)) || str.startsWith(Character.toString(vowel).toUpperCase())) {
                    result = true;
                    break;
                }
                ++n2;
            }
        }
        return result;
    }
}

