/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.requirements.sysml14.papyrusre.modellibrary.papyrusrestandardutils.requirementclassificationconcerns;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum QualityKind implements Enumerator
{
    ADAPTABILITY(0, "Adaptability", "Adaptability"),
    AVAILABILITY(1, "Availability", "Availability"),
    COMPATABILITY(2, "Compatability", "Compatability"),
    MAINTAINABILITY(3, "Maintainability", "Maintainability"),
    PORTABILITY(4, "Portability", "Portability"),
    RELIABILITY(5, "Reliability", "Reliability"),
    SAFETY(6, "Safety", "Safety"),
    SECURITY(7, "Security", "Security"),
    USABILITY(8, "Usability", "Usability"),
    VARIABILITY(9, "Variability", "Variability");

    public static final int ADAPTABILITY_VALUE = 0;
    public static final int AVAILABILITY_VALUE = 1;
    public static final int COMPATABILITY_VALUE = 2;
    public static final int MAINTAINABILITY_VALUE = 3;
    public static final int PORTABILITY_VALUE = 4;
    public static final int RELIABILITY_VALUE = 5;
    public static final int SAFETY_VALUE = 6;
    public static final int SECURITY_VALUE = 7;
    public static final int USABILITY_VALUE = 8;
    public static final int VARIABILITY_VALUE = 9;
    private static final QualityKind[] VALUES_ARRAY;
    public static final List<QualityKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new QualityKind[]{ADAPTABILITY, AVAILABILITY, COMPATABILITY, MAINTAINABILITY, PORTABILITY, RELIABILITY, SAFETY, SECURITY, USABILITY, VARIABILITY};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static QualityKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            QualityKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static QualityKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            QualityKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static QualityKind get(int value) {
        switch (value) {
            case 0: {
                return ADAPTABILITY;
            }
            case 1: {
                return AVAILABILITY;
            }
            case 2: {
                return COMPATABILITY;
            }
            case 3: {
                return MAINTAINABILITY;
            }
            case 4: {
                return PORTABILITY;
            }
            case 5: {
                return RELIABILITY;
            }
            case 6: {
                return SAFETY;
            }
            case 7: {
                return SECURITY;
            }
            case 8: {
                return USABILITY;
            }
            case 9: {
                return VARIABILITY;
            }
        }
        return null;
    }

    private QualityKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

