/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.simplifiedui.navigator;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.papyrus.infra.services.navigation.service.NavigableElement;
import org.eclipse.papyrus.infra.services.navigation.service.NavigationContributor;
import org.eclipse.papyrus.robotics.core.utils.InteractionUtils;
import org.eclipse.papyrus.robotics.profile.robotics.commpattern.CommunicationPattern;
import org.eclipse.papyrus.robotics.simplifiedui.navigator.CommObjNavigableElement;
import org.eclipse.papyrus.robotics.simplifiedui.navigator.CommPatternNavigableElement;
import org.eclipse.papyrus.uml.tools.utils.UMLUtil;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Type;

public class RMSNavigationContributor
implements NavigationContributor {
    public List<NavigableElement> getNavigableElements(Object fromElement) {
        LinkedList<NavigableElement> result = new LinkedList<NavigableElement>();
        Element element = UMLUtil.resolveUMLElement((Object)fromElement);
        if (element instanceof Port) {
            Port port = (Port)element;
            for (Type commObject : InteractionUtils.getCommObjects((Port)port)) {
                result.add((NavigableElement)new CommObjNavigableElement(commObject));
            }
            CommunicationPattern pattern = InteractionUtils.getCommunicationPattern((Port)port);
            if (pattern != null) {
                result.add((NavigableElement)new CommPatternNavigableElement((Type)pattern.getBase_Collaboration()));
            }
        } else if (element instanceof Connector) {
            Connector connector = (Connector)element;
            for (Type commObject : InteractionUtils.getCommObjects((Connector)connector)) {
                result.add((NavigableElement)new CommObjNavigableElement(commObject));
            }
            CommunicationPattern pattern = InteractionUtils.getCommunicationPattern((Connector)connector);
            if (pattern != null) {
                result.add((NavigableElement)new CommPatternNavigableElement((Type)pattern.getBase_Collaboration()));
            }
        }
        return result;
    }
}

