/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.parameters.instancevalue;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.edit.EditConfigAttributes;
import org.eclipse.nebula.widgets.nattable.edit.editor.ICellEditor;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.painter.cell.TextPainter;
import org.eclipse.papyrus.infra.nattable.celleditor.TextCellEditor;
import org.eclipse.papyrus.infra.nattable.celleditor.config.ICellAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.utils.AxisUtils;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.uml2.uml.Property;

public class InstanceValueTableCellAxisConfiguration
implements ICellAxisConfiguration {
    public String getConfigurationId() {
        return "InstanceValueTable.id";
    }

    public String getConfigurationDescription() {
        return "Instance value table";
    }

    public boolean handles(Table table, Object axisElement) {
        String type = table.getTableConfiguration().getType();
        return type.equals("InstanceValueTable");
    }

    public void configureCellEditor(IConfigRegistry configRegistry, Object axis, String configLabel) {
        Object axisElement = AxisUtils.getRepresentedElement((Object)axis);
        configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)this.getCellEditor(configRegistry, axisElement, configLabel), "EDIT", configLabel);
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)new InstanceValuePainter(), "NORMAL", configLabel);
    }

    protected ICellEditor getCellEditor(IConfigRegistry configRegistry, Object axis, String configLabel) {
        return new TextCellEditor(true);
    }

    private class InstanceValuePainter
    extends TextPainter {
        private InstanceValuePainter() {
        }

        public void paintCell(ILayerCell cell, GC gc, Rectangle bounds, IConfigRegistry configRegistry) {
            Object dataValue = cell.getDataValue();
            boolean defaultValue = true;
            if (dataValue instanceof EObject) {
                defaultValue = ((EObject)dataValue).eContainer() instanceof Property;
            }
            if (!defaultValue) {
                Color originalBackground = gc.getBackground();
                int originalAlpha = gc.getAlpha();
                super.paintCell(cell, gc, bounds, configRegistry);
                gc.setBackground(new Color(null, 255, 255, 0));
                gc.setAlpha(100);
                gc.fillRectangle(bounds);
                gc.setAlpha(originalAlpha);
                gc.setBackground(originalBackground);
            } else {
                super.paintCell(cell, gc, bounds, configRegistry);
            }
        }
    }
}

