/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.core.provider;

import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.papyrus.infra.widgets.providers.DelegatingLabelProvider;
import org.eclipse.papyrus.robotics.core.utils.FileExtensions;
import org.eclipse.papyrus.robotics.core.utils.IconUtils;
import org.eclipse.papyrus.robotics.profile.robotics.components.ComponentPort;
import org.eclipse.papyrus.robotics.profile.robotics.functions.Function;
import org.eclipse.swt.graphics.Image;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.util.UMLUtil;

public class RoboticsLabelProvider
extends DelegatingLabelProvider {
    public RoboticsLabelProvider(ILabelProvider delegate) {
        super(delegate);
    }

    protected Image customGetImage(Object element) {
        if (element == "Workspace matches") {
            return IconUtils.getIcon("platform:/plugin/org.eclipse.papyrus.robotics.diagrams/icons/toplevel/workspace.png");
        }
        if (element == "Models via pathmaps") {
            return IconUtils.getIcon("platform:/plugin/org.eclipse.papyrus.robotics.diagrams/icons/toplevel/plugins.png");
        }
        if (element == "Model matches") {
            return IconUtils.getIcon("platform:/plugin/org.eclipse.papyrus.robotics.diagrams/icons/toplevel/model.png");
        }
        if (element instanceof URI) {
            URI uri = (URI)element;
            if (uri.segmentCount() == 0 || uri.segment(0).length() == 0) {
                return IconUtils.getIcon("platform:/plugin/org.eclipse.papyrus.robotics.diagrams/icons/toplevel/plugins.png");
            }
            String imagePath = FileExtensions.getImagePath(uri);
            if (imagePath != null) {
                return IconUtils.getIcon(imagePath);
            }
        }
        return null;
    }

    protected String customGetText(Object element) {
        Type fctCandidate;
        Function function;
        if (element instanceof URI) {
            URI uri = (URI)element;
            String extension = FileExtensions.getExtension(uri);
            if (extension != null) {
                String name = uri.lastSegment();
                return name;
            }
            String uriStr = uri.toString();
            if (uriStr.startsWith("pathmap")) {
                return uriStr.substring(10);
            }
        } else if (element instanceof ComponentPort) {
            Port port = ((ComponentPort)element).getBase_Port();
            if (port.getProvideds().size() > 0) {
                return String.format("%s provides %s", port.getName(), ((Interface)port.getProvideds().get(0)).getName());
            }
            if (port.getRequireds().size() > 0) {
                return String.format("%s requires %s", port.getName(), ((Interface)port.getRequireds().get(0)).getName());
            }
            return port.getName();
        }
        if (element instanceof Property && (function = (Function)UMLUtil.getStereotypeApplication((Element)(fctCandidate = ((Property)element).getType()), Function.class)) != null) {
            return String.format("%s (%s)", fctCandidate.getName(), function.getKind());
        }
        return null;
    }
}

