/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.core.utils;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.robotics.profile.robotics.commpattern.CommunicationPattern;
import org.eclipse.papyrus.robotics.profile.robotics.components.ComponentPort;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.ParameterableElement;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.TemplateBinding;
import org.eclipse.uml2.uml.TemplateParameter;
import org.eclipse.uml2.uml.TemplateParameterSubstitution;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.util.UMLUtil;

public class InteractionUtils {
    public static final String QUERY = "Query";
    public static final String PUSH = "Push";
    public static final String SEND = "Send";
    public static final String EVENT = "Event";
    public static final String ACTION = "Action";

    public static List<Type> getCommObjects(Port port) {
        return InteractionUtils.getCommObjects(InteractionUtils.getTemplateBinding(port));
    }

    public static List<Type> getCommObjects(Connector connector) {
        return InteractionUtils.getCommObjects(InteractionUtils.getTemplateBinding(connector));
    }

    public static Type getCommObject(Port port) {
        return InteractionUtils.getCommObject(InteractionUtils.getTemplateBinding(port));
    }

    public static Type getCommObject(Connector connector) {
        return InteractionUtils.getCommObject(InteractionUtils.getTemplateBinding(connector));
    }

    public static Type getCommObject(TemplateBinding tb) {
        if (InteractionUtils.getCommObjects(tb).size() > 0) {
            return InteractionUtils.getCommObjects(tb).get(0);
        }
        return null;
    }

    public static List<Type> getCommObjects(TemplateBinding tb) {
        ParameterableElement pe;
        ArrayList<Type> commObjects = new ArrayList<Type>();
        if (tb != null && tb.getParameterSubstitutions().size() > 0 && (pe = ((TemplateParameterSubstitution)tb.getParameterSubstitutions().get(0)).getActual()) instanceof Type) {
            commObjects.add((Type)pe);
        }
        return commObjects;
    }

    public static CommunicationPattern getCommunicationPattern(Connector connector) {
        TemplateBinding tb = InteractionUtils.getTemplateBinding(connector);
        return tb != null ? InteractionUtils.getCommunicationPattern(tb) : null;
    }

    public static CommunicationPattern getCommunicationPattern(Port port) {
        TemplateBinding tb = InteractionUtils.getTemplateBinding(port);
        return tb != null ? InteractionUtils.getCommunicationPattern(tb) : null;
    }

    public static CommunicationPattern getCommunicationPattern(TemplateBinding tb) {
        CommunicationPattern cp;
        Element pattern;
        if (tb != null && (pattern = tb.getSignature().getOwner()) != null && (cp = (CommunicationPattern)UMLUtil.getStereotypeApplication((Element)pattern, CommunicationPattern.class)) != null) {
            return cp;
        }
        return null;
    }

    public static String getPatternName(CommunicationPattern pattern) {
        if (pattern != null && pattern.getBase_Collaboration() != null) {
            return pattern.getBase_Collaboration().getName();
        }
        return null;
    }

    public static TemplateBinding getTemplateBinding(Connector connector) {
        if (connector.getEnds().size() >= 2) {
            ConnectableElement role1 = ((ConnectorEnd)connector.getEnds().get(0)).getRole();
            ConnectableElement role2 = ((ConnectorEnd)connector.getEnds().get(1)).getRole();
            if (role1 instanceof Port && StereotypeUtil.isApplied((Element)role1, ComponentPort.class)) {
                return InteractionUtils.getTemplateBinding((Port)role1);
            }
            if (role2 instanceof Port && StereotypeUtil.isApplied((Element)role2, ComponentPort.class)) {
                return InteractionUtils.getTemplateBinding((Port)role2);
            }
        }
        return null;
    }

    public static TemplateBinding getTemplateBinding(Interface intf) {
        Classifier targetCl;
        Dependency d;
        Interface target = intf;
        if (intf.getClientDependencies().size() > 0 && (d = (Dependency)intf.getClientDependencies().get(0)).getTargets().size() > 0) {
            target = (Element)d.getTargets().get(0);
        }
        if (target instanceof Classifier && (targetCl = (Classifier)target).getTemplateBindings().size() > 0) {
            return (TemplateBinding)targetCl.getTemplateBindings().get(0);
        }
        return null;
    }

    public static TemplateBinding getTemplateBinding(Port port) {
        if (port.getProvideds().size() > 0) {
            return InteractionUtils.getTemplateBinding((Interface)port.getProvideds().get(0));
        }
        if (port.getRequireds().size() > 0) {
            return InteractionUtils.getTemplateBinding((Interface)port.getRequireds().get(0));
        }
        return null;
    }

    public static String getTPName(TemplateParameter tp) {
        if (tp.getParameteredElement() instanceof NamedElement) {
            return ((NamedElement)tp.getParameteredElement()).getName();
        }
        return null;
    }

    public static Interface getServiceDefinition(TemplateBinding tb) {
        Element owner = tb.getOwner();
        return owner instanceof Interface ? (Interface)owner : null;
    }

    public static Interface getServiceDefinition(Port port) {
        TemplateBinding tb = InteractionUtils.getTemplateBinding(port);
        if (tb != null) {
            return InteractionUtils.getServiceDefinition(tb);
        }
        return null;
    }

    public static List<DataType> getMessages(Package messagePkg) {
        ArrayList<DataType> dtList = new ArrayList<DataType>();
        for (PackageableElement pe : messagePkg.getPackagedElements()) {
            if (pe instanceof Package) {
                dtList.addAll(InteractionUtils.getMessages((Package)pe));
                continue;
            }
            if (!(pe instanceof DataType)) continue;
            DataType dt = (DataType)pe;
            TemplateBinding tb = InteractionUtils.getTemplateBinding(dt);
            CommunicationPattern pattern = InteractionUtils.getCommunicationPattern(tb);
            boolean pushSendOrNone = true;
            if (pattern != null) {
                boolean bl = pushSendOrNone = InteractionUtils.isPush(pattern) || InteractionUtils.isSend(pattern);
            }
            if (!pushSendOrNone) continue;
            dtList.add(dt);
        }
        return dtList;
    }

    public static List<Interface> getSends(Package messagePkg) {
        return InteractionUtils.getServiceDefinitions(messagePkg, SEND);
    }

    public static List<Interface> getQueries(Package messagePkg) {
        return InteractionUtils.getServiceDefinitions(messagePkg, QUERY);
    }

    public static List<Interface> getActions(Package messagePkg) {
        return InteractionUtils.getServiceDefinitions(messagePkg, ACTION);
    }

    public static List<Interface> getServiceDefinitions(Package messagePkg, String filterPattern) {
        ArrayList<Interface> sdList = new ArrayList<Interface>();
        for (PackageableElement pe : messagePkg.getPackagedElements()) {
            String patternName;
            CommunicationPattern pattern;
            Interface sd;
            TemplateBinding tb;
            if (pe instanceof Package) {
                sdList.addAll(InteractionUtils.getServiceDefinitions((Package)pe, filterPattern));
                continue;
            }
            if (!(pe instanceof Interface) || (tb = InteractionUtils.getTemplateBinding(sd = (Interface)pe)) == null || (pattern = InteractionUtils.getCommunicationPattern(tb)) == null || !(patternName = InteractionUtils.getPatternName(pattern)).equals(filterPattern) || sdList.contains(sd)) continue;
            sdList.add(sd);
        }
        return sdList;
    }

    public static boolean isPush(CommunicationPattern cp) {
        return PUSH.equals(InteractionUtils.getPatternName(cp));
    }

    public static boolean isSend(CommunicationPattern cp) {
        return SEND.equals(InteractionUtils.getPatternName(cp));
    }

    public static boolean isQuery(CommunicationPattern cp) {
        return QUERY.equals(InteractionUtils.getPatternName(cp));
    }

    public static boolean isEvent(CommunicationPattern cp) {
        return EVENT.equals(InteractionUtils.getPatternName(cp));
    }

    public static boolean isAction(CommunicationPattern cp) {
        return ACTION.equals(InteractionUtils.getPatternName(cp));
    }

    public static TemplateBinding getTemplateBinding(DataType commObject) {
        for (EStructuralFeature.Setting setting : UMLUtil.getNonNavigableInverseReferences((EObject)commObject)) {
            EObject eObj = setting.getEObject();
            if (!(eObj instanceof TemplateParameterSubstitution)) continue;
            TemplateParameterSubstitution tps = (TemplateParameterSubstitution)eObj;
            return tps.getTemplateBinding();
        }
        return null;
    }

    public static String getConnectorLabel(Connector connector) {
        String names = null;
        TemplateBinding tb = InteractionUtils.getTemplateBinding(connector);
        if (tb != null) {
            for (TemplateParameterSubstitution tps : tb.getParameterSubstitutions()) {
                ParameterableElement pe = tps.getActual();
                if (!(pe instanceof NamedElement)) continue;
                String name = ((NamedElement)pe).getName();
                String string = names = names == null ? name : String.valueOf(names) + ", " + name;
            }
        }
        return names != null ? names : "";
    }
}

