/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.assertions.types.advice;

import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.papyrus.infra.emf.gmf.command.EMFtoGMFCommandWrapper;
import org.eclipse.papyrus.robotics.assertions.profile.assertions.Property;
import org.eclipse.papyrus.robotics.assertions.profile.util.AssertionsResource;
import org.eclipse.papyrus.robotics.core.commands.CancelCommand;
import org.eclipse.papyrus.robotics.core.menu.EnhancedPopupMenu;
import org.eclipse.papyrus.robotics.core.types.advice.AbstractApplyStereotypeEditHelperAdvice;
import org.eclipse.papyrus.uml.tools.providers.UMLContentProvider;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;

public class PropertyAdvice
extends AbstractApplyStereotypeEditHelperAdvice {
    private static final String PARAMETER = "Parameter";

    protected ICommand getAfterConfigureCommand(ConfigureRequest request) {
        CompositeCommand compositeCommand = new CompositeCommand("Configure Property");
        EObject newElement = request.getElementToConfigure();
        if (!(newElement instanceof org.eclipse.uml2.uml.Property)) {
            return super.getAfterConfigureCommand(request);
        }
        final org.eclipse.uml2.uml.Property property = (org.eclipse.uml2.uml.Property)newElement;
        UMLContentProvider cpWithWS = new UMLContentProvider((EObject)property, (EStructuralFeature)UMLPackage.eINSTANCE.getTypedElement_Type());
        EnhancedPopupMenu.SubSelect serviceDef = new EnhancedPopupMenu.SubSelect("Select parameter type", (IStructuredContentProvider)cpWithWS);
        Object value = serviceDef.getResult();
        if (!(value instanceof Classifier)) {
            return new CancelCommand((EObject)property);
        }
        final Classifier newType = (Classifier)value;
        RecordingCommand defaultValue = new RecordingCommand(TransactionUtil.getEditingDomain((EObject)newElement)){

            protected void doExecute() {
                property.setType((Type)newType);
                OpaqueExpression oe = UMLFactory.eINSTANCE.createOpaqueExpression();
                property.setDefaultValue((ValueSpecification)oe);
                oe.getLanguages().add((Object)PropertyAdvice.PARAMETER);
                oe.getBodies().add((Object)"");
            }
        };
        compositeCommand.add((IUndoableOperation)EMFtoGMFCommandWrapper.wrap((Command)defaultValue));
        return compositeCommand.isEmpty() ? super.getAfterConfigureCommand(request) : compositeCommand;
    }

    protected URI getProfileURI() {
        return AssertionsResource.PROFILE_PATH_URI;
    }

    protected Class<? extends EObject> stereotypeToApply() {
        return Property.class;
    }
}

