/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.robotics.bt.types.utils.uml;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.papyrus.robotics.bt.types.utils.uml.IPinUpdater;
import org.eclipse.papyrus.robotics.bt.types.utils.uml.UpdaterPinUtils;
import org.eclipse.papyrus.uml.diagram.common.util.Util;
import org.eclipse.uml2.uml.Action;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.ActivityEdge;
import org.eclipse.uml2.uml.ActivityPartition;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Pin;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.StructuredActivityNode;
import org.eclipse.uml2.uml.Type;

public abstract class AbstractActionPinUpdater<NodeType extends Action>
implements IPinUpdater<NodeType> {
    protected PrimitiveType getUMLPrimitiveType(String typeName, Model model) {
        PrimitiveType primitiveType = null;
        if (UpdaterPinUtils.isPrimitiveTypeLibraryImported((Element)model)) {
            Package primitiveTypePackage = UpdaterPinUtils.getPrimitiveTypesPackage((Element)model);
            for (Type type : primitiveTypePackage.getOwnedTypes()) {
                if (!(type instanceof PrimitiveType) || !type.getName().equals(typeName)) continue;
                primitiveType = (PrimitiveType)type;
            }
        }
        return primitiveType;
    }

    protected static void deleteEdges(Pin pin) {
        ArrayList edgeToDelete = new ArrayList(pin.getIncomings());
        edgeToDelete.addAll(pin.getOutgoings());
        for (ActivityEdge edge : edgeToDelete) {
            Element owner = edge.getOwner();
            if (owner == null) continue;
            if (owner instanceof StructuredActivityNode) {
                ((StructuredActivityNode)owner).getEdges().remove((Object)edge);
                continue;
            }
            if (owner instanceof Activity) {
                ((Activity)owner).getEdges().remove((Object)edge);
                continue;
            }
            if (!(owner instanceof ActivityPartition)) continue;
            ((ActivityPartition)owner).getEdges().remove((Object)edge);
        }
    }

    protected static Classifier getFirstCommonSuperClassifier(List<Classifier> classifiers) {
        ArrayList<Classifier> commonSuperClassifier = new ArrayList<Classifier>(Util.getAllSuperClasses(null, (Classifier)classifiers.get(0)));
        commonSuperClassifier.add(classifiers.get(0));
        HashSet<Classifier> nonCommonClassifier = new HashSet<Classifier>();
        for (Classifier c : classifiers) {
            for (Classifier c2 : commonSuperClassifier) {
                if (Util.getAllSuperClasses(null, (Classifier)c).contains(c2) || c == c2) continue;
                nonCommonClassifier.add(c2);
            }
        }
        commonSuperClassifier.removeAll(nonCommonClassifier);
        for (Classifier classifier : commonSuperClassifier) {
            ArrayList<Classifier> inheritedClassifier = new ArrayList<Classifier>(Util.getAllSuperClasses(null, (Classifier)classifier));
            inheritedClassifier.add(classifier);
            if (!inheritedClassifier.containsAll(commonSuperClassifier)) continue;
            return classifier;
        }
        return null;
    }
}

